package ca.tecreations;

import ca.tecreations.net.SharedCode;

import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author Tim
 */
public class StringTool {
    public static final String SN = StringTool.class.getSimpleName();
    public static final String LOWERCASE = "abcdefghijklmnopqrstuvwxyz";
    public static final String UPPERCASE = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final char ESC = (char) 27; // ANSI code #
    public static final String NEW_LINE = "\n";
    public static final String RETURN = "\r";
    public static final String DOT = ".";
    public static final String DOTE = ".";
    public static final String DOUBLE_DOT = "..";
    public static final String DOUBLE_DOT_DELICIOUS = "...";
    public static final String ELLIPSIS = "...";
    public static final String COMMA = ",";
    public static final String SEMICOLON = ";";
    public static final String BACKTICK = "`";
    public static final String DOUBLE_QUOTE = "\"";
    public static final String SINGLE_QUOTE = "'";
    public static final String LEFT_PARENTHESIS = "(";
    public static final String RIGHT_PARENTHESIS = ")";
    public static final String LEFT_CURLY_BRACE = "{";
    public static final String RIGHT_CURLY_BRACE = "}";
    public static final String LEFT_SQUARE_BRACKET = "[";
    public static final String RIGHT_SQUARE_BRACKET = "]";
    
    public static String concatenate(List<String> list) {
        String result = "";
        for (int i = 0; i < list.size(); i++) {
            result += list.get(i);
        }
        return result;
    }

    public static String concatenateWithNewLines(List<String> list) {
        String result = "";
        for (int i = 0; i < list.size(); i++) {
            result += list.get(i) + "\n";
        }
        return result;
    }

    public static boolean contains(String text, char target) {
        for(int i = 0; i < text.length();i++) {
            if (text.charAt(i) == target) return true;
        }
        return false;
    }
    
    public static boolean contains(String text, String value) {
        int maxPos = text.length() - value.length();
        for(int i = 0; i <= maxPos;i++) {
            if (text.substring(i,i+value.length()).equals(value)) {
                return true;
            }
        }
        return false;
    }
    
    public static boolean containsIgnoreCase(String text, String value) {
        int maxPos = text.length() - value.length();
        if (maxPos == 0) {
            if (text.toLowerCase().equals(value.toLowerCase())) {
                return true;
            }
        } else {
            for(int i = 0; i < maxPos;i++) {
                System.out.println("Text : " + text);
                System.out.println("Value: " + value);
                String target = text.substring(i,i + value.length() - 1);
                if (target.toLowerCase().equals(value.toLowerCase())) {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean containsMatchedDoubleQuotes(String s) {
        int count = 0;
        for(int i = 0; i < s.length();i++) {
            if (s.charAt(i) == '\"') count++;
        }
        return count % 2 == 0;
    }
    
    public static int count(String s, char ch) {
        int count = 0;
        for(int i = 0;i < s.length();i++) {
            if (s.charAt(i) == ch) {
                count++;
            }
        }
        return count;
    }

    public static int countPairs(String s, char ch) {
        int count = 0;
        int pairs = 0;
        for(int i = 0;i < s.length();i++) {
            if (s.charAt(i) == ch) {
                count++;
                if (count == 2) {
                    count = 0;
                    pairs++;
                }
            }
        }
        return pairs;
    }

    // https://stackoverflow.com/questions/2406121/how-do-i-escape-a-string-in-java
    public static String escape(String s) {
        return s.replace("\\", "\\\\")
                .replace("\t", "\\t")
                .replace("\b", "\\b")
                .replace("\n", "\\n")
                .replace("\r", "\\r")
                .replace("\f", "\\f")
                .replace("\'", "\\'")
                .replace("\"", "\\\"")
                .replace("" + ESC,"^[");
    }

    public static List<String> explode(String string, char delimiter) {
        List<String> list = new ArrayList<>();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < string.length(); i++) {
            if (string.charAt(i) == delimiter) {
                list.add(buf.toString());
                buf = new StringBuffer();
            } else {
                buf.append(string.charAt(i));
            }
        }
        if (buf.length() > 0) list.add(buf.toString());
        return list;
    }
    
    public static List<String> explode(String string, String separator) {
        List<String> list = new ArrayList<>();
        if (separator.equals("")) {
            for(int i = 0;i < string.length();i++) {
                list.add(string.substring(i,i+1));
            }
            return list;
        } else {
            String remainder = string;
            for(int i = 0;;i++) {
                if (remainder.contains(separator)) {
                    int sepIndex = remainder.indexOf(separator);
                    list.add(remainder.substring(0,sepIndex));
                    remainder = remainder.substring(sepIndex + separator.length());
                } else {
                    list.add(remainder);
                    break;
                }
            }
            return list;
        }
    }
    
    public static List<String> explodeWith(String string, char delimiter) {
        List<String> list = new ArrayList<>();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < string.length(); i++) {
            if (string.charAt(i) == delimiter) {
                list.add(buf.toString());
                list.add(delimiter + "");
                buf = new StringBuffer();
            } else {
                buf.append(string.charAt(i));
            }
        }
        if (buf.length() > 0) list.add(buf.toString());
        return list;
    }
    


    public static List<String> explodeWithFiles(String string, char delimiter) {
        boolean debugMethod = false;
        if (delimiter == '\"') throw new IllegalArgumentException("ExplodeWithFiles: delimiter cannot be '\"'!");
        List<String> list = new ArrayList<String>();
        StringBuffer buf = new StringBuffer();
        char ch;
        for(int i = 0;i < string.length();i++) {
            ch = string.charAt(i);
            if (debugMethod) System.out.println("for: Processing: '" + ch + "'");
            if (ch == '\"') {
                if (debugMethod) System.out.println("Found Double Quote");
                // get to next double quote
                String next = getNextDoubleQuoted(string.substring(i));
                if (debugMethod) System.out.println("Next: (" + next + ")");
                list.add(next);
                i += next.length();
            } else if (ch == delimiter) { 
            } else if (ch == ' ' | ch == '\t') {
            } else {
                while (i < string.length() && ch != delimiter && ch != ' ' && ch != '\t') {
                    ch = string.charAt(i);
                    i++; // must increment here or the while won't continue on and receive OutOfMemoryError
                    if (debugMethod) System.out.println("while: Processing: '" + ch + "'");
                    if (ch != delimiter && ch != ' ' && ch != '\t') {
                        buf.append(ch);
                    }
                }
                if (debugMethod) System.out.println("Buf: (" + buf.toString() + ")");
                list.add(buf.toString());
                i--; // must decrease i because the loop will increment and we need the next character
                buf = new StringBuffer();
            }
        }
        return list;
    }
    
    public static List<String> getAllQuoted(String s, String delimiter) {
        List<String> parts = new ArrayList<>();
        String part;
        String remainder = s.trim();
        while (remainder.length() > 0) {
            if (remainder.length() < 2) {
                throw new IllegalArgumentException("StringTool.getAllQuoted(" + remainder + "): Malformed..., insufficient length to support wrapping: length: 1.");
            }
            if (!remainder.startsWith("\"")) {
                throw new IllegalArgumentException("StringTool.getAllQuoted(" + remainder + "): Malformed..., Does not start with doouble quote(\") or codepage doesn't match.");
            }
            if (!remainder.endsWith("\"")) {
                throw new IllegalArgumentException("StringTool.getAllQuoted(" + remainder + "): Malformed..., Does not end with doouble quote(\") or codepage doesn't match.");
            }
            try {
                part = SharedCode.getFirstQuoted(remainder);
            } catch (IllegalArgumentException iae) {
                System.err.println("StringTool.getAllQuoted(" + remainder + "): Unmatched double quote(\").");
                // if you need something like getAllQuotedWithSkipping, you will need
                // to code that, at least, for now.
                return null;
            }
            remainder = remainder.substring(part.length());
            remainder = remainder.trim();
            //System.out.println("FirstQuoted: " + part);
            //System.out.println("Remainder: '" + remainder + "'");
            remainder = remainder.trim();
            int delimIndex = remainder.indexOf(delimiter);
            //System.out.println("IndexOfDelimiter: " + delimIndex);
            if (delimIndex != -1) {
                remainder = remainder.substring(delimIndex + 1);
                remainder = remainder.trim();
            }
            parts.add(part);
        }
        return parts;
    }
    
    public static String getBackticked(String s) {
        if (!s.startsWith(BACKTICK) && !s.endsWith(BACKTICK)) {
            return BACKTICK + s + BACKTICK;
        }
        return s;
    }
    
    public static String getBackticked_Absolute(String s) {
        return BACKTICK + s + BACKTICK;
    }
    

    public static int getCommaCount(String target) {
        return getCount(target,',');
    }
    
    public static int getCount(char ch, String target) {
        int count = 0;
        for (int i = 0; i < target.length(); i++) {
            if (target.charAt(i) == ch) {
                count++;
            }
        }
        return count;
    }

    public static int getCount(String target,char ch) {
        int count = 0;
        for (int i = 0; i < target.length(); i++) {
            if (target.charAt(i) == ch) {
                count++;
            }
        }
        return count;
    }

    public static String getCurlyBraceWrapped(String s) {
        if (!s.startsWith(LEFT_CURLY_BRACE) && !s.endsWith(RIGHT_CURLY_BRACE)) {
            return LEFT_CURLY_BRACE + s + RIGHT_CURLY_BRACE;
        }
        return s;
    }
    
    public static String getCurlyBraceWrapped_Absolute(String s) {
        return LEFT_CURLY_BRACE + s + RIGHT_CURLY_BRACE;
    }
    
    public static int getDotCount(String target) {
        return getCount(target,'.');
    }
    
    public static String getDoubleQuoted(String s) {
        if (s == null || s.length() == 0) {
            return DOUBLE_QUOTE + DOUBLE_QUOTE;
        }
        if (!s.startsWith(DOUBLE_QUOTE) && !s.endsWith(DOUBLE_QUOTE)) {
            return DOUBLE_QUOTE + s + DOUBLE_QUOTE;
        }
        return s;
    }

    public static String getDoubleQuoted_Absolute(String s) {
        return DOUBLE_QUOTE + s + DOUBLE_QUOTE;
    }
    
    public static String[] getFileAndTrimmedRemainder(String line) {
        String[] array = new String[2];
        String path;
        line = line.trim();
        if (line.startsWith("\"")) {
            int secondIndex = line.indexOf("\"",1);
            if (secondIndex == -1) { // no end double-quote
                array[0] = line.trim();
                array[1] = ""; 
            } else { // first quoted chunk, a space and then anything else
                path = line.substring(0,secondIndex + 1);
                array[0] = path;
                array[1] = line.substring(secondIndex + 1).trim();
            }
        } else {
            int spaceIndex = line.indexOf(" "); 
            if (spaceIndex == -1) { // no space, so just one chunk
                array[0] = line.trim(); 
                array[1] = ""; 
            } else { // more than one arg
                array[0] = line.substring(0,spaceIndex);
                array[1] = line.substring(spaceIndex+1).trim();
            }
        }
        return array;
    }
    
    public static String getLastCharacter(String s) {
        return s.substring(s.length() - 1);
    }
    
    public static String[] getQuotedAndTrimmedRemainder(String s) {
        String[] result = new String[2];
        if (hasQuoted(s)) {
            if (s.charAt(0) == '\'') result[0] = getNextSingleQuoted(s);
            if (s.charAt(0) == '\"') result[0] = getNextDoubleQuoted(s);
        } else {
            throw new IllegalArgumentException(SN + ".getQuotedAndTrimmedRemainder: must be a single or double quoted term");
        }
        result[1] = s.substring(result[0].length());
        return result;
    }
    
    /** getNextSingleQuoted assumes the first character is the opening single quote 
     * 
     * @param original the original String
     * @return the next single quoted string, including the quotes
     */
    public static String getNextSingleQuoted(String original) {
        int secondIndex = original.indexOf('\'',1);
        if (secondIndex == -1) throw new IllegalArgumentException("getNextSingleQuoted: does not contain closing single quote: (" + original + ")");
        return original.substring(0,secondIndex + 1); // grab the quote too
    }
    
    /** getNextDoubleQuoted assumes the first character is the opening double quote 
     * 
     * @param original the original String
     * @return the next double quoted String, including the quotes
     */
    public static String getNextDoubleQuoted(String original) {
        int secondIndex = original.indexOf('\"',1);
        if (secondIndex == -1) throw new IllegalArgumentException("getNextDoubleQuoted: does not contain closing double quote: (" + original + ")");
        return original.substring(0,secondIndex + 1); // grab the quote too
    }

    public static String getNextDoubleQuoted_Unwrapped(String original) {
        return StringTool.getUnwrapped(getNextDoubleQuoted(original));
    }
    
    public static int getNextANSIEscapeIndex(String text) {
        for (int i = 1; i < text.length(); i++) {
            if (isANSIEscape(text.charAt(i))) {
                return i;
            }
        }
        return -1;
    }

    public static String getNextString(String s, int index) {
        return s.substring(index + 1);
    }

    public static String getParenthesisWrapped(String s) {
        if (!s.startsWith(LEFT_PARENTHESIS) && !s.endsWith(RIGHT_PARENTHESIS)) {
            return LEFT_PARENTHESIS + s + RIGHT_PARENTHESIS;
        }
        return s;
    }
    
    public static String getParenthesisWrapped_Absolute(String s) {
        return LEFT_PARENTHESIS + s + RIGHT_PARENTHESIS;
    }
    
    public static String getParenthesized(String s) {
        return getParenthesisWrapped(s);
    }
    
    public static String getParenthesized_Absolute(String s) {
        return getParenthesisWrapped_Absolute(s);
    }
    
    public static String getPrevString(String s, int index) {
        return s.substring(0, index);
    }

    public static String getShortestUppercase(String target) {
        String result = "";
        for(int i = 0; i < target.length();i++) {
            if (isUppercase(target.charAt(i))) {
                result += target.charAt(i);
            }
        }
        return result;
    }
    
    public static String getSingleQuoted(String s) {
        if (!s.startsWith(SINGLE_QUOTE) && !s.endsWith(SINGLE_QUOTE)) {
            s = SINGLE_QUOTE + s + SINGLE_QUOTE;
        }
        return s;
    }

    public static String getSingleQuoted_Absolute(String s) {
        return SINGLE_QUOTE + s + SINGLE_QUOTE;
    }

    public static String getSquareBracketWrapped(String s) {
        if (!s.startsWith(LEFT_SQUARE_BRACKET) && !s.endsWith(RIGHT_SQUARE_BRACKET)) {
            return LEFT_SQUARE_BRACKET + s + RIGHT_SQUARE_BRACKET;
        }
        return s;
    }

    public static String getSquareBracketWrapped_Absolute(String s) {
        return LEFT_SQUARE_BRACKET + s + RIGHT_SQUARE_BRACKET;
    }
    
    
    /** If you are wrapped with BACKTICK, DOUBLE_QUOTE,
     *  or SINGLE_QUOTE, I return unwrapped. Otherwise. The same string.
     *  Idempotent, if you are wrapped once, I'll unwrap for you, ...., for all of
     * // BACKTICK, DOUBLE_QUOTE, SINGLE_QUOTE 
     * #See COMMA, ESC, NEWLINE, RETURN, 
     * 
     * You may need to re-call the method for your parts. 
     * 
     * 
     * <a href="https://tecreations.ca/langs/comments/c-style comments">C Style Comments</a>
     * <a href="https://tecreations.ca/langs/comments/java-style-comments/">JavaDoc Comments</a>
     * <a href="https://tecreations.ca/ca/tecreations/php_stuff/bookparts.php"> You could..., put a book...</a>
     * <a href="">Maybe, put a user account, for <ani></a>
     * Call the code as much as you like. 
     * Please buy a license, forget the Single Seat -- It's all too much.,"charities",...,.
     * @param s the String in question
     * @return the unwrapped version of the String
     */



    public static String getUnwrapped(String s) {
        if (s == null) throw new IllegalArgumentException("StringTool.getUnpackaged: parameter is null");
        if (s.startsWith(BACKTICK) && s.endsWith(BACKTICK)) {
            return s.substring(1,s.length() - 1);
        } else if (s.startsWith(DOUBLE_QUOTE) && s.endsWith(DOUBLE_QUOTE)) {
            return s.substring(1,s.length() - 1);
        } else if (s.startsWith(SINGLE_QUOTE) && s.endsWith(SINGLE_QUOTE)) {
            return s.substring(1,s.length() - 1);
        } else if (s.startsWith(LEFT_PARENTHESIS) && s.endsWith(RIGHT_PARENTHESIS)) {
            return s.substring(1,s.length() - 1);
        } else if (s.startsWith(LEFT_CURLY_BRACE) && s.endsWith(RIGHT_CURLY_BRACE)) {
            return s.substring(1,s.length() - 1);
        } else if (s.startsWith(LEFT_SQUARE_BRACKET) && s.endsWith(RIGHT_SQUARE_BRACKET)) {
            return s.substring(1,s.length() - 1);
        } 
        return s;
    }
   
    public static boolean hasFile(String line) {
        //System.out.println("Line: " + line);
        line = line.trim();
        String chunk;
        if (line.startsWith("\"")) {
            chunk = line.substring(1);
        } else {
            chunk = line;
        }
        //System.out.println("Length: " + chunk.length() + " val: " + chunk);
        if (chunk.startsWith("/")) {
            return true;
        } else if (chunk.length() >= 3) {
            char drive = chunk.charAt(0);
            //System.out.println("Drive: " + drive);
            boolean validDrive = (drive >= 'A' && drive <= 'Z') | (drive >= 'a' && drive <= 'z');
            //System.out.println("Valid: " + validDrive);
            boolean isWinDrive = chunk.charAt(1) == ':' && chunk.charAt(2) == '\\';
            //System.out.println("IsWin: " + isWinDrive);
            return validDrive && isWinDrive;
        }
        return false;
    }

    public static boolean hasMatch(String s, String targets) {
        for(int i = s.length() - 1;i >= 0; i--) {
            if (StringTool.contains(targets, s.charAt(i))) return true;
        }
        return false;
    }
    
    public static boolean hasMatchTest() {
        return hasMatch("test","ts");
    }
    
    public static void main(String[] args) {
        System.out.println("?: " + hasMatchTest());
    }
    
    public static boolean hasQuoted(String s) {
        s = s.trim();
        if (s.startsWith("'") && s.indexOf("'",1) != -1) return true;
        if (s.startsWith("\"") && s.indexOf("\"",1) != -1) return true;
        return false;
    }
    
    public static boolean hasSingleQuoted(String s) {
        s = s.trim();
        if (s.startsWith("'") && s.indexOf("'",1) != -1) return true;
        return false;
    }
    
    public static boolean hasDoubleQuoted(String s) {
        s = s.trim();
        if (s.startsWith("\"") && s.indexOf("\"",1) != -1) return true;
        return false;
    }
    
    public static char[] incrementAndGetDigits(char[] digits) {
        boolean incremented = false;
        if (digits[digits.length - 1] == '9') { // so the farthest right is maxed out
            digits[digits.length - 1] = '0';

            // scan from next digit to end
            boolean _continue = true;
            for (int j = digits.length - 2; j >= 0; j--) {
                if (digits[j] == '9') {
                    digits[j] = '0';
                } else {
                    digits[j]++;
                    _continue = false;
                    incremented = true;
                }
                if (!_continue) {
                    j = -1; // go to the for statement and exit loop
                }
            }
            if (!incremented) {
                // so all the digits were '9'
                char[] temp = new char[digits.length + 1];
                temp[0] = '1';
                for (int j = 1; j < temp.length; j++) {
                    temp[j] = 0;
                }
                digits = temp;
                incremented = true;
            }
        } else {
            // increment the right-most digit
            digits[digits.length - 1]++;
            incremented = true;
        }
        return digits;
    }

    public static String incrementLongString(String s) {
        if (s == null) {
            s = "0";
        }
        char[] digits = new char[s.length()];
        for (int i = 0; i < digits.length; i++) {
            digits[i] = s.charAt(i);
        }
        // increment string of digits between 0 and 9
        digits = incrementAndGetDigits(digits);

        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < digits.length; i++) {
            buf.append(digits[i]);
        }
        return buf.toString();
    }

    public static boolean isANSIEscape(char c) {
        return c == ESC || c == 033 || c == '\u001b' || c == 0x1B;
    }
    
    public static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }
    
    public static boolean isDigits(String s) {
        for(int i = 0; i < s.length();i++) {
            if (!isDigit(s.charAt(i))) return false;
        }
        return true;
    }

    
    public static boolean isDir(String tag) {
        tag = StringTool.getUnwrapped(tag);
        return tag.endsWith("/") || tag.endsWith("\\");

    }
    
    public static boolean isBackticked(String s) {
        return s.startsWith(BACKTICK) && s.endsWith(BACKTICK);
    }
    
    public static boolean isDoubleQuoted(String s) {
        return s.startsWith(DOUBLE_QUOTE) && s.endsWith(DOUBLE_QUOTE);
    }
    
    public static boolean isLowerCase(char c) {
        return (c >= 'a' && c <= 'z');
    }
    
    public static boolean isLowercase(char c) {
        return isLowerCase(c);
    }
    
    public static boolean isOctalDigits(String s) {
        for(int i = 0; i < s.length();i++) {
            if (!(s.charAt(i) >= '0' && s.charAt(i) <= '7')) return false;
        }
        return true;
    }
    
    public static boolean isSingleQuoted(String tag) {
        return tag.startsWith(SINGLE_QUOTE) && tag.endsWith(SINGLE_QUOTE);
    }
    
    public static boolean isUpperCase(char c) {
        return (c >= 'A' && c <= 'Z');
    }
    public static boolean isUppercase(char c) {
        return isUpperCase(c);
    }
    
    public static boolean isWrapped(String s) {
        s = s.trim();
        if (s.length() < 2) return false;
        int c0 = s.charAt(0);
        int cZ = s.charAt(s.length() - 1);
        return c0 == cZ;
    }
    
    /** 
     * trims white space (' ' | '\t') from the left side of a line of text
     * @return the trimmed String
     *
     */
    public static String lTrim(String s) {
        int index = 0;
        boolean done = false;
        while (!done) {
            if (s.charAt(index) == ' ' | s.charAt(index) == '\t') {
                index++;
            } else {
                done = true;
            }
        }
        return s.substring(index);
    }

    public static String lTrim(String s, int count) {
        return s.substring(count);
    }
    
    public static String lTrim(String s, String lengthRep) {
        return s.substring(lengthRep.length());
    }
    
    public static String ltrimIf(String s, String matches) {
        if (s.startsWith(matches)) {
            return s.substring(matches.length());
        }
        return s;
    }
    
    
    /**
     *
     * @param target The String to operate on.
     * @param start The String to replace in target.
     * @param end The destination String to replace with start.
     * @return The resulting String.
     */
    public static String replace(String target, String start, String end) {
        int startIndex = target.indexOf(start);
        int endIndex = startIndex + start.length();
        String trailing = target.substring(endIndex);
        return target.substring(0, startIndex) + end + trailing;
    }

    public static void main2(String[] args) {
        System.out.println("hasFile: " + hasFile("f:\\"));
        System.exit(0);
        
        
        System.out.println("List: " + explode("F:\\projects\\jethro_$TEC$_SpawnSystemCompiler_$TEC$_","_$TEC$_"));
        
        System.out.println("Count Pairs: " + count("...,..,.,..,...,...",','));
        System.exit(0);

        String s = "\"!";
        List<String> parts = getAllQuoted(s,",");
        for(int i = 0; i < parts.size();i++) {
            System.out.println(i + ": " + parts.get(i));
        }
    }

    public static List<String> parseDoubleQuoted(String s) {
        if (!containsMatchedDoubleQuotes(s)) {
            throw new IllegalArgumentException("StringTool.parseDoubleQuoted: malformed: " + s);
        }
        List<String> result = new ArrayList<>();
        String tmp;
        int index = 0;
        int pairs = countPairs(s,'\"');
        String remainder = s.trim();
        int nextIndex;
        for(int i = 0; i < pairs;i++) {
            index = remainder.indexOf("\"");
            if (index > 0) {
                remainder = remainder.substring(index).trim();
                //System.out.println("After .substring(1): remainder: " + remainder);
            }
            index = remainder.indexOf("\"");
                   
            nextIndex = remainder.indexOf("\"",1);
            //System.out.println("Getting: " + index + " to " + nextIndex + " : " + remainder.substring(index,nextIndex+1));
            result.add(remainder.substring(index,nextIndex + 1));
            remainder = remainder.substring(nextIndex + 1);
            //System.out.println("After .substring(2): remainder: " + remainder);
        }
        return result;
    }
    
    public static String replaceAll(String src, String old, String newString) {
        String result = "";
        String remainder = src;
        while (remainder.indexOf(old) != -1) {
            int index = remainder.indexOf(old);
            String got = remainder.substring(0,index);
            result += got + newString;
            //System.out.println("result: " + result);
            remainder = remainder.substring(index + old.length()); // go to the next char
        } 
        result += remainder;
        return result;
    }    
     
    public static String replaceAll(String src, char ch, String replaceWith) {
        String result = "";
        for(int i = 0; i < src.length();i++) {
            if (src.charAt(i) == ch) result += replaceWith;
            else result += src.charAt(i);
        } 
        return result;
    }

    public static String replaceAll(String src, char ch, char replaceWith) {
        StringBuffer buf = new StringBuffer();
        if (src == null) {
            return null;
        }
        for (int i = 0; i < src.length(); i++) {
            if (src.charAt(i) == ch) {
                buf.append(replaceWith);
            } else {
                buf.append(src.charAt(i));
            }
        }
        return buf.toString();
    }

    public static String reverse(String src) {
        String s = "";
        for (int i = src.length() - 1; i >= 0; i--) {
            s += src.charAt(i);
        }
        return s;
    }

    public static String rTrim(String s, int count) {
        return s.substring(0, s.length() - count);
    }
    
    public static String rTrim(String s, String lengthRep) {
        return s.substring(0,s.length() - lengthRep.length());
    }
    
    public static String rTrimIf(String s, String matches) {
        if (s.endsWith(matches)) {
            return s.substring(0, s.length() - matches.length());
        }
        return s;
    }
    
    
    public static String rTrimIfContains(String s, String matchers) {
        int index = s.length() - 1;
        for(int i = index; i >= 0; i--) {
            boolean isMatched = false;
            for(int j = 0; j < matchers.length();j++) {
                if (matchers.charAt(j) == s.charAt(i)) { // found one of the matching characters
                    j = matchers.length();
                    isMatched = true;
                }
            }
            if (isMatched) {
              // don't do anything, just decrement index (move from right to left)
            } else {
                // not matched, our trimming is done
                return s.substring(0,index);
            }
        }
        // all characters matched, return empty string
        return "";
    }
    
    public static String trimWhitespaceL(String s) {
        int index = 0;
        if (s.length() > 0) {
            char c = s.charAt(index);
            while (index + 1 < s.length() && (c == ' ' || c == '\t')) {
                index++;
                c = s.charAt(index);
            }
            return s.substring(index);
        }
        return "";
    }

    
}
