package ca.tecreations.lang.java;

import ca.tecreations.File;
import ca.tecreations.ProjectPath;

import java.util.ArrayList;
import java.util.List;
/**
 *
 * @author tim
 */
public class GetJarVersionsByArtifact {
    GetJarTrio trio;
    List<String> artifacts = new ArrayList<>(); 
    List<List<String>> versions = new ArrayList<>();
    
    public GetJarVersionsByArtifact(String projectPath) {
        trio = new GetJarTrio(projectPath);
        process();
    }
    
    public void process() {
        List<File> files = trio.getFiles();
        List<String> trioArtifacts = trio.getArtifacts();
        List<String> trioVersions = trio.getVersions();
        for(int i = 0; i < files.size();i++) {
            if (!artifacts.contains(trioArtifacts.get(i))) {
                artifacts.add(trioArtifacts.get(i));
                versions.add(new ArrayList<>());
                versions.get(versions.size() - 1).add(trioVersions.get(i));
            } else {
                versions.get(artifacts.indexOf(trioArtifacts.get(i))).add(trioVersions.get(i));
            }
        }
    }
    
    public List<String> getArtifacts() { return artifacts; }
    
    public GetJarTrio getTrio() { return trio; }
    
    public List<String> getVersions(String artifact) { 
        return versions.get(artifacts.indexOf(artifact));
    } 
    
    public static void main(String[] args) {
        GetJarVersionsByArtifact getter = new GetJarVersionsByArtifact("auth-server-5");
        List<String> artifacts = getter.getArtifacts();
        List<String> versions;
        for(int i = 0; i < artifacts.size();i++) {
            System.out.println("Artifact: " + artifacts.get(i));
            versions = getter.getVersions(artifacts.get(i));
            for(int j = 0; j < versions.size();j++) {
                System.out.println(j + ": " + versions.get(j));
            }
        }
    }
    
}
