package ca.tecreations.apps.javacompiler;

import ca.tecreations.ProjectPath;
import ca.tecreations.SystemTool;
import ca.tecreations.TecData;
import ca.tecreations.lang.java.GetClassPathFor;

/**
 *
 * @author Tim
 * 
 * Spawns a new JavaCompiler instance, from the TEC_VERSION.jar. 
 * Has no 3rd-party dependencies, however you will run into file-locking issues
 * if you attempt to delete TEC_VERSION.jar in the <user.home>/Downloads/ directory
 * while applications from that jar are running, regardless of TEC_VERSION.
 */
public class JavaCompiler_SpawnJar {
    
    public static void launch() {
        String jarPath = ProjectPath.getDownloadsPath() + TecData.TEC_VERSION + ".jar";
        String cmd = "java -cp " + new GetClassPathFor(jarPath).getResult();
        cmd += " ca.tecreations.apps.javacompiler.JavaCompiler";
        new SystemTool().spawn(cmd, true);
    }
    
    public static void main(String[] args) {
        launch();
    }
}
