package ca.tecreations;

import java.awt.Graphics;

/**
 *
 * @author Tim
 */
public class TextToken extends Token {

    public TextToken() {
        super("");
    }
    
    public TextToken(char ch) {
        super(ch);
    }
    
    public TextToken(String text) {
        super(text);
    }
    
    public void add(char ch) {
        text += ch;
        //System.out.println("Text: " + text);
    }
    
    public void backspace() {
        if (text.length() > 0) {
            text = text.substring(0,text.length() - 1);
            //System.out.println("Text: " + text);
        }
    }
    
    public void cut(int skip, int count) {
        String s = text.substring(0,skip);
        s += text.substring(skip + count);
        text = s;
    }
    
    public String getText() { return text; }
 
    public void insert(int index, String s) {
        String result = text.substring(0,index);
        result += s;
        result += text.substring(index);
        text = result;
    }
    
    public int length() { return text.length(); }
    
    public static void main(String[] args) {
        TextToken t = new TextToken();
        t.setText("Test");
        System.out.println("Text: " + t.getText());
        t.prefix("Test");
        System.out.println("Text: " + t.getText());
        t.insert(4,"Test");
        System.out.println("Text: " + t.getText());
        t.cut(4,4);
        System.out.println("Text: " + t.getText());
        t.reverse();
        System.out.println("Text: " + t.getText());
        
    }
    
    public void prefix(char c) {
        text = c + text;
    }
    
    public void prefix(String s) {
        text = s + text;
    }
    
    public void print() {
        System.out.println(text);
    }
     
    public void print(String prefix) {
        System.out.println(prefix + text);
    }
    
    public void print(String prefix,String postfix) {
        System.out.println(prefix + text + postfix);
    }

    public void replace(int index, char c) {
        replace(index,"" + c);
    }
    
    public void replace(int index, String s) {
        String result = text.substring(0,index);
        result += s;
        result += text.substring(index + 1);
        text = result;
    }
    
    public void reverse() {
        String reverse = "";
        for(int i = text.length() - 1; i >= 0;i--) reverse += text.charAt(i);
        text = reverse;
    }
    
    public TextToken setText(String text) {
        this.text = text;
        return this;
    }

}
