package ca.tecreations.components;

import ca.tecreations.components.SizedPanel;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import javax.swing.*;
/**
 *
 * @author Tim
 */
public class Status extends JPanel {
    JTextField command = new JTextField(32);
    static JLabel locator = new JLabel("XY: ");
    static JTextField mouseX = new JTextField(4);
    static JTextField mouseY = new JTextField(4);
    
    public Status(ActionListener listener) {
        setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        add(new JLabel("Command: "),gbc);

        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 12;
        gbc.gridheight = 1;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        gbc.weightx = 1.0;
        add(command,gbc);
        command.addActionListener(listener);
        
        gbc.gridx = 13;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        add(new SizedPanel(20,20,getBackground()),gbc);
        
        gbc = new GridBagConstraints();
        gbc.gridx = 14;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        add(locator,gbc);
        
        gbc = new GridBagConstraints();
        gbc.gridx = 16;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        add(mouseX,gbc);
        mouseX.setEditable(false);
        
        gbc = new GridBagConstraints();
        gbc.gridx = 18;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        add(mouseY,gbc);
        mouseY.setEditable(false);
    }
    
    public JTextField getCommand() { return command; }
    
    public String getCommandText() { return command.getText(); }
    
    public static void updateStatus(int x, int y) {
        mouseX.setText("" + x);
        mouseY.setText("" + y);
    }
    
}
