package ca.tecreations.components;

import ca.tecreations.TColor;
import ca.tecreations.components.event.*;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Graphics;

import javax.swing.*;
/**
 *
 * @author Tim
 * 
 */
public class ProgressDialog extends JDialog implements ProgressListener {
    ProgressBar progress = new ProgressBar(ProgressBar.getDefaultSize());
    
    public ProgressDialog(JFrame app) {
        super(app);
        setLayout(new BorderLayout(0,0));
        add(progress,BorderLayout.CENTER);
        validate();
        pack();
        setLocationRelativeTo(app);
        setResizable(false);
    }
    
    @Override
    public void addItem(String s) {
        setItem(s);
    }
    
    public ProgressBar getProgressBar() { return progress; }
    
    
    
    public static void main(String[] args) {
        JFrame test = new JFrame();
        test.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        ProgressDialog dialog = new ProgressDialog(test);
        dialog.setVisible(true);
        
        for(int i = 0; i <= 100;i++) {
            dialog.setTitle("PD: Progress: " + i + " %");
            dialog.setPercent(i);
            try { new Thread().sleep(50); } catch (InterruptedException ie) {}
        }
        
        try { new Thread().sleep(500); } catch (InterruptedException ie) {}
        dialog.setVisible(false);
        test.setVisible(false);
        System.exit(0);
    }    
    
    public void paint(Graphics g) {
        super.paint(g);
        progress.repaint();
    }
    
    public void setOutline(boolean state) {
        progress.setOutline(state);
    }
    
    public void setOutlineColor(Color color) {
        progress.setOutlineColor(new TColor(color));
    }

    public void setItem(String s) {
        setTitle(s);
    }
    public void setJob(String s) {
        setTitle(s);
    }
    
    public void setPercent(int percent) {
        progress.setPercent(percent);
        repaint();
    }

    public void setPercent(String title, int percent) {
        setTitle(title);
        progress.setPercent(percent);
        repaint();
    }

    public void update(String msg,int job, int item) {
        setTitle(msg);
        setPercent(item);
    }
    
    public void update(int job, int item) {
        setPercent(item);
        repaint();
    }
    
    public void updateItem(int item) {
        setPercent(item);
        repaint();
    }
    
    public void updateJob(int job) {
        repaint();
    }
}
