package ca.tecreations.components;

import ca.tecreations.TColor;
import ca.tecreations.TecData;
import ca.tecreations.TextToken;
import ca.tecreations.text.SystemTokenPainter;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.*;
/**
 *
 * @author Tim
 * 
 */
public class ProgressBar extends SizedPanel {
    int percent = 0;
    boolean outline = true;
    TColor outlineColor = TColor.black;
    
    
    public ProgressBar(int w, int h) {
        super(w,h);
    }
        
    public ProgressBar(Dimension d) {
        super(d.width,d.height);
    }
        
    public static Dimension getDefaultSize() {
        return new Dimension(320,18);
    }
    
    public Dimension getMinimumSize() {
        return getDefaultSize();
    }
    
    public Dimension getPreferredSize() {
        return getDefaultSize();
    }
    
    public static void main(String[] args) {
        JFrame test = new JFrame();
        test.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        JDialog example = new JDialog(test);
        example.setLayout(new BorderLayout(0,0));
        ProgressBar bar = new ProgressBar(ProgressBar.getDefaultSize());
        example.add(bar,BorderLayout.CENTER);
        example.pack();
        example.validate();
        example.setLocationRelativeTo(null);
        example.setResizable(false);
        example.setVisible(true);
        
        for(int i = 0; i <= 100;i++) {
            example.setTitle("Progress: " + i + "%");
            bar.setPercent(i);
            try { new Thread().sleep(50); } catch (InterruptedException ie) {}
        }
        
        try { new Thread().sleep(500); } catch (InterruptedException ie) {}
        example.setVisible(false);
        test.setVisible(false);
        System.exit(0);
    }    
    
    public void paintComponent(Graphics g) {
        Dimension size = getSize();
        double portion = (double)size.width / (double)100.0;
        int w = (int)(portion * (double)percent);
        if (percent == 100) {
            w = size.width;
        }  
        g.setColor(TColor.DEFAULT_SWING_BG);
        g.fillRect(0,0,size.width,size.height);
        g.setColor(TColor.green);
        g.fillRect(0,0,w,size.height);
        g.setColor(TColor.black);
        SystemTokenPainter painter = new SystemTokenPainter(TecData.ARIAL_P_12, new TextToken(percent + " %"));
        painter.setBackground(null);
        int textWidth = painter.getTextWidth();
        painter.paintAt(g,getSize().width / 2 - textWidth / 2, getSize().height / 2 - painter.getFontSize() / 2);
        if (outline) {
            g.setColor(outlineColor);
            g.drawRect(0,0,size.width - 1, size.height - 1);
        }
    }
    
    public void setOutline(boolean state) {
        outline = state;
        repaint();
    }
    
    public void setOutlineColor(Color color) {
        outlineColor = new TColor(color);
        repaint();
    }

    public void setPercent(int percent) {
        this.percent = percent;
        repaint();
    }

    public void setPercent(String title, int percent) {
        this.percent = percent;
        repaint();
    }
}
