package ca.tecreations.apps.filetool;

import ca.tecreations.FileEntry;
import ca.tecreations.net.backup.TLSClient_TVS12;

import java.util.List;
/**
 *
 * @author Tim
 */
public class CleanDir extends Thread {
    FileTool app;
    TLSClient_TVS12 client;
    String srcPath;
    List<String> types;
    
    public CleanDir(FileTool app,TLSClient_TVS12 client, String srcPath,List<String> types) {
        this.app = app;
        this.client = client;
        this.srcPath = srcPath;
        this.types = types;
        start();
    }
    
    public void run() {
        cleanDir(srcPath);
        app.refreshLast();
    }
    
    public void cleanDir(String path) {
        List<String> entries = client.listFiles(path);
        if (entries != null) {
            for(int i = 0; i < entries.size();i++) {
                String name = entries.get(i);
                String extension = new FileEntry(client,name,"","","","").getExtension();
                if (inList(extension)) {
                    client.delete(name);         
                }
            }
        }
    }    

    public boolean inList(String s) {
        for(int i = 0; i < types.size();i++) {
            if (types.get(i).equals(s)) return true;
        }
        return false;
    }
}
