package ca.tecreations.apps.deploy;

import ca.tecreations.Platform;
import ca.tecreations.Properties;
import ca.tecreations.ProjectPath;
import ca.tecreations.Sort;
import ca.tecreations.components.GetString;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.*;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.*;

/**
 *
 * @author Tim de Vries
 */
public class JavaProjectOptions extends JPanel implements ActionListener, ItemListener {
    Deploy deployment;
    Properties properties = null;
    JTextField classPath = new JTextField(32);    
    JButton select = new JButton("Select");
    JCheckBox createJar = new JCheckBox("Create Jar",true);
    JCheckBox includeSources = new JCheckBox("Include Source Files",true);
    JCheckBox includeClasses = new JCheckBox("Include Class Files",true);
    JCheckBox includeJars = new JCheckBox("Include jars Directory",true);
    JCheckBox includeUnspecified = new JCheckBox("Include Unspecified",true);
    DefaultListModel<String> projectInclusionsModel = new DefaultListModel<>();
    DefaultListModel<String> projectExclusionsModel = new DefaultListModel<>();
    JList<String> projectPaths = new JList<>(projectInclusionsModel);
    JList<String> projectExcludePaths = new JList<>(projectExclusionsModel);
    JButton chooseInclusion = new JButton("Choose...");
    JButton addInclusion = new JButton("Add...");
    JButton removeInclusion = new JButton("Remove");
    JButton chooseExclusion = new JButton("Choose...");
    JButton addExclusion = new JButton("Add...");
    JButton removeExclusion = new JButton("Remove");
     
    public JavaProjectOptions(Deploy deployment) {
        super(new GridBagLayout());
        this.deployment = deployment;
        while (deployment == null) Platform.sleep(125);
        while ((properties = deployment.getProperties()) == null) {
            System.out.println("JavaProjectOptions: Watiting on Properties != null");
        }
        setupGUI();
        Boolean bool = deployment.getProperties().getBoolean(Data.PROJECT_CREATE_JAR);
        if (bool == null) bool = false;
        if (bool) {
            includeSources.setEnabled(true);
            includeClasses.setEnabled(true);
            includeUnspecified.setEnabled(true);
            includeJars.setEnabled(true);
        } else {
            includeSources.setEnabled(false);
            includeClasses.setEnabled(false);
            includeUnspecified.setEnabled(false);
            includeJars.setEnabled(false);
        }
    }
    
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == select) {
            String oldPath = classPath.getText();
            classPath.setText(selectAndGetRootPath());
            if (!classPath.getText().equals("")) deployment.construct(classPath.getText());
            else classPath.setText(oldPath);
        } else if (e.getSource() == chooseInclusion) {
            choosePath(projectInclusionsModel);
            Sort.sort(projectInclusionsModel);
            deployment.getProperties().set(Data.PROJECT_PATHS_INCLUDES,getCSV(projectInclusionsModel));
        } else if (e.getSource() == addInclusion) {
            addToList(projectInclusionsModel);
            Sort.sort(projectInclusionsModel);
            deployment.getProperties().set(Data.PROJECT_PATHS_INCLUDES,getCSV(projectInclusionsModel));
        } else if (e.getSource() == removeInclusion) {
            removePath(projectPaths,projectInclusionsModel);
            deployment.getProperties().set(Data.PROJECT_PATHS_INCLUDES,getCSV(projectInclusionsModel));
        } else if (e.getSource() == chooseExclusion) {
            choosePath(projectExclusionsModel);
            Sort.sort(projectExclusionsModel);
            deployment.getProperties().set(Data.PROJECT_PATHS_EXCLUDES,getCSV(projectExclusionsModel));
        } else if (e.getSource() == addExclusion) {
            addToList(projectExclusionsModel);
            Sort.sort(projectExclusionsModel);
            deployment.getProperties().set(Data.PROJECT_PATHS_EXCLUDES,getCSV(projectExclusionsModel));
        } else if (e.getSource() == removeExclusion) {
            removePath(projectExcludePaths,projectExclusionsModel);
            deployment.getProperties().set(Data.PROJECT_PATHS_EXCLUDES,getCSV(projectExclusionsModel));
        }
    }
    
    public void addToList(DefaultListModel<String> model) {
        String title = (model == projectInclusionsModel) ? "Enter an Inclusion..." : "Enter an Exclusion...";
        GetString getter = new GetString(deployment.getTFrame(),title);
        getter.setVisible(true);
        String result = getter.getText();
        System.out.println(result);
        if (getter.getText() != null) {
            model.addElement(result);
        }
    }
    
    public void choosePath(DefaultListModel<String> model) {
        JFileChooser chooser = new JFileChooser(); 
        if (File.separator.equals("\\")) chooser.setCurrentDirectory(new File(ProjectPath.getProjectPath()));
        else chooser.setCurrentDirectory(new File("/"));
        chooser.setDialogTitle("Select An Item To Include...");
        chooser.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
        chooser.setMultiSelectionEnabled(true);
        chooser.setAcceptAllFileFilterUsed(true);
        chooser.setMultiSelectionEnabled(true);
        int retVal = chooser.showOpenDialog(this);
        if (retVal == JFileChooser.APPROVE_OPTION) { 
            File[] paths = chooser.getSelectedFiles();
            for (File path : paths) {
                if (path.isDirectory()) {
                    String newPath = path.getAbsolutePath() + File.separator;
                    if (!inList(getListOfStringFromModel(model),newPath)) {
                        model.addElement(path.getAbsolutePath() + File.separator);
                    }
                } else {
                    if (!inList(getListOfStringFromModel(model),path.getAbsolutePath())) {
                        model.addElement(path.getAbsolutePath());
                    }
                }
            }
        } 
    }

    public List<String> csvToListOfString(String csv) {
        List<String> v = new ArrayList<>();
        StringBuffer buf = new StringBuffer();
        if (csv != null) {
            for(int i = 0; i < csv.length();i++) {
                if (csv.charAt(i) == ',') {
                    v.add(buf.toString());
                    buf = new StringBuffer();
                } else buf.append(csv.charAt(i));
            }
        }
        v.add(buf.toString());
        return v;
    }

    public void doInitialSetup(String path) {
        createJar.setSelected(true);
        deployment.getProperties().set(Data.MAKE_SECURE,true);
        deployment.getProperties().set(Data.PROJECT_CREATE_JAR,true);
        classPath.setText(path);
        properties.set(Data.PROJECT_PATH,path);
        properties.set(Data.PROJECT_PATHS_INCLUDES,path);
        includeSources.setSelected(true);
        includeClasses.setSelected(true);
        includeJars.setSelected(true);
        includeUnspecified.setSelected(true);
        projectInclusionsModel.removeAllElements();
        projectExclusionsModel.removeAllElements();
        if (!path.endsWith(File.separator)) path += File.separator;
        projectInclusionsModel.addElement(path);
        projectExclusionsModel.addElement("*security*");
        projectExclusionsModel.addElement("zipfstmp.*");
        projectExclusionsModel.addElement("*.DS_Store*");
        projectExclusionsModel.addElement(ProjectPath.getDistPath());
        projectExclusionsModel.addElement(ProjectPath.getLogsPath());
        projectExclusionsModel.addElement(ProjectPath.getPropertiesPath());
        projectExclusionsModel.addElement(path + ".idea" + File.separator);
        projectExclusionsModel.addElement(path + ".idea.libraries" + File.separator);
        projectExclusionsModel.addElement("*NetBeansProjects*");
        projectExclusionsModel.addElement("*zipfstmp*");
        setProperties();
    }
    
    public String getCSV(DefaultListModel<String> model) {
        String ts = "";
        Enumeration<String> v = model.elements();
        java.util.List<String> list = Collections.list(v);
        if (list.size() == 1) {
            ts = list.get(0);
        } else if (list.size() > 1) {
            for(int i = 0; i < list.size() - 1;i++) {
                ts += list.get(i) + ",";
            }
            ts += list.get(list.size() - 1);
        }
       return ts;
    }

    public String getClassPath() {
        return classPath.getText();
    }
    
    public boolean getIncludeSources() {
        return includeSources.isSelected();
    }
    
    public boolean getIncludeClasses() {
        return includeClasses.isSelected();
    }
    
    public boolean getIncludeJars() {
        return includeJars.isSelected();
    }
    
    public boolean getIncludeUnspecified() {
        return includeUnspecified.isSelected();
    }
    
    public List<String> getListOfStringFromModel(DefaultListModel<String> model) {
        Enumeration<String> v = model.elements();
        List<String> list = Collections.list(v);
        return list;
    }
    
    public String getProjectPath() { return classPath.getText(); }
    
    public void getProperties(Properties properties) {
        Boolean bool = properties.getBoolean(Data.PROJECT_CREATE_JAR);
        if (bool == null) bool = false;
        createJar.setSelected(bool);
        classPath.setText(properties.get(Data.PROJECT_PATH));
        Boolean sources = properties.getBoolean(Data.PROJECT_INCLUDE_SOURCES);
        if (sources == null) sources = true;
        Boolean classes = properties.getBoolean(Data.PROJECT_INCLUDE_CLASSES);
        if (classes == null) classes = true;
        Boolean jars = properties.getBoolean(Data.PROJECT_INCLUDE_JARS);
        if (jars == null) jars = true;
        Boolean unspecified = properties.getBoolean(Data.PROJECT_INCLUDE_UNSPECIFIED);
        if (unspecified == null) unspecified = true;
        includeSources.setSelected(sources);
        includeClasses.setSelected(classes);
        includeJars.setSelected(jars);
        includeUnspecified.setSelected(unspecified);
        setModelContents(projectInclusionsModel,properties.get(Data.PROJECT_PATHS_INCLUDES));
        setModelContents(projectExclusionsModel,properties.get(Data.PROJECT_PATHS_EXCLUDES));
    }
    
    public boolean includeClasses() {
        return includeClasses.isSelected();
    }
    
    public boolean includeUnspecified() {
        return includeUnspecified.isSelected();
    }
    
    public boolean includeJars() {
        return includeJars.isSelected();
    }
    
    public boolean includeSources() {
        return includeSources.isSelected();
    }
    
    public boolean inList(List<String> list,String target) {
        File _target = new File(target);
        for(int i = 0; i < list.size();i++) {
            if (new File(list.get(i)).equals(_target)) return true;
        }
        return false;
    }
    
    public void itemStateChanged(ItemEvent e) {
        Properties properties = deployment.getProperties();
        if (e.getSource() == createJar) {
            deployment.filenameUpdated();
            if (createJar.isSelected()) {
                deployment.getManifest().populate();
                deployment.getManifest().enableComponent();
                deployment.getCodeSigning().enableComponent();
            } else {
                deployment.getManifest().disableComponent();
                deployment.getCodeSigning().disableComponent();
            }
            properties.set(Data.PROJECT_CREATE_JAR,createJar.isSelected());
        } else if (e.getSource() == includeSources) {
            properties.set(Data.PROJECT_INCLUDE_SOURCES,includeSources.isSelected());
        } else if (e.getSource() == includeClasses) {
            properties.set(Data.PROJECT_INCLUDE_CLASSES,includeClasses.isSelected());
        } else if (e.getSource() == includeJars) {
            properties.set(Data.PROJECT_INCLUDE_JARS,includeJars.isSelected());
        } else if (e.getSource() == includeUnspecified) {
            properties.set(Data.PROJECT_INCLUDE_UNSPECIFIED,includeUnspecified.isSelected());
        }
    }

    public void removePath(JList<String> list, DefaultListModel<String> model) {
        if (list.getSelectedIndex() != -1) {
            model.remove(list.getSelectedIndex());
        }
    }
    
    public String selectAndGetRootPath() {
        JFileChooser chooser = new JFileChooser(); 
        chooser.setCurrentDirectory(new File(ProjectPath.getDocumentsPath()));
        chooser.setDialogTitle("Select A Root Path...");
        chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        chooser.setAcceptAllFileFilterUsed(false);
        int retVal = chooser.showOpenDialog(deployment.getTFrame());
        String path = "";
        if (retVal == JFileChooser.APPROVE_OPTION) { 
            path = chooser.getSelectedFile().toString() + File.separator;
        }
        return path;
    }
    
    public void setIncludeClasses(boolean state) {
        includeClasses.setSelected(state);
        deployment.getProperties().set(Data.PROJECT_INCLUDE_CLASSES,state);
    }
    
    public void setIncludeUnspecified(boolean state) {
        includeUnspecified.setSelected(state);
        deployment.getProperties().set(Data.PROJECT_INCLUDE_UNSPECIFIED,state);
    }
    
    public void setIncludeJars(boolean state) {
        includeJars.setSelected(state);
        deployment.getProperties().set(Data.PROJECT_INCLUDE_JARS,state);
    }
    
    public void setIncludeSources(boolean state) {
        includeSources.setSelected(state);
        deployment.getProperties().set(Data.PROJECT_INCLUDE_SOURCES,state);
    }
    
    public void setModelContents(DefaultListModel<String> model,String csv) {
        model.removeAllElements();
        List<String> list = csvToListOfString(csv);
        //System.out.println(list);
        for(int i = 0; i < list.size();i++) model.addElement(list.get(i));        
    }
    
    public void setProperties() {
        Properties properties = deployment.getProperties();
        properties.set(Data.PROJECT_CREATE_JAR,createJar.isSelected());
        properties.set(Data.PROJECT_PATH,classPath.getText());
        properties.set(Data.PROJECT_INCLUDE_SOURCES,includeSources.isSelected());
        properties.set(Data.PROJECT_INCLUDE_CLASSES,includeClasses.isSelected());
        properties.set(Data.PROJECT_INCLUDE_JARS,includeJars.isSelected());
        properties.set(Data.PROJECT_INCLUDE_UNSPECIFIED,includeUnspecified.isSelected());
        properties.set(Data.PROJECT_PATHS_INCLUDES,getCSV(projectInclusionsModel));
        properties.set(Data.PROJECT_PATHS_EXCLUDES,getCSV(projectExclusionsModel));
    }

    public void setupGUI() {
        GridBagConstraints c = new GridBagConstraints();
        
        c.gridx = 0; c.gridy = 0;
        c.gridwidth = 2; c.gridheight = 1;
        add(new JLabel("Class Path: "),c);
        
        c = new GridBagConstraints();
        c.gridx = 2; c.gridy = 0;
        c.gridwidth = 6; c.gridheight = 1;
        c.fill = GridBagConstraints.HORIZONTAL;
        c.weightx = 1.0;
        add(classPath,c);
        classPath.setEditable(false);
        
        c = new GridBagConstraints();
        c.gridx = 8; c.gridy = 0;
        c.gridwidth = 2; c.gridheight = 1;
        c.fill = GridBagConstraints.NONE;
        c.weightx = 0.0;
        add(select,c);
        select.addActionListener(this);
        
        
        c = new GridBagConstraints();
        c.gridx = 0; 
        c.gridy = 1;
        c.gridwidth = 10;
        c.gridheight = 1;
        add(new JLabel("    "),c);
        
        c = new GridBagConstraints();
        c.gridx = 1; c.gridy = 1;
        c.gridwidth = 10;
        c.gridheight = 1;
        c.anchor = GridBagConstraints.LINE_START;
        add(createJar,c);
        createJar.addItemListener(this);
        
        c = new GridBagConstraints();
        c.gridx = 1; c.gridy = 2;
        c.gridwidth = 10;
        c.gridheight = 1;
        c.anchor = GridBagConstraints.LINE_START;
        add(includeSources,c);
        includeSources.addItemListener(this);
        
        c = new GridBagConstraints();
        c.gridx = 1; c.gridy = 3;
        c.gridwidth = 10;
        c.gridheight = 1;
        c.anchor = GridBagConstraints.LINE_START;
        add(includeClasses,c);
        includeClasses.addItemListener(this);
        
        c = new GridBagConstraints();
        c.gridx = 1; c.gridy = 4;
        c.gridwidth = 10 ;
        c.gridheight = 1;
        c.anchor = GridBagConstraints.LINE_START;
        add(includeJars,c);
        includeJars.addItemListener(this);
        
        c = new GridBagConstraints();
        c.gridx = 1; c.gridy = 5;
        c.gridwidth = 10 ;
        c.gridheight = 1;
        c.anchor = GridBagConstraints.LINE_START;
        add(includeUnspecified,c);
        includeUnspecified.addItemListener(this);
        
        JPanel hold2 = new JPanel(new GridLayout(2,0));
        
        JPanel holder = new JPanel(new GridBagLayout());
        JPanel flow = new JPanel(new FlowLayout(FlowLayout.LEFT));
        flow.add(new JLabel("Include Paths: "));
        flow.add(chooseInclusion);
        flow.add(addInclusion);
        flow.add(removeInclusion);
        c = new GridBagConstraints();
        c.gridx = 0; c.gridy = 0;
        c.gridwidth = 10; c.gridheight = 1;
        c.fill = c.HORIZONTAL;
        holder.add(flow,c);
        
        c = new GridBagConstraints();
        c.gridx = 0; c.gridy = 1;
        c.gridwidth = 10; c.gridheight = 4;
        c.fill = c.BOTH;
        c.weightx = 1.0;
        c.weighty = 1.0;
        holder.add(new JScrollPane(projectPaths,JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS),c);
        chooseInclusion.addActionListener(this);
        addInclusion.addActionListener(this);
        removeInclusion.addActionListener(this);
        
        hold2.add(holder);
        
        JPanel holder2 = new JPanel(new GridBagLayout());
        JPanel flow2 = new JPanel(new FlowLayout(FlowLayout.LEFT));
        flow2.add(new JLabel("Exclude From Archive: "));
        flow2.add(chooseExclusion);
        flow2.add(addExclusion);
        flow2.add(removeExclusion);
        c = new GridBagConstraints();
        c.gridx = 0; c.gridy = 0;
        c.gridwidth = 10; c.gridheight = 1;
        c.fill = c.HORIZONTAL;
        holder2.add(flow2,c);
        
        c = new GridBagConstraints();
        c.gridx = 0; c.gridy = 1;
        c.gridwidth = 10; c.gridheight = 4;
        c.fill = c.BOTH;
        c.weightx = 1.0;
        c.weighty = 1.0;
        holder2.add(new JScrollPane(projectExcludePaths,JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS),c);
        chooseExclusion.addActionListener(this);
        addExclusion.addActionListener(this);
        removeExclusion.addActionListener(this);
        hold2.add(holder2);
        
        c = new GridBagConstraints();
        c.gridx = 0; c.gridy = 6;
        c.gridwidth = 10;
        c.gridheight = 10;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = c.BOTH;
        add(hold2,c);
    }

}
