package ca.tecreations.apps._data;

import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DnDConstants;
import java.awt.event.InputEvent;
import java.io.IOException;
import java.util.List;

import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.TransferHandler;

/**
 *
 * @author tim
 */
public class FileListTransferHandler extends TransferHandler {
    JComponent comp;
    boolean debug = false;
    
    public FileListTransferHandler() {
    }

    public boolean canImport(TransferHandler.TransferSupport support) {
        // we only import List<String>'s representing a fully sane filename, with or without quotes.
        // Quoted filenames are used where the name contains a space or a comma, since we use those
        // characters as delimiters within our data processing subroutines, for the tecreations packages
        // of software, regardless of platform or language.
        if (!support.isDataFlavorSupported(FileListTransferable.listFlavor)) {
            return false;
        }
        return true;
    }
    /**
     * Bundle up the data for export.
     */
    protected Transferable createTransferable(JComponent c) {
        if (debug) System.out.println("FileListTransferHandler.createTransferable");
        
        if (c instanceof ListOfStringProvider) {
            List<String> list = ((ListOfStringProvider)c).getSelection();
        //System.out.println("Recorded Selection:");
        //for(int i = 0; i < list.size();i++) {
        //    System.out.println(i + ": " + list.get(i));
        //}
            return new FileListTransferable(list);
        }
        return null;
    }

    
    public void exportAsDrag(JComponent comp,InputEvent e,int action) {
        if (debug) System.out.println("FileListTransferHandler.exportAsDrag: " + (action == MOVE ? "Move" : "Copy"));
        super.exportAsDrag(comp,e,action);
        this.comp = comp;
        if (comp instanceof JTable) System.out.println("JTable");
        else if (comp instanceof JList) System.out.println("JList");
    }
    
    public void exportDone(JComponent c, Transferable data, int action) {
        if (debug) System.out.print("FileListTransferHandler.exportDone: ");
        if (c instanceof JTable) System.out.println("JTable");
        else if (c instanceof JList) System.out.println("JList");
        else System.out.println("JComponent: " + c);
    }

    @Override
    public int getSourceActions(JComponent c) {
        return COPY_OR_MOVE;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport info) {
        if (debug) System.out.println("FileListTransferHandler.importData");
        List<String> data = null; 

        //If we can't handle the import, bail now.
        if (!canImport(info)) {
            return false;
        }
 
        
        
        //FileEntriesTableModel model = table.getBaseTableModel();
        
        //Fetch the data -- bail if this fails
        try {
            data = (List)info.getTransferable().getTransferData(FileListTransferable.listFlavor);
            System.err.println("Data: " + data);
        } catch (UnsupportedFlavorException ufe) {
            System.err.println("FileListTransferHandler,importData: unsupported data flavor");
            return false;
        } catch (IOException ioe) {
            System.err.println("importData: I/O exception");
            return false; 
        }
        //System.out.println("info: " + info.toString());
        
        if (info.isDrop()) { //This is a drop 
            if (info.getDropLocation() instanceof JTable.DropLocation) {
                JTable.DropLocation dl = (JTable.DropLocation)info.getDropLocation();
                System.out.println("FileListTransferHandler.importData: Dropping into table(2): ");
                return true; 
            } else if (info.getDropLocation() instanceof JList.DropLocation) {
                JList.DropLocation dl = (JList.DropLocation)info.getDropLocation();
                return true;
            } else {
                // didn't do anyting, wait to end of method to return
            }
        } else { //This is a paste : The data should be a list of strings.
            System.out.println("FileListTransferHandler.importData: Pasting into: ");
            for(int i = 0; i < data.size();i++) {
                System.out.println(i + ": " + data.get(i));
            }       
            return true;
        } 
        // the code is completed and the return value should indicate successful
        // otherwise return false on failure to import :: drop or paste
        return true;
    }
  

}
