package ca.tecreations.graphics;

import ca.tecreations.Point;

import java.awt.*;

/**
 *
 * @author tim
 */
public class DrawPoint extends DrawObject {
    Point point;
    
    public DrawPoint(Point p) {
        point = p;
    }
    
    public void paint(Graphics g) {
        draw(g);
    }
    
    public void draw(Graphics g) {
        draw(g,getTX(),getTY()); // by default, draw at TXY in all cases
    }
    
    public void draw(Graphics g, int x,int y) {
        g.setColor(lineColor); // only use line color for Point
        setPixel(g,x,y);
    }
    
    public void draw(Graphics g, int x, int y, Color lineColor) {
        setLineColor(lineColor);
        draw(g,x,y);
    }
    
    public void draw(Graphics g, int x, int y, Color lineColor, Color UNUSED__fillColor) {
        setLineColor(lineColor);
        draw(g,x,y);
    }
    
    public int getPaintingWidth() { return 1; }
    
    public Point getPoint() { return point; }
    
    public boolean hasFillPoint(Point p) {
        return point.x == p.x && point.y == p.y;
    }
    
    public boolean hasPoint(Point p) {
        return point.hasPoint(p);
    }
    
    public void paintElement(Graphics g) {
        draw(g);
    }
    
}
