package ca.tecreations.apps._gui;

import ca.tecreations.EnvData;
import ca.tecreations.ExceptionHandler;
import ca.tecreations.FileEntry;
import ca.tecreations.Platform;
import ca.tecreations.Properties;
import ca.tecreations.StringTool;
import ca.tecreations.TecData;
import ca.tecreations.TextToken;
import ca.tecreations.apps.*;
import ca.tecreations.apps._actions.*;
import ca.tecreations.apps._data.*;
import ca.tecreations.apps.filetool.FileTool;
import ca.tecreations.components.GetString;
import ca.tecreations.components.SizedPanel;
import ca.tecreations.components.TextViewer;
import ca.tecreations.components.YesNoDialog;
import ca.tecreations.net.Client;
import ca.tecreations.net.Internet;
import ca.tecreations.net.NameService;
import ca.tecreations.net.NoTLSConnectionException;
import ca.tecreations.text.SystemTokenPainter;
import ca.tecreations.text.TextPoints;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.dnd.DnDConstants;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.*;
import java.util.ArrayList;
import java.util.List;

import javax.swing.*;

/**
 *
 * @author tim
 */ 
public class EntriesPanel extends SizedPanel implements ActionListener, DataRetrievalListener,
        MouseListener, MouseMotionListener {
    public static final String SN = EntriesPanel.class.getSimpleName();
    App app; 
    String id;
    JScrollPane scroller;
    SizedPanel holder;
    FileEntriesTable table;
    FileEntriesTableModel model;

    DragSource ds = new DragSource();

    Client client;

    JComboBox<String> servers = new JComboBox<>();
    JButton addServer = new JButton("Add");
    
    JComboBox<String> roots = new JComboBox<>();
    
    JPanel pathLine = new JPanel(new BorderLayout(0, 0));
    JTextField path = new JTextField(64);
    
    JPanel buttons = new JPanel(new FlowLayout(FlowLayout.LEFT, 0, 0));
    UpDirButton upDir;
    RefreshButton refresh;
    EnvButton env;

    boolean quiet = false;

    FileEntry entry = null; // for when using the popup menu on an item
    JMenuItem findFromHere = new JMenuItem("Find From Here...");
    JMenuItem newFile = new JMenuItem("New File...");
    JMenuItem newFolder = new JMenuItem("New Folder...");
    JMenuItem rename = new JMenuItem("Rename...");
    JMenuItem delete = new JMenuItem("Delete");
    JMenuItem add = new JMenuItem("Add To Backup");
    JMenuItem remove = new JMenuItem("Remove From Backup");
    
    boolean controlDown = false;
    boolean shiftDown = false;
    
    JPopupMenu popup = new JPopupMenu();
 
    int firstIndex = -1;
    int lastIndex = -1;
    int lastSet = -1;

    public boolean firstRun = true;
    
    List<SizeGetter_Dir> sizeGetters = new ArrayList<>();
    
    public EntriesPanel(App app, Client client, String id, int w, int h) {
        super(w, h);
        this.app = app;
        this.client = client;
        this.id = id;
        upDir = new UpDirButton();
        refresh = new RefreshButton();
        if (debug) {
            env = new EnvButton();
        }
        table = new FileEntriesTable(id, this, servers, roots, path);
        table.setSide(id);
        setupGUI();
        setupDND();
    } 

//    public EntriesPanel(App app, int w, int h) {
//        super(w, h);
//        this.app = app;
//        upDir = new UpDirButton();
//        refresh = new RefreshButton();
//        if (debug) {
 //           env = new EnvButton();
 //       }
 //       table = new FileEntriesTable(id, this, servers, roots, path);
 //       table.setSide(id);
 //       setupGUI();
//        setupDND();
//    }

    public boolean contains(List<String> list, String target) {
        for(int i = 0; i < list.size();i++) {
            if (list.get(i).equals(target)) return true;
        }
        return false;
    }
    
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == servers) {
            quiet = true;
            operateServers();
            quiet = false;
        } else if (e.getSource() == roots) {
            if (!quiet) {
                operateRoots();
            }
        } else if (e.getSource() == path) {
            storePath(path.getText());
            getEntries();
        } else if (e.getSource() == addServer) {
            GetString getter = new GetString(app,"Enter a hostname to add...");
            getter.setVisible(true);
            String server = getter.getText();
            List<String> listed = new ArrayList<>();
            List<String> serversList = new ArrayList<>();
            for(int i = 0; i < servers.getItemCount();i++) serversList.add(servers.getItemAt(i));
            boolean found = contains(serversList,server);
            if (!found) {
                getter = new GetString(app,"Enter an ip address or empty to get via DNS...");
                String ip = getter.getText();
                if (ip.equals("")) {
                    ip = Internet.getIPFor(server);
                }
                NameService.instance.set(server,ip);
                servers.addItem(server);
            }
            
// will need to rework menus
/*
        } else if (e.getSource() == buildHere) {
            popup.setVisible(false);
            File aJava = getAJavaFileIn(getSelectedPath());
            if (aJava != null) {
                FileEntry javaEntry = new FileEntry(client,aJava.getAbsolutePath());
                String classPath = javaEntry.getProjectPath();
                String subPath = javaEntry.getPackagePathPart();
                new BuildDir(app,client, classPath,subPath);
                getEntries();
            }
        } else if (e.getSource() == findFromHere) {
            GetString stringGetter = new GetString(app,"Enter search phrase...");
            new FindInFiles(getSelectedPath(),stringGetter.getText()); 

            System.out.println("Processing is done.");
            
        } else if (e.getSource() == buildFromHere) {
            popup.setVisible(false);
            File aJava = getAJavaFileIn(getSelectedPath());
            
            if (aJava != null) {
                FileEntry javaEntry = new FileEntry(client,aJava.getAbsolutePath());
                String classPath = javaEntry.getProjectPath();
                String subPath = javaEntry.getPackagePathPart();
                new Builder(app,client, classPath,subPath);
                getEntries();
            }
        } else if (e.getSource() == cleanHere) {
            popup.setVisible(false);
            List<String> types = new ArrayList<>();
            types.add("class");
            new CleanDir(app,client,getSelectedPath(),types);
            getEntries();
        } else if (e.getSource() == cleanFromHere) {
            popup.setVisible(false);
            List<String> types = new ArrayList<>();
            types.add("class");
            new Cleaner(app,client,getSelectedPath(),types);
            getEntries();
        } else if (e.getSource() == runJava) {
            entry.run();
        } else if (e.getSource() == runJarLauncher) {
            NetworkJarLauncher.launch(client,entry.getName());
        } else if (e.getSource() == newFile) {
            GetString getter = new GetString(app);
            while (getter.isVisible()) {
                Platform.sleep(125);
            }
            int invalid = isValidFileNameChar(getter.getText());
            if (invalid != -1) {
                Platform.message(app, "Invalid character in file name: " + invalid);
            } else {
                String path = StringTool.getDoubleQuoted(getSelectedPath() + getter.getText() + client.getFileSeparator());
                TextFile textFile = new TextFile(path);
                textFile.write();
                getEntries();
            }
*/
        } else if (e.getSource() == findFromHere) {
        } else if (e.getSource() == newFile) {
        } else if (e.getSource() == newFolder) {
            GetString getter = new GetString(app);
            while (getter.isVisible()) {
                Platform.sleep(125);
            }
            String path = StringTool.getDoubleQuoted(getSelectedPath() + getter.getText() + client.getFileSeparator());
            client.mkdirs(path);
            // table.insertEntry(path);
            getEntries();
        } else if (e.getSource() == rename) {
            
/*
            String oldName = entry.getName();
            File oldFile = new File(oldName);
            GetString getter = new GetString(app, "Rename");
            while (getter.isVisible()) {
                Platform.sleep(125);
            }
            String newPath = oldFile.getDeepestDirectoryFile().getUnwrapped();
            sif (oldFile.isDirectory()) {
                newPath += getter.getText() + client.getFileSeparator();
            } else {
                newPath = oldFile.getDeepestDirectoryFile().getUnwrapped() + getter.getText();
            }
            newName = StringTool.getDoubleQuoted(newName);
            if (!newName.equals("")) {
                client.rename(oldName, newName);
                entry.setName(newName);
                getEntries();
            }
*/
        } else if (e.getSource() == delete) {
            List<String> selection = model.getSelection();
            String sel = "";
            for (int i = 0; i < selection.size() - 1; i++) {
                sel += selection.get(i);
                if (selection.size() > 1) sel += ", \n";
            }
            sel += selection.get(selection.size() - 1) + "\n";
            YesNoDialog dialog = Platform.confirm(app, "Delete: " + sel + " : Y/N?");
            dialog.setTitle("Confirm deletion...");
            while (dialog.isVisible()) {
                Platform.sleep(125);
            }
            if (dialog.isYes()) {
                for (int i = 0; i < selection.size(); i++) {
//                    delete(model.getEntryByName(selection.get(i)));
                }
                getEntries();
            }
        }
    }
    
    public void addButtons() {
        buttons.add(upDir);
        buttons.add(refresh);
    }

    public void addButtons_Env() {
        buttons.add(env);
    }
    
    public void addListeners() {
        servers.addActionListener(this);
        addServer.addActionListener(this);
        roots.addActionListener(this);
        roots.addMouseListener(this);
        path.addActionListener(this);
        table.addMouseListener(this);
        table.addMouseMotionListener(this);
        upDir.addMouseListener(this);
        refresh.addMouseListener(this);
//        screenshot.addMouseListener(this);
        env.addMouseListener(this);
        findFromHere.addActionListener(this);
//        buildHere.addActionListener(this);
//        buildFromHere.addActionListener(this);
//        cleanHere.addActionListener(this);
//        cleanFromHere.addActionListener(this);
//        runJava.addActionListener(this);
        newFile.addActionListener(this);
        newFolder.addActionListener(this);
        rename.addActionListener(this);
        delete.addActionListener(this);
    }
    
    @Override
    public void dataRetrieved(DataRetrievalEvent e) {
        List<String> rows = e.getResult();
        List<FileEntry> entries = new ArrayList<>();
        List<FileEntry> dirs = new ArrayList<>();

        if (rows != null && rows.size() >= 1) {
            FileEntry entry = null;
            List<String> parts;
            String s;
            for (int i = 0; i < rows.size(); i++) {
                s = rows.get(i);
                //System.out.println("EntriesPanel.dataRetrieved: " + s);
                String[] detail = getNameAndRemainder(s);
                parts = StringTool.explode(detail[1], ',');
                //System.out.println(SN + ".dataRetrieved: Name: " + detail[0] + " Parts: " + parts.size() + " : " + parts);
                if (parts.size() == 6) { 
                    int size = parts.size();
                    String attributes = parts.get(size - 3) + "," + parts.get(size - 2) + "," + parts.get(size - 1);
                    entry = new FileEntry(client,detail[0], parts.get(0), parts.get(1), parts.get(2), attributes);
                } else {
                    entry = new FileEntry(
                            client,
                            detail[0], 
                            parts.get(0), 
                            parts.get(1), 
                            parts.get(2), 
                            parts.get(3)
                    );
                }
                if (entry.isDirectory()) {
                    dirs.add(entry);
                }
                entries.add(entry);
            }
            // set the model and update GUI
            if (entry != null && entry.isNix()) {
                model = new FileEntriesTableModelPOSIX(this,table);
            } else {
                model = new FileEntriesTableModelDOS(this,table);
            }
            model.setSide(id);
            table.setModel(model);

            model.setRowCount(0,false);
            for (int i = 0; i < entries.size(); i++) {
                model.addRow(entries.get(i),false);
            }
        
            int[] widths;
            //if (entries.size() > 0) {
            //    widths = getColumnWidths();
            //} else {
                if (entry != null && entry.isNix()) {
                    widths = new int[] { 160,100,100,160,100,100,200 };
                } else {
                    widths = new int[] { 160,100,60,220,100 };
                }
            //} 
        
            //ineffectual
            //for(int i = 0; i < widths.length;i++) {
            //    TableColumn tableColumn = table.getColumnModel().getColumn(i);
            //    Object value = tableColumn.getHeaderValue();
            //    TableCellRenderer renderer = tableColumn.getHeaderRenderer();
            //    if (renderer == null) {
            //        renderer = table.getTableHeader().getDefaultRenderer();
            //    }
            //    Component c = renderer.getTableCellRendererComponent(table, value, false, false, -1, i);
            //    widths[i] = Math.max(widths[i],c.getPreferredSize().width);
            //}
            table.setColumnWidths(widths);
        
            // compute scrollable area size
            int w = 0;
            for(int i = 0; i < widths.length;i++) {
                w += widths[i];
            }
            int h = Math.max(entries.size() * table.getRowHeight(),scroller.getVerticalScrollBar().getSize().height);
            h += table.getTableHeader().getSize().height;
            h += table.getRowHeight(); // workaround to prevent cutting off of last row
            w = Math.max(w,scroller.getHorizontalScrollBar().getSize().width);
            h = Math.max(h,scroller.getVerticalScrollBar().getSize().height);
            holder.setSize(w,h);
            holder.validate();
            scroller.setViewportView(holder);
        
            model.fireTableStructureChanged();
            table.getSelectionModel().setSelectionInterval(0, 0); 
        
            // set the entries for the table and model
            model.setEntries(entries);
        
            // scroll to first entry
            table.scrollRectToVisible(new Rectangle(table.getCellRect(0, 0, true)));
        
            // get the sizes of the directories
            // start as many threads as needed, one per entry
            for(int i = 0; i < dirs.size();i++) {
                entry = dirs.get(i);
                //System.err.println("getDirSize: " + entry.getAbsolutePath());
                SizeGetter_Dir getter = new SizeGetter_Dir(this,i,entry,client);
                getter.start();
                sizeGetters.add(getter);
            }
        
            // when QUIET_START is done, turn on debugging info
            if (firstRun) {
                //oldEnv = client.getEnvironment();
                //client.setEnvironment(oldEnv);
                firstRun = false;
            }

            model.fireTableDataChanged();
            //table.repaint();
        } else {
            System.err.println(SN + ".dataRetrieved: no rows: Side: " + id);
            System.exit(0);
        }
    }

    public void delete(FileEntry entry) {
        System.out.println("Deleting...");
        boolean informDelayed = true;
        int count;
        List<String> selected = model.getSelection();
        for (int i = selected.size() - 1; i >= 0; i--) {
            String target = selected.get(i);
            count = 0;
            System.out.println("Deleting: " + target);
            client.delete(target);
            selected.remove(i);
            model.deselect(target);
            while (client.exists(target) && informDelayed) {
                Platform.sleep(125);
                count += 125;
                if (count == 3000 && informDelayed) {
                    Platform.message(app, "3 seconds have elapsed for deletion. You may have an open file.");
                    informDelayed = false;
                }
            }
        }
        if (informDelayed) {
            getEntries();
        }
    }

    public void deselectAll() {
        List<FileEntry> entries = model.getEntries();
        for (int i = 0; i < entries.size(); i++) {
            entries.get(i).deselect();
        }
    }

    /*
    public void aentryUpdated(FileEntry entry) {
        int row = model.indexOfName(entry.getName());
        System.out.println(client.listItem(entry.getName()));
        System.out.println("EntriesPanel.entryUpdated");
        System.exit(0);
//        List<String> list = client.getLast(ServerOps.LIST_ITEM);
//        String data = client.getItemData(entry.getName());
//        String[] detail = getNameAndRemainder(data);
//        List<String> parts = StringTool.explode(detail[1], ',');
//        if (parts.size() == 6) {
//            int size = parts.size();
//            String posix = parts.get(size - 3) + "," + parts.get(size - 2) + "," + parts.get(size - 1); // Consolidate POSIX permissions
//            entry = new FileEntry(client,detail[0], parts.get(0), parts.get(1), parts.get(2), posix);
//        } else {
//            entry = new FileEntry(client,detail[0], parts.get(0), parts.get(1), parts.get(2), parts.get(3)); // DOS Permissions are easier, no consolidation
//        } 
//        if (parts.get(0).equals("GET")) {
//            SizeGetter_Dir getter = new SizeGetter_Dir(this,row, entry, client);
//            while (!getter.isDone()) {
//                Platform.sleep(125);
//            }
//            entry.setSizeLong(getter.getSize());
//        }
//        model.setEntry(row, entry);
        model.fireTableDataChanged();
    }
*/
    public Client getClient() {
        return client;
    }

    public int getColumnWidth(int colIndex) {
        return table.getColumnWidth(colIndex);
    }
    
    public int[] getColumnWidths() {
        SystemTokenPainter painter;
        Font font = new JLabel().getFont();
        TextPoints textPoints = TextPoints.getInstance(font);
        List<FileEntry> entries = model.getEntries();
        int[] widths;
        if (entries.get(0).isNix()) {
            widths = new int[7];
        } else {
            widths = new int[5];
        }
        for (int i = 0; i < entries.size(); i++) {
            FileEntry entry = entries.get(i);
            for(int j = 0; j < widths.length;j++) {
                painter = new SystemTokenPainter(textPoints,new TextToken(entry.getPart(j)));
                widths[j] = Math.max(widths[j],painter.getTextWidth(1));
            }
        }
        // add in padding
        widths[0] += 20; // name
        widths[3] += 20; // modified
        return widths;
    }
    
    public final void getEntries() {
        Boolean exists = client.exists(StringTool.getDoubleQuoted(getSelectedPath()));
        System.out.println(SN + ".getEntries: exists: " + exists);
        if (!client.exists(StringTool.getDoubleQuoted(getSelectedPath()))) {
            path.setText("");
            storePath( "");
            // path doesn't exist -- check if root exists
            if (!client.exists(getRoot())) {
                setRootsQuiet();
                storeRoot(((String) roots.getSelectedItem()).charAt(0));
            }
        }
            boolean debug = false;
//            System.out.println("Before dataGetter");
//            System.out.println("EntriesPanel.getEntries");
//            System.exit(0);
            DataGetterThread getter = new DataGetterThread(client, StringTool.getDoubleQuoted(getSelectedPath()), table, this);
            getter.start();
//        }
    }

    public FileEntry getEntry(String name) {
        return model.getEntryByDisplayName(name);
    }
    
    
/** marked for deletion
    public String agetFormatted_Decimal(long num) {
        String s = "";
        long remainder = num;
        long trillions = remainder / (long) Math.pow(1000, 4);
        remainder = remainder - (trillions * (long) Math.pow(1000, 4));
        long billions = remainder / (long) Math.pow(1000, 3);
        remainder = remainder - (billions * (long) Math.pow(1000, 3));
        long millions = remainder / (long) Math.pow(1000, 2);
        remainder = remainder - (millions * (long) Math.pow(1000, 2));
        long thousands = remainder / 1000;
        remainder = remainder - (thousands * 1000);
        if (trillions > 0) {
            s += trillions + ",";
        }
        if (billions > 0) {
            s += billions + ",";
        }
        if (millions > 0) {
            s += millions + ",";
        }
        if (thousands > 0) {
            s += thousands + ",";
        }
        s += remainder; // 0-999
        return s;
    }
*/
    public FileEntriesTableModel getModel() {
        return (FileEntriesTableModel) table.getModel();
    }

    public static String[] getNameAndRemainder(String s) {
        String name = "";
        String remainder = "";
        if (s.trim().startsWith("\"")) {
            name = s.substring(0, s.indexOf("\"", 1) + 1); // in our case, we are making a FileEntry, so it will take the quotes
            // which is important because the name search relies upon the fact
            // that the names aren't processed from the PKIServer results
            remainder = s.substring(name.length() + 1);
            //System.out.println("Name: " + name);
            //System.out.println("Remainder: " + remainder);
        } else {
            name = s.substring(0, s.indexOf(","));
            remainder = s.substring(name.length() + 1);
        }
        return new String[]{name, remainder};
    }

    public Container getParentComponent() {
        return getParent();
    }

    public String getPath() {
        return path.getText();
    }

    public String getPropertiesFilenameFor(String clientId) {
        return FileTool.getPropertiesFilenameForClient(clientId);
    }

    public String getRoot() {
        String root = (String) roots.getSelectedItem();
        if (root == null) {
            setRootsQuiet();
        }
        return (String) roots.getSelectedItem();
    }

    /**
     * @return the first character of the selected root 
     * ('/' | 'A' to 'Z' depending on configuration)
     */
    public Character getRootChar() {
        String root = getRoot();
        if (root != null) {
            return root.charAt(0);
        } else {
            setRootsQuiet();
            return getRoot().charAt(0);
        }
    }

    public List<String> getSelection() {
        return model.getSelection();
    }

    public String getSelectedPath() {
        return getRoot() + path.getText();
    }

    public String getServer() {
        return (String) servers.getSelectedItem();
    }

    public String getId() {
        return id;
    }

    public int getSelectedIndex() {
        return firstIndex;
    }
    
    public String getStoredPath() {
        String stored = "getStoredPath: " + TecData.UNSET_S;
        EntriesPanel panel = null;
        if (id.equals("LEFT")) {
            Character rootChar = getRootChar();
            if (rootChar != null) {
                stored = app.getProperties().get(getServer() + ".l." + rootChar + ".path");
            }
        } else if (id.equals("RIGHT")) {
            Character rootChar = getRootChar();
            if (rootChar != null) {
                stored = app.getProperties().get(getServer() + ".r." + rootChar + ".path");
            }
        }
        if (stored == null) {
            System.out.println("StoredPath == null: " + id);
            stored = "";
            storePath(stored);
        }
        return stored;
    }

    public Character getStoredRoot() {
        String storedRoot;
        if (id.equals("LEFT")) {
            storedRoot = app.getProperties().get(getServer() + ".l.root");
        } else {
            storedRoot = app.getProperties().get(getServer() + ".r.root");
        }
        //System.err.println("GetStoredRoot: " + stored);
        if (storedRoot == null) {
            // no data
            setRootsQuiet();
            storedRoot = getRoot();
            storeRoot(storedRoot.charAt(0));
        }
        return storedRoot.charAt(0);
    }

    public FileEntriesTable getTable() {
        return table;
    }

    public Client getTLSClient() {
        return client;
    }

    public boolean hasRoot(char ch) {
        String root = ch + "";
        if (ch != '/') {
            root += ":\\";
        }
        for (int i = 0; i < roots.getItemCount(); i++) {
            if (roots.getItemAt(i).equals(root)) {
                return true;
            }
        }
        return false;
    }

    public static void main(String[] args) {
        FileTool.launch();
    }
    
    public void mouseClicked(MouseEvent e) {
        int row = table.rowAtPoint(e.getPoint());
        int col = table.columnAtPoint(e.getPoint());
        FileEntriesTableModel model = table.getBaseTableModel();
        if (e.getSource() == upDir) {
            stopSizeGetters();
            upOne();
            getEntries();
            app.repaint();
        } else if (e.getSource() == refresh) {
            stopSizeGetters();
            getEntries(); 
        } else if (e.getSource() == env) {
            if (env.getTag().equals("PROD")) {
//                client.setEnvironment(EnvData.PROD);
            } else {
//                client.setEnvironment(EnvData.DEV);
            }
        } else if (SwingUtilities.isLeftMouseButton(e)) {
            if (e.getSource() == table && e.getClickCount() == 2) {
                FileEntry entry = model.getEntry(table.convertRowIndexToModel(row));
                if (col == 0 && entry.isDirectory()) {
                    // navigate to directory
                    stopSizeGetters();
                    System.err.println("EntriesPanel.mc: Display: " + entry.getDisplayName());
                    String newPath = path.getText() + entry.getDisplayName() + entry.getFileSeparator();
                    path.setText(newPath);
                    System.err.println("--------> path.getText: " + path.getText());
                    storePath(path.getText());
                    System.err.println("--------> storedPath: " + getStoredPath());
                    getEntries();
                } else {
                    // view text <<--- needs ViewFile according to type
                    if (entry.isText()) {
                        TextViewer viewer = new TextViewer();
                        viewer.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
                        viewer.setVisible(true);
                        viewer.open(client,entry.getName());
                    }
                }
            } else if (e.getSource() == table && e.isControlDown()) {
                FileEntry entry = model.getEntry(row);
                if (model instanceof FileEntriesTableModelDOS && col == 4) {
                    // edit DOS attributes
                    JDialog dialog = new DialogSetDOSFileAttributes(this, entry);
                    dialog.setLocationRelativeTo(app);
                    dialog.setVisible(true);
                } else {
                    if (model instanceof FileEntriesTableModelPOSIX) {
                        if (col == 4) {
                            // edit POSIX owner
                            JDialog dialog = new DialogSetPOSIXUser(this, entry);
                            dialog.setLocationRelativeTo(app);
                            dialog.setVisible(true);
                        } else if (col == 5) {
                            // eidt POSIX group;
                            JDialog dialog = new DialogSetPOSIXGroup(this, entry);
                            dialog.setLocationRelativeTo(app);
                            dialog.setVisible(true);
                        } else if (col == 6) {
                            // edit POSIX File permissions
                            JDialog dialog = new DialogSetPOSIXFilePermissions(this, entry);
                            dialog.setLocationRelativeTo(app);
                            dialog.setVisible(true);
                        }
                    }
                } 
            }
        } else if (SwingUtilities.isRightMouseButton(e)) {
            if (e.getSource() == table) {
                // select if necessary
                if (!controlDown && !shiftDown) {
                    if (row >= 0) {
                        model.clearSelection();
                        model.select(row);
                    }
                }
                // get the entry 
                if (row >= 0) {
                    entry = model.getEntry(row);
                }
                // show menu for single item
                if (model.getSelection().size() == 1) {
                    if (row >= 0 && col == 0) {
                        showFileOpsMenu(e);
                    } else {
                        popupReset();
                        popupShow(e);
                    }
                } else if (row >= 0 && 
                           model.getEntry(row).isSelected() &&
                           getSelection().size() > 1) 
                {
                    showFileOpsMenu(e);
                } else { // user clicked in bottom of table, only add new file/folder
                    popupReset();
                    popupShow(e);
                }
            } else {
                popupReset();
                popupShow(e);
            }
        }
    }

    public void mouseDragged(MouseEvent e) {
//        app.setDragSource(this);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
//        app.setLastDestination(this); // set to the first panel, if doDrop gets 
        // called, it will be set to the actual destination and we need
        // something there to avoid an NPE
        int row = table.rowAtPoint(e.getPoint());
        controlDown = e.isControlDown();
        shiftDown = e.isShiftDown();
        if (firstIndex == -1) {
            firstIndex = row;
        }
    }

    public void mouseReleased(MouseEvent e) {
        int row = table.rowAtPoint(e.getPoint());
        controlDown = e.isControlDown();
        shiftDown = e.isShiftDown();
        if (SwingUtilities.isLeftMouseButton(e)) {
            if (row == -1 && !controlDown && !shiftDown) {
                if (model != null) model.clearSelection();
            } else if (firstIndex == -1) {
                if (row >= 0) {
                    firstIndex = row;
                    lastIndex = -1;
                    model.select(row);
                    lastSet = row;
                }
            } else if (controlDown && shiftDown) {
                if (row >= 0) {
                    model.deselect(lastSet);
                    int min = Math.min(lastSet, row);
                    int max = Math.max(lastSet, row);
                    for (int i = min; i <= max; i++) {
                        model.toggleSelected(i);
                    }
                    firstIndex = -1;
                    lastIndex = -1;
                    lastSet = row;
                }
            } else if (controlDown && !shiftDown) {
                if (row >= 0) {
                    model.toggleSelected(row);
                    if (!model.isSelected(row)) {
                        firstIndex = -1;
                    }
                    lastSet = row;
                }
            } else if (shiftDown) {
                if (row >= 0 && firstIndex >= 0) {
                    int min = Math.min(firstIndex, row);
                    int max = Math.max(firstIndex, row);
                    for (int i = min; i <= max; i++) {
                        model.select(i);
                    }
                }
            } else {
                if (row >= 0) {
                    model.clearSelection();
                    model.select(row);
                    firstIndex = row;
                    lastIndex = -1;
                    lastSet = row;
                }
            }
        } else if (SwingUtilities.isRightMouseButton(e)) {
            if (row >= 0) {
                System.out.println("entry: " + model.getEntry(row).toString());
            }
        }
        System.out.println("LastSet: " + lastSet + " Row: " + row + " First: " + 
                           firstIndex + " Last: " + lastIndex + " shift: " + shiftDown + 
                           " ctrl: " + controlDown);
        if (model != null) model.fireTableDataChanged();
    }

    public void operateRoots() {
        stopSizeGetters();
        String root = (String) roots.getSelectedItem();
        storeRoot(root.charAt(0));
        String storedPath = getStoredPath();
        if (storedPath.startsWith("/")) {
            storedPath = storedPath.substring(1);
        }
        path.setText(storedPath);
        storePath(path.getText());
        validatePath();
        getEntries();
    }

    public void operateServers() {
        stopSizeGetters();
        String server = (String) servers.getSelectedItem();
        if (server.contains(" ")) {
            server = NameService.instance.getByName(server);
        }
        if (!setServer(server)) {
            server = "localhost";
            setServer(server);
        }
        storeServer(server);
        setRootsQuiet();
        getStoredRoot();
        getStoredPath();
        validatePath();
        getEntries();
    }

    
    public void popupReset() {
        popup = new JPopupMenu();
        popupAddFindFromHere();
        popupAddSeparator();
        popupAddNewFile();
        popupAddNewFolder();
    }

    public void popupAddFindFromHere() {
        popup.add(findFromHere);
    }

    public void popupAddNewFile() {
        popup.add(newFile);
    }

    public void popupAddNewFolder() {
        popup.add(newFolder);
    }

    public void popupAddRename() {
        popup.add(rename);
    }

    public void popupAddDelete() {
        popup.add(delete);
    }

    public void popupAddSeparator() {
        popup.addSeparator();
    }
    
    public void popupShow(MouseEvent e) {
        popup.show(table, e.getX(), e.getY());
    }

    public void popupShowDefault(MouseEvent e) {
        popupReset();
        popupAddNewFile();
        popupAddNewFolder();
        popupShow(e);
    }

    public void printSelection() {
        List<String> selection = getSelection();
        System.out.println("Selection: " + selection.size());
        for (int i = 0; i < selection.size(); i++) {
            System.out.println(i + ": " + selection.get(i));
        }
    }

    public void resizeColumn(int colIndex, int diff) {
        holder.setSize(holder.getSize().width + diff,holder.getSize().height);
        scroller.setViewportView(holder);
        //validate();
        table.setColumnWidth(colIndex,table.getColumnWidth(colIndex) + diff);
    }
    
    public String setDOSFileAttributes(FileEntry entry, String attributes) {
        client.setDOSFileAttributes(entry.getAbsolutePath(), attributes);
        return client.getDOSFileAttributes(entry.getAbsolutePath());
    }

    public void setEnvironment(String env) {
        if (env.equals(EnvData.PROD)) {
            this.env.setTag("P");
//            this.client.setEnvironment(env);
        } else {
            this.env.setTag("D");
//            this.client.setEnvironment(env);
        }
    }
    
    public void setPath(String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        this.path.setText(path);
        storePath(path);
    }

    public String setPOSIXFilePermissions(FileEntry entry, String permissions) {
        client.setPOSIXFilePermissions(entry.getAbsolutePath(), permissions);
        return client.getPOSIXFilePermissions(entry.getAbsolutePath());
    }

    public void setPOSIXGroup(FileEntry entry, String group) {
        client.setPOSIXGroup(entry.getAbsolutePath(), group);
    }

    public void setPOSIXUser(FileEntry entry, String owner) {
        client.setPOSIXUser(entry.getAbsolutePath(), owner);
    }

    public void setRoot(char root) {
        if (root == '/') {
            roots.setSelectedItem("/");
        } else {
            roots.setSelectedItem(root + ":\\");
        }
    }

    public void setRootsQuiet() {
        quiet = true;
        List<String> roots = client.listRoots();
        if (this.roots.getItemCount() > 0) {
            this.roots.removeAllItems();
        }
        for (int i = 0; i < roots.size(); i++) {
            this.roots.addItem(StringTool.getUnwrapped(roots.get(i)));
        }
        this.roots.setSelectedItem(0);
        quiet = false;
    }

    boolean debug = true;
    
    public boolean setServer(String label) {
        //System.out.println("EntriesPanel: setServer: " + label);
        boolean found = false;
        if (Internet.isIP(label)) {
            label = NameService.instance.getByIP(label);
        }
        for (int i = 0; i < servers.getItemCount(); i++) {
            if (servers.getItemAt(i).equals(label)) {
                found = true;
                servers.setSelectedItem(label);
            }
        }
        if (!found) {
            servers.addItem(label);
            servers.setSelectedItem(label);
            // what to do about Client?
        } else {
            // server is found, 
        }
        String clientId = label;
        String hostname = "";
        if (StringTool.count(clientId,'.') == 3 && Internet.isIP(clientId)) {
            hostname = Internet.getHostname(clientId);
        } 
        Boolean state = false;
        stopSizeGetters();
        String propsFilename = getPropertiesFilenameFor(clientId);
        Properties props = new Properties(propsFilename);
        System.out.println("EntriesPanel: using properties for client: " + propsFilename);
        boolean failed = false;
        try {
            client = new Client(props,true,null);
        } catch (NoTLSConnectionException ntlsce) {
            ExceptionHandler.handle(SN + ".setServer","no TLS connection",ntlsce, true);
            Platform.message(app,SN + ".setServer: no TLS connection: reverting to localhost.");
            try {
                client = new Client(FileTool.getPropertiesFor("localhost"),true,null);
            } catch (NoTLSConnectionException ntlsce2) {
                Platform.message(app,SN + ".setServer(2): no TLS connection to localhost. Exiting.");
                System.exit(0);
            }
            failed = true;
        }
        if (!failed) {
            storeServer(clientId);
            getStoredRoot();
            getStoredPath();
            return true;
        }
        return false;
    }

    public final void setServerLabels(List<String> names) {
        servers.removeAllItems();
        for (int i = 0; i < names.size(); i++) {
            servers.addItem(StringTool.getUnwrapped(names.get(i)));
        }
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setupDND() {
        ds.createDefaultDragGestureRecognizer(table, DnDConstants.ACTION_COPY_OR_MOVE, new DragGestureListener() {
            @Override
            public void dragGestureRecognized(DragGestureEvent dge) {
                try {
                    if (model.getSelection().size() > 0) {
                        ds.startDrag(dge, null, new FileListTransferable(getSelection()), new DragSourceListener() {

                            @Override
                            public void dragEnter(DragSourceDragEvent dsde) {
                            }

                            @Override
                            public void dragOver(DragSourceDragEvent dsde) {
                            }

                            @Override
                            public void dropActionChanged(DragSourceDragEvent dsde) {
                            }

                            @Override
                            public void dragExit(DragSourceEvent dse) {
                            }

                            @Override
                            public void dragDropEnd(DragSourceDropEvent dsde) {
                                setCursor(java.awt.Cursor.getDefaultCursor());
                            }

                        });
                    }
                } catch (InvalidDnDOperationException idndoe) {
                    System.out.println(">>> Invalid drag state: already started. Ignoring.");
                }
            }
        });
    }

    public void setupGUI() {
        JPanel settingsHolder = new JPanel(new GridLayout(3, 1));
        JPanel hosts = new JPanel(new BorderLayout());
        hosts.add(servers,BorderLayout.CENTER);
        hosts.add(addServer,BorderLayout.EAST);
        settingsHolder.add(hosts);
        settingsHolder.add(roots);
        pathLine.add(path, BorderLayout.CENTER);
        buttons.add(upDir);
        buttons.add(refresh);
        if (debug) buttons.add(env);
        pathLine.add(buttons, BorderLayout.EAST);
        settingsHolder.add(pathLine);
        
        JPanel contentHolder = new JPanel(new BorderLayout(0, 0));
        setLayout(new BorderLayout(0, 0));
        add(settingsHolder, BorderLayout.NORTH);
        add(contentHolder, BorderLayout.CENTER);
        validate();

        table.setFillsViewportHeight(true);
        table.setRowHeight(24);
        table.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        table.getTableHeader().setResizingAllowed(true);
                
        holder = new SizedPanel(1,1);
        holder.setLayout(new BorderLayout());
        holder.add(table.getTableHeader(),BorderLayout.NORTH);
        holder.add(table,BorderLayout.CENTER);
        scroller = new JScrollPane(holder, JScrollPane.VERTICAL_SCROLLBAR_ALWAYS, JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
        scroller.getVerticalScrollBar().setUnitIncrement(16);
        contentHolder.add(scroller, BorderLayout.CENTER);
        revalidate();
    }

    public void showFileOpsMenu(MouseEvent e) {
        popupReset();
        popupAddSeparator();
        popupAddDelete();
        popupAddSeparator();
        popupAddRename();
        popupShow(e);
    }

    public void stopSizeGetters() {
        for(int i = 0; i < sizeGetters.size();i++) {
            sizeGetters.get(i).setPost(false);
        } 
        sizeGetters = new ArrayList<>();
    }

    public void storePath(String path) {
        if (path.startsWith("/")) path = path.substring(1);
        if (id.equals("LEFT")) {
            app.getProperties().set(getServer() + ".l." + getRootChar() + ".path", path);
        } else { // RIGHT
            app.getProperties().set(getServer() + ".r." + getRootChar() + ".path", path);
        }
    }

    public void storeRoot(char root) {
        if (id.equals("LEFT")) {
            app.getProperties().set(getServer() + ".l.root", root);
        } else { // RIGHT
            app.getProperties().set(getServer() + ".r.root", root);
        }
    }

    public void storeServer(String host) {
        if (id.equals("LEFT")) {
            app.getProperties().set("l.host", host);
        } else {  // RIGHT
            app.getProperties().set("r.host", host);
        }
    }

    public void upOne() {
        String text = path.getText();
        if (text.startsWith("/")) {
            text = text.substring(1);
            path.setText(text);
        }
        if (text.length() > 0) {
            String separator = StringTool.getLastCharacter(text); // path separator will be last char
            text = StringTool.rTrim(text,1);
            if (text.contains(separator)) {
                path.setText(text.substring(0, text.lastIndexOf(separator) + 1));
            } else {
                // no separator, so in the last directory
                path.setText("");
            }
        }
        storePath(path.getText());
    }

    public void updateEntry(int rowIndex, FileEntry entry) {
        model.setEntry(rowIndex, entry);
        model.fireTableRowsUpdated(rowIndex, rowIndex);
        table.repaint();
    }

    public void validatePath() {
        if (!client.exists(getSelectedPath())) {
            path.setText("");
            storePath("");
        }
    } 

} 
