package ca.tecreations;

import ca.tecreations.Point;
import ca.tecreations.Properties;
import ca.tecreations.StringTool;
import ca.tecreations.TypeToType;

import java.awt.Dimension;
import java.util.List;

/**
 *
 * @author Tim
 */
public class UnicodeData {

    public String unicode;
    public List<Point> points;
    public Dimension size;

    public UnicodeData(String unicode, List<Point> points, Dimension size) {
        this.unicode = unicode;
        this.points = points;
        this.size = size;
    }

    public static UnicodeData fromStored(String stored) {
        String first = StringTool.getNextDoubleQuoted(stored);
        String remainder = stored.substring(first.length() + 1);
        String second = StringTool.getNextDoubleQuoted_Unwrapped(remainder);
        String third = remainder.substring(second.length() + 1);
        String code = StringTool.getUnwrapped(first);
        List<Point> pts = TypeToType.fromSemiSeparated(second);
        String temp = StringTool.getUnwrapped(third);
        int w = Integer.parseInt(temp.substring(0, temp.indexOf(",")));
        int h = Integer.parseInt(temp.substring(temp.indexOf(",") + 1));
        Dimension sz = new Dimension(w, h);
        return new UnicodeData(code, pts, sz);
    }

    //--------------------------------------------------------------------------
    
    public String getCodeIndex(String s) {
        if (s.length() == 6) {
            return "" + s.charAt(4) + s.charAt(5);
        } else if (s.length() == 5) {
            return "" + s.charAt(3) + s.charAt(4);
        } else if (s.length() == 4) {
            return "" + s.charAt(2) + s.charAt(3);
        } else {
            throw new IllegalArgumentException("getCodePointFull: illegal size: '" + s + "'");
        }
    }

    public void write(Properties props) {
        String value = StringTool.getDoubleQuoted(unicode) + ",";
        value += StringTool.getDoubleQuoted(TypeToType.toSemiSeparatedString(points)) + ",";
        value += StringTool.getDoubleQuoted(size.width + "," + size.height);
        props.set(getCodeIndex(unicode), value);
    }

}
