package a.test2;

import ca.tecreations.*;
import ca.tecreations.components.*;

import java.awt.Graphics;
import java.awt.event.*;
import java.util.List;

import javax.swing.*;

/**
 *
 * @author Tim
 */
public class MousedFrame extends TFrame 
        implements MouseListener, MouseMotionListener, MouseWheelListener 
{
    LoadCursor cursorLoader = new LoadCursor();
    Cursor cursor = new Cursor();
    public static MousedFrame instance;
    public static Properties props = new Properties(ProjectPath.getPropertiesPath() + "MousedFrame.properties");
    CursorData cursorData = null;
    int mouseX;
    int mouseY;
    
    int nameIndex = 0;
    List<String> names = LoadCursor.names;
    
    
    
    public MousedFrame() {
        super(props,MousedFrame.class.getSimpleName());
        addMouseListener();
        addMouseMotionListener(); 
        addMouseWheelListener();
    }

    public MousedFrame(Properties props, String tag) {
        super(props,tag);
        getProperties().getFilename();
        addMouseListener();
        addMouseMotionListener();
        addMouseWheelListener();
    }
    
    public void addMouseListener() {
        getHolder().addMouseListener(this);
    }
    
    public void addMouseMotionListener() {
        getHolder().addMouseMotionListener(this);
    }
    
    public void addMouseWheelListener() {
        getHolder().addMouseWheelListener(this);
    }
    
    public static void createAndShowGUI() {
        instance = new MousedFrame();
        instance.setVisible(true);
    }
    
    public static void launch() {
        SwingUtilities.invokeLater( () -> {
            createAndShowGUI();
        });
    }
    
    public static void main(String[] args) {
        launch();
    }
    
    public void mouseClicked(MouseEvent e) {
        nameIndex++;
        if (nameIndex >= names.size()) nameIndex = 0;
        setCursor(names.get(nameIndex));
        repaint();
    }
    
    public void mouseDragged(MouseEvent e) {
        mouseX = e.getX();
        mouseY = e.getY();
        repaint();
    }
    
    public void mouseEntered(MouseEvent e) {
        mouseX = e.getX();
        mouseY = e.getY();
        repaint();
    }
    
    public void mouseExited(MouseEvent e) {
        mouseX = e.getX();
        mouseY = e.getY();
        repaint();
    }
    
    public void mouseMoved(MouseEvent e) {
        mouseX = e.getX();
        mouseY = e.getY();
        repaint();
    }
    
    public void mousePressed(MouseEvent e) {}
    
    public void mouseReleased(MouseEvent e) {}
    
    public void mouseWheelMoved(MouseWheelEvent e) {}
    
    public void paint(Graphics g) {
        super.paint(g);
        int cursorWidth = Cursor.instance.getActive().getWidth();
        int cursorHeight = Cursor.instance.getActive().getHeight();
        TPanel holder = getHolder();
        g = holder.getGraphics();
        Cursor.active.paintAt(g,mouseX - cursorWidth,mouseY - cursorHeight);
    }
    
    public void setCursor(String name) {
        cursorData = Cursor.instance.get(name);
        Cursor.active = cursorData;
        repaint();
    }
    
}
