package ca.tecreations.components;

import ca.tecreations.ProjectPath;
import ca.tecreations.SystemTool;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.*;

import javax.swing.*;
    
/**
 *
 * @author tim
 */
public class CommandInput extends JPanel implements ActionListener {
    SystemTool sysTool = new SystemTool();
    CommandInput_History dialog;
    JTextField txt = new JTextField(64);
    JButton clear = new JButton("Clear");
    JButton go = new JButton("Go");
    JButton history = new JButton("History");

    public CommandInput(TFrame app) {
        super(new BorderLayout());
        dialog = new CommandInput_History(app,this,ProjectPath.getTecPropsPath() + "CommandInput_History.properties");
        
        add(txt,BorderLayout.CENTER);
        JPanel buttons = new JPanel(new FlowLayout());
        buttons.add(clear);
        clear.addActionListener(this);
        buttons.add(go);
        buttons.add(history);
        add(buttons,BorderLayout.EAST);

    }
    
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == clear) {
            txt.setText("");
        }
    }
    
    public void execute(String cmd) {
        sysTool.spawnAndOutput(System.out,System.err,cmd,true);
    }
    
    public JButton getGoButton() { return go; }
    
    public JButton getHistoryButton() { return history; }
    
    public String getText() { return txt.getText(); }
    
    public JTextField getTextField() { return txt; }
    
    public void setText(String txt) {
        this.txt.setText(txt);
    }
    
}
