package ca.tecreations.apps.deploy;

import ca.tecreations.*;

import java.util.*;

/**
 *
 * @author Tim
 */
public class GetPackingList {
    File root;
    List<String> includes;
    List<String> excludes;
    boolean sources;
    boolean classes;
    boolean unspecified;
    boolean jars;
    List<File> packingList = new ArrayList<>();
    public static boolean debug = false;
    
    public GetPackingList(File root,List<String> includes, List<String> excludes, boolean sources, boolean classes, boolean unspecified,boolean jars) {
        if (!root.isDirectory()) throw new IllegalArgumentException("GetPackingList(): root must be a directory: " + root);
        this.root = root;
        this.includes = includes;
        this.excludes = excludes;
        this.sources = sources;
        this.classes = classes;
        this.unspecified = unspecified;
        this.jars = jars;
        packingList = getPackingList(root);
    }
    
    public boolean checkDir(File d) {
        String unwrapped = d.getUnwrapped();
        if (d.getName().toLowerCase().equals("jars") && jars) {
            if (debug) System.out.println("Included(d1): " + d.getAbsolutePath());
            return true;
        }
        for(int i = 0; i < includes.size();i++) {
            String include = includes.get(i);
            if (include.indexOf("*") > 0 && !include.endsWith("*")) {
                String start = include.substring(0,include.indexOf('*'));
                String end = include.substring(include.indexOf('*') + 1);
                String name = d.getName();
                if (name.startsWith(start) && name.endsWith(end)) {
                    if (debug) System.out.println("Included(d2): " + d.getAbsolutePath());
                    return true;
                }
            } else if (include.startsWith("*") && include.endsWith("*")) {
                String s = include.substring(1,include.length() - 1);
                if (unwrapped.contains(s)) {
                    if (debug) System.out.println("Included(d3): " + d.getAbsolutePath());
                    return true;
                }
            } else if (include.startsWith("*")) {
                String s = include.substring(1);
                if (unwrapped.endsWith(s)) {
                    if (debug) System.out.println("Included(d4): " + d.getAbsolutePath());
                    return true;
                }
            } else if (include.endsWith("*")) {
                String s = include.substring(0,include.length() - 1);
                if (unwrapped.startsWith(s)) {
                    if (debug) System.out.println("Included(d5): " + d.getAbsolutePath());
                    return true;
                }
            } else if (StringTool.getUnwrapped(include).equals(unwrapped)) {
                if (debug) System.out.println("Included(d6): " + d.getAbsolutePath());
                return true;
            }
        }
        for(int i = 0; i < excludes.size();i++) {
            String exclude = StringTool.getUnwrapped(excludes.get(i));
            if (exclude.indexOf("*") > 0 && !exclude.endsWith("*")) {
                String start = exclude.substring(0,exclude.indexOf('*'));
                String end = exclude.substring(exclude.indexOf('*') + 1);
                String name = d.getName();
                if (name.startsWith(start) && name.endsWith(end)) {
                    if (debug) System.out.println("Excluded(d7): " + d.getAbsolutePath());
                    return false;
                }
            } else if (exclude.startsWith("*") && exclude.endsWith("*")) {
                String s = exclude.substring(1,exclude.length() - 1);
                if (unwrapped.contains(s)) {
                    if (debug) System.out.println("Excluded(d8): " + d.getAbsolutePath());
                    return false;
                }
            } else if (exclude.startsWith("*")) {
                String s = exclude.substring(1);
                if (unwrapped.endsWith(s)) {
                    if (debug) System.out.println("Excluded(d9): " + d.getAbsolutePath());
                    return false;
                }
            } else if (exclude.endsWith("*")) {
                String s = exclude.substring(0,exclude.length() - 2);
                if (unwrapped.startsWith(s)) {
                    if (debug) System.out.println("Excluded(d10): " + d.getAbsolutePath());
                    return false;
                }
            } else if (StringTool.getUnwrapped(exclude).equals(unwrapped)) {
                if (debug) System.out.println("Excluded(d11): " + d.getAbsolutePath());
                return false;
            }
        }
        if (unspecified) {
            if (debug) System.out.println("Included(d12): " + d.getAbsolutePath());
            return true;
        } else {
            if (debug) System.out.println("Excluded(d13): " + d.getAbsolutePath());
            return false;
        }
    }
    
    public boolean checkFile(File f) {
        if (f.isFile()) {
            if (f.is("java")) {
                if (sources) {
                    if (debug) System.out.println("Included(f1): " + f.getAbsolutePath());
                    return true;
                }
                else {
                    if (debug) System.out.println("Excluded(f2): " + f.getAbsolutePath());
                    return false;
                }
            }
            if (f.is("class")) {
                if (classes) {
                    if (debug) System.out.println("Included(f3): " + f.getAbsolutePath());
                    return true;
                } else {
                    if (debug) System.out.println("Excluded(f4): " + f.getAbsolutePath());
                    return false;
                }
            }
            if (f.is("jar")) {
                if (jars) {
                    if (debug) System.out.println("Included(f5): " + f.getAbsolutePath());
                    return true;
                } else {
                    if (debug) System.out.println("Excluded(f6): " + f.getAbsolutePath());
                    return false;
                }
            }
        }
        String unwrapped = f.getUnwrapped();
        for(int i = 0; i < includes.size();i++) {
            String include = includes.get(i);
            if (include.indexOf("*") > 0 && !include.endsWith("*")) {
                String start = include.substring(0,include.indexOf('*'));
                String end = include.substring(include.indexOf('*') + 1);
                String name = f.getName();
                if (name.startsWith(start) && name.endsWith(end)) {
                    if (debug) System.out.println("Included(f7): " + f.getAbsolutePath());
                    return true;
                }
            } else if (include.startsWith("*") && include.endsWith("*")) {
                String s = include.substring(1,include.length() - 1);
                if (unwrapped.contains(s)) {
                    if (debug) System.out.println("Included(f8): " + f.getAbsolutePath());
                    return true;
                }
            } else if (include.startsWith("*")) {
                String s = include.substring(1);
                if (unwrapped.endsWith(s)) {
                    if (debug) System.out.println("Included(f9): " + f.getAbsolutePath());
                    return true;
                }
            } else if (include.endsWith("*")) {
                String s = include.substring(0,include.length() - 1);
                if (unwrapped.startsWith(s)) {
                    if (debug) System.out.println("Included(f10): " + f.getAbsolutePath());
                    return true;
                }
            }
        }
        for(int i = 0; i < excludes.size();i++) {
            String exclude = StringTool.getUnwrapped(excludes.get(i));
            if (exclude.indexOf("*") > 0 && !exclude.endsWith("*")) {
                String start = exclude.substring(0,exclude.indexOf('*'));
                String end = exclude.substring(exclude.indexOf('*') + 1);
                String name = f.getName();
                if (name.startsWith(start) && name.endsWith(end)) {
                    if (debug) System.out.println("Excluded(f11): " + f.getAbsolutePath());
                    return false;
                }
            } else if (exclude.startsWith("*") && exclude.endsWith("*")) {
                String s = exclude.substring(1,exclude.length() - 1);
                if (unwrapped.contains(s)) {
                    if (debug) System.out.println("Excluded(f12): " + f.getAbsolutePath());
                    return false;
                }
            } else if (exclude.startsWith("*")) {
                String s = exclude.substring(1);
                if (unwrapped.endsWith(s)) {
                    if (debug) System.out.println("Excluded(f13): " + f.getAbsolutePath());
                    return false;
                }
            } else if (exclude.endsWith("*")) {
                String s = exclude.substring(0,exclude.length() - 1);
                if (unwrapped.startsWith(s)) {
                    if (debug) System.out.println("Excluded(f14): " + f.getAbsolutePath());
                    return false;
                }
            }
        }
        if (unspecified) {
            if (debug) System.out.println("Included(f15): " + f.getAbsolutePath());
            return true;
        } else {
            if (debug) System.out.println("Excluded(f16): " + f.getAbsolutePath());
            return false;
        }
    }
    
    public List<File> getPackingList() { return packingList; }

    public List<File> getPackingList(File root) {
        for(int i = 0; i < includes.size();i++) {
            String include = includes.get(i);
            int count = StringTool.count(include,'*');
            if (count > 2 | 
                (count == 2 && !include.startsWith("*") && !include.endsWith("*"))) {
                throw new IllegalArgumentException("GetPackingList.getPackingList: include: " + include + " : too many asterisks");
            }
        }
        for(int i = 0; i < excludes.size();i++) {
            String exclude = excludes.get(i);
            int count = StringTool.count(exclude,'*');
            if (count > 2 | 
                (count == 2 && !exclude.startsWith("*") && !exclude.endsWith("*"))) {
                throw new IllegalArgumentException("GetPackingList.getPackingList: exclude: " + exclude + " : too many asterisks");
            }
        }
        
        Pair pair = new Pair(root);
        List<File> dirs = pair.getDirs();
        List<File> files = pair.getFiles();

        for(int i = 0; i < dirs.size();i++) {
            if (checkDir(dirs.get(i))) {
                List<File> entries = new GetPackingList(dirs.get(i),includes,excludes,sources,classes,unspecified,jars).getPackingList();
                for(int j = 0; j < entries.size();j++) {
                    packingList.add(entries.get(j));
                }
            }
        }

        for(int i = 0; i < files.size();i++) {
            File file = files.get(i);
            if (checkFile(file)) {
                packingList.add(file);
//            } else {
//                System.err.println("Excluded: " + file.getAbsolutePath());
            }
        }
        return packingList;
    }
    
    public static void main(String[] args) {
        GetPackingList.debug = false;
        List<String> includes = new ArrayList<>();
//        includes.add("*inc");
//        includes.add("inc*");
        includes.add("test*test");
        List<String> excludes = new ArrayList<>();
        excludes.add("exc*exc");
        excludes.add("*exc");
        excludes.add("exc*");
        excludes.add("*exc*");
        excludes.add("*Copy*");
        boolean sources = false;
        boolean classes = false;
        boolean unspecified = true;
        boolean jars = false;
        
        GetPackingList gpl = new GetPackingList(new File("D:\\test\\"),includes,excludes,sources,classes,unspecified,jars);
        List<File> list = gpl.getPackingList();
        for(int i = 0; i < list.size();i++) {
            System.out.println(list.get(i));
        }
    }
    
}
