package ca.tecreations.apps.capturetool;

import ca.tecreations.components.TDialog;
import ca.tecreations.components.TFrame;
import ca.tecreations.components.SizedPanel;
import ca.tecreations.misc.KeyProcessor;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
/**
 *
 * @author Tim 
 */
public class GetSize extends TDialog implements ActionListener, FocusListener, KeyListener {
    JTextField width = new JTextField(4);
    JTextField height = new JTextField(4);
    JButton ok = new JButton("OK"); 
    
    public GetSize(TFrame app) {
        super(app,"GetSize");
        setTitle("GetSize");
        setSize(180,145);
        setLocationRelativeTo(app);
        setupGUI();
        pack();
    }
    
    public int getWidthProperty() { return Integer.parseInt(width.getText()); }
    
    public int getHeightProperty() { return Integer.parseInt(height.getText()); }
    
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == ok) {
            System.out.println("Size: " + getSize());
            setVisible(false);
        }
    }
    
    public void focusLost(FocusEvent e) {}

    public void focusGained(FocusEvent e) {
        if (e.getSource() == width) width.selectAll();
        if (e.getSource() == height) height.selectAll();
    }

    public void keyPressed(KeyEvent e) {
        KeyProcessor kp = new KeyProcessor(e);
        if (kp.isEnter()) {
            setVisible(false);
        }
    }
    
    public void keyReleased(KeyEvent e) {}
    
    public void keyTyped(KeyEvent e) {}

    public void setWidthText(String s) {
        width.setText(s);
    }
    
    public void setHeightText(String s) {
        height.setText(s);
    }
    
    public void setupGUI() {
        JPanel holder = new JPanel(false);
        holder.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        holder.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();

        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        gbc.weightx = 0.5f;
        holder.add(new JLabel("Width: "),gbc);
        
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        gbc.weightx = 0.5f;
        holder.add(width,gbc);
        width.setText("0");
        width.addKeyListener(this);
        width.addFocusListener(this);
        
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        gbc.weightx = 0.5f;
        holder.add(new JLabel("Height: "),gbc);
        
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        gbc.weightx = 0.5f;
        holder.add(height,gbc);
        height.setText("0");
        height.addKeyListener(this);
        height.addFocusListener(this);
        
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 4;
        gbc.gridheight = 1;
        holder.add(new SizedPanel(10,10,getBackground()),gbc);

        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 4;
        gbc.gridheight = 1;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        gbc.weightx = 1.0;
        holder.add(ok,gbc);
        ok.addActionListener(this);
        addWindowListener(this);
        setSize(200,140);
        add(holder,BorderLayout.CENTER);
    }
}
