package ca.tecreations.apps._gui;

import ca.tecreations.FileEntry;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.*;

import javax.swing.*;

 
/**
 *
 * @author tim
 */
public class DialogSetDOSAttributes extends JDialog implements ActionListener {
    EntriesPanel panel;
    FileEntry entry;
    JCheckBox readOnly = new JCheckBox("Read Only");
    JCheckBox hidden = new JCheckBox("Hidden");
    JCheckBox system = new JCheckBox("System");
    JCheckBox archive = new JCheckBox("Archive");
    JButton cancel = new JButton("Cancel");
    JButton ok = new JButton("OK");
    
    
    public DialogSetDOSAttributes(EntriesPanel panel, FileEntry entry) {
        this.panel = panel;
        this.entry = entry;
        setTitle("DOS File Attributes : " + entry.getDisplayName());
        setSize(240,180);
        setLayout(new BorderLayout());
        JPanel boxes = new JPanel(new GridLayout(5,1));
        boxes.add(new JLabel("Attributes"));
        boxes.add(readOnly);
        boxes.add(hidden);
        boxes.add(system);
        boxes.add(archive);
        add(boxes,BorderLayout.CENTER);
        JPanel holder = new JPanel(new GridLayout(1,2));
        holder.add(cancel);
        holder.add(ok);
        add(holder,BorderLayout.SOUTH);
        cancel.addActionListener(this);
        ok.addActionListener(this);
        String attributes = entry.getDOSAttributes();
        if (attributes.contains("R")) {
            readOnly.setSelected(true);
        } else {
            readOnly.setSelected(false);
        }
        if (attributes.contains("H")) {
            hidden.setSelected(true);
        } else {
            hidden.setSelected(false);
        }
        if (attributes.contains("S")) {
            system.setSelected(true);
        } else {
            system.setSelected(false);
        }
        if (attributes.contains("A")) {
            archive.setSelected(true);
        } else {
            archive.setSelected(false);
        }
    }
    
    public void actionPerformed(ActionEvent e) {
        setVisible(false);
        if (e.getSource() == cancel) {
        } else if (e.getSource() == ok) {
            // do commit
            String attributesString = "";
            attributesString += (readOnly.isSelected() ? "R" : "-");
            attributesString += (hidden.isSelected() ? "H" : "-");
            attributesString += (system.isSelected() ? "S" : "-");
            attributesString += (archive.isSelected() ? "A" : "-");
            panel.setDOSFileAttributes(entry,attributesString);
            panel.updateEntry(panel.getSelectedIndex(),entry);
        }
    } 
}
