package ca.tecreations;

import java.awt.*;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
/**
 *
 * @author tim
 */
public class Pixel {
    public Color color;
    public Point p;
    
    public Pixel(int color, int x, int y) {
        p = new Point(x,y);
        this.color = new TColor(color);
    }
     
    public Pixel(Color color, int x, int y) {
        p = new Point(x,y);
        this.color = color;
    }
     
    public void draw(Graphics g) {
        Color oldColor = g.getColor();
        g.setColor(color);
        g.drawLine(p.x,p.y,p.x,p.y);
        g.setColor(oldColor);
    }
    
    public void draw(Graphics g,List<Point> list) {
        Color oldColor = g.getColor();
        g.setColor(color);
        Point p;
        for(int i = 0; i < list.size();i++) {
            p = list.get(i);
            g.drawLine(p.x,p.y,p.x,p.y);
        }
        g.setColor(oldColor);
    }
 
    public static Pixel get(String fromString) {
        //System.out.println("Pixel.get: fromString: " + fromString);
        String s = StringTool.getUnwrapped(fromString);
        int index1 = s.indexOf(",");
        int index2 = s.indexOf(",",index1+1);
        String colorString = s.substring(0,index1);
        int x = Integer.parseInt(s.substring(index1+1,index2));
        int y = Integer.parseInt(s.substring(index2 + 1));
        return new Pixel(Integer.parseInt(colorString),x,y);
    }
    
    public static Pixel get(BufferedImage image,int x, int y) {
        return new Pixel(image.getRGB(x,y),x,y);
    }
    
    public int getAlpha() {
        return (new TColor(color).toIntARGB() & 0xff000000) >> 24;
    }

    public int getBlue() {
        return new TColor(color).toIntARGB() & 0x000000ff;
    }

    public Color getColor() { return color; }
    
    public TColor getTColor() { return new TColor(color); }
    
    public int getGreen() {
        return (new TColor(color).toIntARGB() & 0x0000ff00) >> 8;
    }

    public static List<Pixel> getList(String csv) {
//        System.out.println("Pixel.getList: csv: " + csv);
        List<Pixel> list = new ArrayList<>();
        String s = StringTool.getUnwrapped(csv);
        String remainder = s;
        while (remainder.length() > 0) {
//            System.out.println("Remainder: " + remainder);
            int sepIndex = remainder.indexOf(",",remainder.indexOf("]") + 1);
            if (sepIndex != -1) {
                String pStr = remainder.substring(0,sepIndex);
                list.add(Pixel.get(pStr));
                String remains = remainder.substring(sepIndex+1);
                remainder = remains;
            } else {
                if (remainder.startsWith("[") && remainder.endsWith("]")) {
                    if (StringTool.count(remainder,',') == 2) {
                        list.add(Pixel.get(remainder));
                        remainder = "";
                    }
                } else {
                    System.err.println("Pixel.getList: Some unknown error: remainder: " + remainder);
                    System.exit(0);
                }
            }
        }
        return list;
    }
    
    public int getRed() {
        return (new TColor(color).toIntARGB() & 0x00ff0000) >> 16;
    }
    
    public int getX() { return p.x; }
    
    public int getY() { return p.y; }
    
    public void setColor(Color c) {
        color = c; 
    }
    
    public void setPXY(int x, int y) {
        p.x = x;
        p.y = y;
    }
    
    public void setPXY(Point p) {
        this.p = p;
    }
    
    public String toExternal() {
        return "[" + color.getRGB() + "," + p.x + "," + p.y + "]";
    }
} 
