package ca.tecreations;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.GeneralSecurityException;

import org.bouncycastle.operator.OperatorCreationException;
/**
 * 
 * @author Tim
 */
public class ExceptionHandler { 
    
    public static void handle(String caller, Exception e) {
        handle(caller,"",e,false);
    }
    
    public static void handle(String caller, String msg, Exception e, boolean printStackTrace) {
        if (e instanceof CertificateException) {
            System.err.println(caller + ": " + (msg.equals("") ? "" : msg + " : ") + (CertificateException)e);
        } else if (e instanceof CertificateEncodingException) {
            System.err.println(caller + ": " + (msg.equals("") ? "" : msg + " : ") + (CertificateEncodingException)e);
        } else if (e instanceof FileNotFoundException) {
            System.err.println(caller + ": file not found: " + (msg.equals("") ? "" : msg + " : ") + (FileNotFoundException)e);
        } else if (e instanceof GeneralSecurityException) {
            System.err.println(caller + ": " + (msg.equals("") ? "" : msg + " : ") + (GeneralSecurityException)e);
        } else if (e instanceof IOException) {
            System.err.println(caller + ": io exception: " + (msg.equals("") ? "" : msg + " : ") + (IOException)e);
        } else if (e instanceof KeyStoreException) {
            System.err.println(caller + ": " + (msg.equals("") ? "" : msg + " : ") + (KeyStoreException)e);
        } else if (e instanceof NoSuchAlgorithmException) {
            System.err.println(caller + ": io exception: " + (msg.equals("") ? "" : msg + " : ") + (NoSuchAlgorithmException)e);
        } else if (e instanceof NoSuchProviderException) {
            System.err.println(caller + " : " + (msg.equals("") ? "" : msg + " : ") + (NoSuchProviderException)e);
        } else if (e instanceof OperatorCreationException) {
            System.err.println(caller + " : " + (msg.equals("") ? "" : msg + " : ") + (OperatorCreationException)e);
        }
        if (printStackTrace) e.printStackTrace();
    }

    
    
    public static void handleIO(String caller, String msg, Exception e, boolean printStackTrace) {
        if (e instanceof FileNotFoundException) {
            if (e.getMessage().contains("Access is denied")) {
                System.err.println(caller + " : access denied : " + msg);
                if (printStackTrace) e.printStackTrace();
            } else {
                System.err.println(caller + ": file not found: " + msg);
                if (printStackTrace) e.printStackTrace();
            }
        } else if (e instanceof IOException) {
            System.err.println(caller + ": io exception: " + msg + " : " + (IOException)e);
            if (printStackTrace) e.printStackTrace();
        }
    }
     
}
