package ca.tecreations;

import java.awt.event.*;

import javax.swing.*;
/**
 *
 * @author Tim
 */
public class Click {
    Point locPoint;
    Point eventPoint;
    boolean altDown = false;
    boolean ctrlDown = false;
    boolean shiftDown = false;
    int count;
    boolean isLeft;
    boolean isRight;
    
    private Click() {}
    
    public Click(MouseEvent e) {
        locPoint = new Point(e.getLocationOnScreen());
        eventPoint = new Point(e.getX(),e.getY());
        altDown = e.isAltDown();
        ctrlDown = e.isControlDown();
        shiftDown = e.isShiftDown();
        count = e.getClickCount();
        isLeft = SwingUtilities.isLeftMouseButton(e);
        isRight = SwingUtilities.isRightMouseButton(e);
    }
    
    public Click(Point loc, Point evt, boolean isLeft, boolean isRight, boolean altDown, boolean ctrlDown, boolean shiftDown, int count) {
        this.locPoint = loc;
        this.eventPoint = evt;
        this.isLeft = isLeft;
        this.isRight = isRight;
        this.altDown = altDown;
        this.ctrlDown = ctrlDown;
        this.shiftDown = shiftDown;
        this.count = count;
    }
    
    public static Click fromString(String s) {
        System.out.println("Click.fromString: " + s);
        // for location
        int x = Integer.parseInt(s.substring(s.indexOf("(") + 1,s.indexOf(",")));
        int y = Integer.parseInt(s.substring(s.indexOf(",") + 1,s.indexOf(")")));
        Point locPoint = new Point(x,y); 
        // we can garbage x and y but we use them again
        System.out.println("locPoint: " + locPoint);
        String remainder = s.substring(s.indexOf(":") + 1);
        System.out.println("Remainder: " + remainder);
        
        // for event
        String intPart = remainder.substring(remainder.indexOf("(") + 1,remainder.indexOf(","));
        x = Integer.parseInt(intPart);
        y = Integer.parseInt(remainder.substring(remainder.indexOf(",") + 1,remainder.indexOf(")")));
        Point eventPoint = new Point(x,y);
        remainder = remainder.substring(remainder.indexOf(":") + 1);
        System.out.println("Remainder: " + remainder);
        
        System.out.println("Click.fromString: " + remainder);

        String next = remainder.substring(0,remainder.indexOf(":"));
        System.out.println("Next: '" + next + "'");
        boolean isLeft = next.equals("left");
        System.out.println("isLeft: " + isLeft);
        remainder = remainder.substring(remainder.indexOf(":") + 1);
        
        System.out.println("Click.fromString: " + remainder);
        next = remainder.substring(0,remainder.indexOf(":"));
        boolean isRight = next.equals("right");
        System.out.println("isRight: " + isRight);
        remainder = remainder.substring(remainder.indexOf(":") + 1);
        
        System.out.println("Click.fromString: " + remainder);
        next = remainder.substring(0,remainder.indexOf(":"));
        boolean altDown = next.equals("alt");
        System.out.println("altDown: " + altDown);
        remainder = remainder.substring(remainder.indexOf(":") + 1);
        
        System.out.println("Click.fromString: " + remainder);
        next = remainder.substring(0,remainder.indexOf(":"));
        boolean ctrlDown = next.equals("ctrl");
        System.out.println("ctrlDown: " + ctrlDown);
        remainder = remainder.substring(remainder.indexOf(":") + 1);
        
        System.out.println("Click.fromString: " + remainder);
        next = remainder.substring(0,remainder.indexOf(":"));
        boolean shiftDown = next.equals("shift");
        System.out.println("shiftDown: " + shiftDown);
        remainder = remainder.substring(remainder.indexOf(":") + 1);
        
        System.out.println("Click.fromString: " + remainder);
        int count = Integer.parseInt(remainder.substring(remainder.indexOf(":") + 1));
        return new Click(locPoint,eventPoint,isLeft,isRight,altDown,ctrlDown,shiftDown,count);
    }
    
    public static Click fromWrapped(String s) {
        if (StringTool.isDoubleQuoted(s)) {
            return fromString(StringTool.getUnwrapped(s));
        } else {
            throw new IllegalArgumentException("Click.getFromPackage: Improperly packaged: missing double-quotes: " + s);
        }
    }
    
    public int getButtonsMask() {
        int mask = 0;
        if (isLeft) return InputEvent.BUTTON1_DOWN_MASK;
        if (isRight) return InputEvent.BUTTON3_DOWN_MASK;
        return InputEvent.BUTTON2_DOWN_MASK;
    }
    
    public int getCount() { return count; }
    
    public Point getEventPoint() { return eventPoint; }
    
    public int getEventX() { return eventPoint.x; }
    
    public int getEventY() { return eventPoint.y; }
    
    public Point getLocOnScreen() {
        return locPoint;
    }

    public Point getLocPoint() { return locPoint; }
    
    public int getLocX() { return locPoint.x; }
    
    public int getLocY() { return locPoint.y; }
    
    public String getPackaged() { 
        return StringTool.getDoubleQuoted(toString()); // for a click, I'll use
        // a double quote, for a drag, a pair of clicks, as CSV, backticked
        // #see Drag.java#fromString,getPackaged,getFromPackaged
    }
    
    public boolean isAltDown() { return altDown; }
    
    public boolean isControlDown() { return ctrlDown; }
    
    public boolean isCtrlDown() { return ctrlDown; }
    
    public boolean isLeft() { return isLeft; }
    
    public boolean isMiddle() { return !isLeft && !isRight; }
    
    public boolean isRight() { return isRight; }
    
    public boolean isShiftDown() { return shiftDown; }
    
    
    public static void main(String[] args) {
        System.out.println("Click: " + Click.fromWrapped("\"(1177,54):(1181,21):left:::::1\""));
    }
    public void set(Click click) {
        this.locPoint = click.locPoint;
        this.eventPoint = click.eventPoint;
        this.isLeft = click.isLeft;
        this.isRight = click.isRight;
        this.altDown = click.altDown;
        this.ctrlDown = click.ctrlDown;
        this.shiftDown = click.shiftDown;
        this.count = click.count;
    }
     
    public void setClickCount(int count) {
        this.count = count;
    }
 
    public String toDoubleQuoted() { return StringTool.getDoubleQuoted(toString()); }
    
    public String toString() { 
        String transportString = "(" + locPoint.x + "," + locPoint.y + "):"; 
        transportString += "(" + eventPoint.x + "," + eventPoint.y + "):"; 
        transportString += (isLeft ? "left:" : ":");
        transportString += (isRight ? "right:" : ":");
        transportString += (altDown ? "alt:" : ":");
        transportString += (ctrlDown ? "ctrl:" : ":");
        transportString += (shiftDown ? "shift:" : ":");
        transportString += count;
        return transportString;
    }
}

