package ca.tecreations.misc;
import ca.tecreations.Platform;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.Toolkit;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
/**
 *
 * @author Tim
 */
public class Clipboard {
    public static java.awt.datatransfer.Clipboard instance;
    static {
        instance = Toolkit.getDefaultToolkit().getSystemClipboard();
    }

    public static void copyString(String s) {
        copyString(s,null);
    }
    
    public static void copyString(String s, ClipboardOwner owner) {
        StringSelection selection = new StringSelection(s);
        instance.setContents(selection, owner);    
    }
    
    public static void copyImage(Image i) {
        ImageSelection selection = new ImageSelection(i);
        instance.setContents(selection, null);
    }
   
    public static BufferedImage getImage() {
        Transferable transferable = instance.getContents(null);
        if (transferable != null && transferable.isDataFlavorSupported(DataFlavor.imageFlavor)) {
            try {
                return (BufferedImage) transferable.getTransferData(DataFlavor.imageFlavor);
            } catch (UnsupportedFlavorException ufe) {
                Platform.message(null,"Clipboard: Unsupported flavor: " + ufe);
            } catch (IOException ioe) {
                Platform.message(null,"Clipboard: Unable to retrieve from clipboard: " + ioe);
            }
        }
        return null;
    }

    public static String getString() {
        try {
            return (String) instance.getData(DataFlavor.stringFlavor);
        } catch (UnsupportedFlavorException ufe) {
            Platform.message(null,"Unsupported data flavor: " + ufe);
        } catch (IOException ioe) {
            Platform.message(null,"Unable to retrieve from clipboard: " + ioe);
        }
        return null;
    }
    
}
