package ca.tecreations.components;

import ca.tecreations.Properties;

import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener; 

import javax.swing.JDialog;
import javax.swing.JFrame;

/** 
 * 
 * @author Tim
 */ 
public class TDialog extends JDialog implements ComponentListener, WindowListener {
    private static final long serialVersionUID = -6814973102322448668L;
    protected String name;
    public TFrame frame;
    private Properties properties;
    int oldX = 0;
    int oldY = 0;
    int oldWidth = 0;
    int oldHeight = 0;
    boolean debug = false;
  
    public TDialog(TFrame frame, String name) {
        super(frame,name,true);
        this.frame = frame;
        this.name = name;
        addComponentListener(this);
        addWindowListener(this);
        properties = frame.getProperties();
        if (properties.wasCreated()) {
            doInitialSetup();
        }
        int x = (properties.getInt(name + ".dialog.x") == null) ? 0 : properties.getInt(name + ".dialog.x");
        int y = (properties.getInt(name + ".dialog.y") == null) ? 0 : properties.getInt(name + ".dialog.y");
        int w = (properties.getInt(name + ".dialog.width") == null) ? 0 : properties.getInt(name + ".dialog.width");
        int h = (properties.getInt(name + ".dialog.height") == null) ? 0 : properties.getInt(name + ".dialog.height");
        setLocation(x,y);
        setSize(w,h);
    }  
    
    public void doInitialSetup() {
        int screenWidth = Toolkit.getDefaultToolkit().getScreenSize().width;
        int screenHeight = Toolkit.getDefaultToolkit().getScreenSize().height;
        properties.set(name + ".dialog.x", screenWidth / 2 - 320);
        properties.set(name + ".dialog.y", screenHeight / 2 - 240);
        properties.set(name + ".dialog.width",640);
        properties.set(name + ".dialog.height",480);
        properties.write();
    }
    
    public TFrame getFrame() { return frame; }
    
    public java.awt.Point getStoredLocation() {
        return new java.awt.Point(properties.getInt(name + ".dialog.x"),properties.getInt(name + ".dialog.y"));
    }
    
    public TDialog setExitOnClose() {
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        return this;
    }
    
    public TDialog setDoNothingOnClose() {
        setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
        return this;
    }
    
    public void setSize(int w, int h) {
        properties.read(false);
        properties.set(name + ".dialog.width",w);
        properties.set(name + ".dialog.height",h);
        super.setSize(w,h);
    }

    public void setVisible(boolean state) {
        if (state) {
            Integer width = properties.getInt(name + ".dialog.width");
            Integer height = properties.getInt(name + ".dialog.height");
            if (width == null || height == null) {
                setSize(640,480);
            } else {
                setSize(width,height);
            }
        }
        super.setVisible(state);
    }
    

    public void windowClosing(WindowEvent e) {
        dispose();
    }
    
    public void windowIconified(WindowEvent e) {}
    public void windowDeiconified(WindowEvent e) {}
    public void windowOpened(WindowEvent e) {
    }
    public void windowClosed(WindowEvent e) {}
    public void windowActivated(WindowEvent e) {}
    public void windowDeactivated(WindowEvent e) {}
    
    public void componentShown(ComponentEvent e) {
        
    }
    
    public void componentHidden(ComponentEvent e) {
        
    }
    
    public void componentMoved(ComponentEvent e) {
        if (getLocation().x != oldX || getLocation().y != oldY) {
            properties.set(name + ".dialog.x",getLocation().x);
            properties.set(name + ".dialog.y",getLocation().y);
            properties.write();
        }
        oldX = getLocation().x;
        oldY = getLocation().y;
        // do you need to repaint? IS that something to consider? I'd say No.
    }
    
    public void componentResized(ComponentEvent e) {
        if (getWidth() != oldWidth || getHeight() != oldHeight) {
            properties.set(name + ".dialog.width",getWidth());
            properties.set(name + ".dialog.height",getHeight());
            properties.write();
        }
        // this on the other hand, yes, different, update for next run....
        oldWidth = getWidth();
        oldHeight = getHeight();
    }

    public Properties getProperties() { return properties; }
    
}
