package ca.tecreations.apps.capturetool;

import ca.tecreations.File;
import ca.tecreations.Platform;
import ca.tecreations.ProjectPath;
import ca.tecreations.components.Magnifier;
import ca.tecreations.components.TFrame;

import java.awt.BorderLayout;
import java.awt.image.BufferedImage;
import javax.swing.*;

/**
 *  
 * @author Tim
 */
public class CaptureTool extends TFrame {
    public static CaptureTool instance;
    JScrollPane scroller;
    public CaptureToolDisplay display;
    
    public CaptureTool() {
        super(ProjectPath.getTecreationsPath() + "CaptureTool" + File.separator + 
                          "CaptureTool.properties",CaptureTool.class.getSimpleName());
        instance = this;
        display = new CaptureToolDisplay(this);
        display.captureAndExtract();
        setJMenuBar(new CaptureToolMenuBar(this,display));
        setupGUI();
    } 
    
    public BufferedImage getBoxContents() {
        return display.getBoxContents();
    }
    
    public BufferedImage getCapture() {
        return display.getImage();
    }
    
    public static void launch() {
        instance = new CaptureTool();
        instance.setVisible(true);
    }
    
    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            launch();
        });
        while (instance == null) Platform.sleep(125);
        instance.setExitOnClose(true);
    }
    
    public void setBoxBounds(int x, int y, int width, int height) {
        display.setBoxBounds(x,y,width,height);
    }

    public void setupGUI() {
        scroller = new JScrollPane(display,JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
        scroller.getVerticalScrollBar().setUnitIncrement(16);
        add(scroller,BorderLayout.CENTER);
        addKeyListener(display);
        setJMenuBar(new ca.tecreations.apps.capturetool.CaptureToolMenuBar(this,display));
    }
}
