package ca.tecreations.apps._gui;

import ca.tecreations.FileEntry;
import ca.tecreations.Sort;
import ca.tecreations.net.Client;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.*;
import java.util.List;

import javax.swing.*;
 
/**
 *
 * @author tim
 */
public class DialogSetPOSIXGroup extends JDialog implements ActionListener {
    Client client;
    EntriesPanel panel;
    FileEntry entry;
    JScrollPane scroller;
    JList<String> list = new JList<>();
    JPanel buttons = new JPanel(new GridLayout(1,2));
    JButton cancel = new JButton("Cancel");
    JButton ok = new JButton("OK");
    
    public DialogSetPOSIXGroup(EntriesPanel panel, FileEntry entry) {
        this.client = panel.getClient();
        this.panel = panel;
        this.entry = entry;
        setLayout(new BorderLayout(0,0));
        setTitle("Set Unix Group : " + entry.getDisplayName());
        scroller = new JScrollPane(list,JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED,JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
        add(scroller,BorderLayout.CENTER);
        buttons.add(cancel);
        buttons.add(ok);
        add(buttons,BorderLayout.SOUTH);
        cancel.addActionListener(this);
        ok.addActionListener(this);
        List<String> groupsList = client.getPOSIXGroups();
        groupsList = Sort.sort(groupsList);
        String[] groups = new String[groupsList.size()];
        for(int i = 0; i < groupsList.size();i++) groups[i] = groupsList.get(i);
        list.setListData(groups);
        setSize(240,360);
        setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        setVisible(false);
        if (e.getSource() == cancel) {
        } else if (e.getSource() == ok) {
            if (list.getSelectedIndex() > 0) {
                client.setPOSIXGroup(entry.getAbsolutePath(),list.getSelectedValue());
                panel.updateEntry(panel.getSelectedIndex(),entry);
            }
        }
    }
}
