package ca.tecreations;

import java.io.*;
import java.util.*;
import java.util.jar.*;
/**
 *
 * @author Tim 
 */
public class JarWriter {
    String path;
    JarOutputStream jos = null;
    private Manifest manifest = new Manifest();
    boolean debug = false;
    
    public JarWriter(String path) {
        this.path = StringTool.getUnwrapped(path);
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION,"1.0");
    }
    
    public void addToManifest(String key, String value) {
        manifest.getMainAttributes().put(new Attributes.Name(key),value);
    }
        
    public void addDirectoryEntry(JarOutputStream target, String parentPath,File dir) throws IOException {
        parentPath = StringTool.getUnwrapped(parentPath);
        if (jos == null) openJar();
        String remaining = "";
        if (parentPath.endsWith(File.separator)) 
            remaining = dir.getAbsolutePath().substring(parentPath.length());
        else remaining = dir.getAbsolutePath().substring(parentPath.length() + 1);
        String name = remaining.replace("\\","/");
        if (!name.endsWith("/")) name += "/";
        System.out.println("JarWrite: adding entry: " + name);
        JarEntry entry = new JarEntry(name);
        entry.setTime(dir.lastModified());
        target.putNextEntry(entry);
        target.closeEntry();
    }
     
    public void addFile(String rootPath, File source) {
        String unwrapped = source.getUnwrapped();
        //System.err.println("rootPath: " + rootPath + " source: " + source);
        if (jos == null) openJar();
        BufferedInputStream in = null;
        String remaining = "";
        // if you've gotten a String Index Out OfBoundsException here, your
        // properties file has been corrupted at project.path... Usually due to
        // exceptions while debugging
        remaining = unwrapped.substring(rootPath.length());
        String jarEntry = remaining.replace("\\","/"); // DO FOR IF WINDOWS
        if (!unwrapped.endsWith("MANIFEST.MF")) { // skip MANIFEST.MF
            System.out.println("JarWriter: adding file : " + source.getAbsolutePath());
            JarEntry entry = new JarEntry(jarEntry);
            entry.setTime(source.lastModified());
            try {
                jos.putNextEntry(entry);
            } catch (IOException ioe) {
                System.err.println("JarWriter: Unable to add entry: " + entry);
            }
            // uhh, so somewhere around here, you need to check that the source is just 
            // a subpath + filename.ext, or no extension.
            try {
                in = new BufferedInputStream(new FileInputStream(unwrapped));
            } catch (FileNotFoundException fnfe) {
                System.err.println("JarWriter: File not found: " + source);
            } 
            long total = 0;
            byte[] buffer = new byte[64000];
            try {
                while (true) {
                    int count = in.read(buffer);
                    if (count == -1) break;
                    jos.write(buffer,0,count);
                    total += count;
                    if (debug) System.out.println("Wrote: " + total + " bytes.");
                }
                jos.closeEntry();
            } catch (IOException ioe) {
                System.err.println("JarWrite: IO Exception: " + ioe + " : " + entry);
            } finally {
                try {
                    in.close();
                } catch (IOException ioe) {
                    System.err.println("JarWrite: Unable to close: " + entry);
                }
            }
        } else System.out.println("JarWrite: Skipping: " + source);
    }
    
    public void close() {
        try {
            if (jos != null) jos.close();
        } catch (IOException ioe) {
            System.err.println("Unable to close jar.");
        }
    }
    
    // modified from...
    //https://stackoverflow.com/questions/3047081/why-it-is-impossible-to-delete-entries-from-jar-file
    public static void deleteFromJar(String jarFilename,String filename) throws IOException {
        java.io.File jarFile = new java.io.File(jarFilename);
        java.io.File tempJarFile = new java.io.File(jarFilename + ".tmp");

        // Open the jar file.
        JarFile jar = new JarFile(jarFile);
        System.out.println(jarFilename + " opened.");

        // Initialize a flag that will indicate that the jar was updated.
        boolean jarUpdated = false;
        
        
        // Create a temp jar file with no manifest. (The manifest will
        // be copied when the entries are copied.)
        Manifest jarManifest = jar.getManifest();
        JarOutputStream tempJar = new JarOutputStream(new FileOutputStream(tempJarFile));

        try {
            
            // Allocate a buffer for reading entry data.
            byte[] buffer = new byte[1024];
            int bytesRead;

            // Loop through the jar entries and add them to the temp jar,
            // skipping the entry that was added to the temp jar already.

            for (Enumeration entries = jar.entries(); entries.hasMoreElements();) {
                // Get the next entry.
                JarEntry entry = (JarEntry)entries.nextElement();
                // If the entry has not been added already, add it.

                if (!entry.getName().equals(filename)) {
                    // Get an input stream for the entry.
                    InputStream entryStream = jar.getInputStream(entry);

                    // Read the entry and write it to the temp jar.
                    tempJar.putNextEntry(entry);
                    while ((bytesRead = entryStream.read(buffer)) != -1) {
                        tempJar.write(buffer, 0, bytesRead);
                    }
                }
            }

            jarUpdated = true;
        } catch (Exception ex) {
            System.err.println(ex);

            // This needs to be confirmed as necessary code.
            // Add a stub entry here, so that the jar will close without an
            // exception.
            tempJar.putNextEntry(new JarEntry("stub"));
        } finally {
            tempJar.close();
            jar.close();
            System.out.println(jarFilename + " closed.");

            // If the jar was not updated, delete the temp jar file.

            if (!jarUpdated) {
                tempJarFile.delete();
            }

            // If the jar was updated, delete the original jar file and rename the
            // temp jar file to the original name.

            if (jarUpdated) {
                jarFile.delete();
                tempJarFile.renameTo(jarFile);
                System.out.println(jarFilename + " updated.");
            }
        }
    }
 
    public void openJar() {        
        try {
            jos = new JarOutputStream(new FileOutputStream(path), manifest);
        } catch (IOException ioe) {
            System.out.println("JarWriter.openJar: unable to open jar: " + ioe);
        }
    }    
    
    public void setMainClass(String mainFQCN) {
        if (mainFQCN != null && !mainFQCN.equals(""))  
            manifest.getMainAttributes().put(Attributes.Name.MAIN_CLASS,mainFQCN);
    }
    
}
