package ca.tecreations;

/**
 *
 * @author Tim
 */
public class Clean {

    public Clean(String path) {
        this(path,false);
    } 
    
    public Clean(String path, boolean quiet) {
        doClean(path,quiet);
    } 
    
    public void doClean(String path, boolean quiet) {
        File[] roots = new File(path).tecListFiles();
        String unwrapped;
        String className;
        if (!quiet) System.out.println("Clean: " + path);
        if (roots != null) {
            for(int i = 0; i < roots.length;i++) {
                //System.out.println("Target: " + roots[i]);
                if (roots[i].isFile()) {
                    if (roots[i].getUnwrapped().toLowerCase().endsWith(".class")) {
                        unwrapped = roots[i].getUnwrapped();
                        if (!quiet) System.out.println("Clean: " + unwrapped);
                        className = unwrapped.substring(unwrapped.lastIndexOf(File.separator) + 1,unwrapped.lastIndexOf("."));
                         
                        if (!className.equals("BuildProject") &&
                            !className.equals("BuildProject_Thread") &&
                            !className.equals("Clean") &&
                            !className.equals("Color") &&
                            !className.equals("Data") &&
			    !className.equals("File") &&
                            !className.equals("GetClassPathFor") && 
                            !className.equals("ImageTool") && 
                            !className.equals("ImageTool$1") && 
                            !className.equals("Platform") &&
                            !className.equals("Point") &&
			    !className.equals("Properties") &&
			    !className.equals("ProjectPath") &&
                            !className.equals("Sort") &&
                            !className.equals("StringTool") &&
                            !className.equals("SystemToken") &&
                            !className.equals("SystemTool") &&
                            !className.equals("TextPoints") &&
                            !className.equals("Time") &&
                            !className.equals("TypeToType") &&
                            !className.equals("TFrame")
                        ) { 
                            roots[i].delete();
                            boolean deleted = roots[i].exists();
                            if (!quiet) System.out.println("Deleted: " + roots[i].getUnwrapped() + " : " + deleted);
                        }
                    }
                } else if (roots[i].isDirectory()) {
                    new Clean(roots[i].getUnwrapped(),quiet);
                }
            }
        }
    }
    
    public static void usage() {
        System.out.println("java Clean projectPath");
        System.out.println();
        System.exit(0);
    }
    
    public static void main(String[] args) {
        if (args.length == 1) {
            new Clean(args[0]);
        } else {
            new Clean(ProjectPath.instance.getProjectPath());
        }
    }
}
