package ca.tecreations.apps.filetool;

import ca.tecreations.ImageTool;
import ca.tecreations.Platform;
import ca.tecreations.net.backup.NoTLSConnectionException;
import ca.tecreations.net.backup.TLSClient_TVS12;
/**
 *
 * @author Tim -- just gets the refreshed desktop screenshot image for client.
 */
public class RefreshThread extends Thread {
    RemoteControl remote;
    TLSClient_TVS12 client;

    public RefreshThread(RemoteControl remote, TLSClient_TVS12 client) {
        this.remote = remote;
        this.client = client;
        start();
    }
    
    public void run() {
        System.err.println("RefreshThread: refreshing...");
        TLSClient_TVS12 newClient = null;
        try {
            newClient = new TLSClient_TVS12(client.getProperties(),
                                            client.getPassword(),
                                            remote.getDebug()
            );
        } catch (NoTLSConnectionException ntlsce) {
            System.err.println("No TLS Connection: " + ntlsce.getPropertiesFilename());
        }
            
        newClient.getScreenshot(newClient.getClientScreenshotPath());
        Platform.sleep(500);
        remote.setImage(ImageTool.getImage(newClient.getClientScreenshotPath()));
    }
}
