package ca.tecreations;

import ca.tecreations.TColor;

import java.awt.Color;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
 
/**
 *  
 * @author Tim de Vries
 */ 
public class Properties extends java.util.Properties {
    java.util.Properties parent;
    private final Object lock = new Object();
    boolean debug = false;
    boolean debugWrite = false;
    boolean verbose = false;
    String absPath;
    boolean delayWrite = false;
    List<String> keys = new ArrayList<>();  
    List<String> values = new ArrayList<>();
    boolean created = false;
    boolean output = true;
    boolean autoCreate = true;

    // -------------------------------------------------------------------------
    // For Instantiation
    // -------------------------------------------------------------------------
    
    public Properties(File file) {
        this(file,false,true);
    }
    
    public Properties(String absPath) {
        this(new File(absPath),false,true);
    }
    
    public Properties(List<String> lines, boolean output) {
        parent = (java.util.Properties)this;
        this.output = output;
        for(int i = 0;i < lines.size();i++) {
            parse(lines.get(i));
        }
    }
    
    
    //--------------------------------------------------------------------------
    // Convenience entry points.
    //--------------------------------------------------------------------------
    public Properties(File file,boolean output,boolean autoCreate) {
        parent = (java.util.Properties)this;
        absPath = file.getAbsolutePath(); // remember? Double quoted
        this.output = output;
        this.autoCreate = autoCreate;
        read(output);
    }
    
    // END CONSTRUCTORS, DESTRUCTORS -------------------------------------------
    //========================for-machine-use===================================
    // -- tim's use ->[{(...)}]<- End.// /* tim */ /** tim debug 3 */ // test 8...
    //========================END machine use.===================================
    
    public void checkDebugPrint() {
        if (debug) {
            System.out.println("--------------------------------------------");
            print();
            System.out.println("--------------------------------------------");
        }
    }

    public void clearCreated() {
        created = false;
    }

    public void decrement(String key, int amount) {
        int val;
        String sVal = (String) get(key);
        if (sVal == null) {
            val = 0;
        } else {
            val = Integer.parseInt(sVal);
        }
        val -= amount;
        set(key, val);
    }

    public boolean deleteByKey(String key) {
        int index = getKeyIndex(key);
        if (index >= 0) {
            keys.remove(index);
            values.remove(index);
            write();
            return true;
        }
        return false;
    }

    public boolean deleteByValue(String value) {
        int index = getValueIndex(value);
        if (index >= 0) {
            keys.remove(index);
            values.remove(index);
            write();
            return true;
        }
        return false;
    }

    /**
     *
     * @param key
     * @return value or null if not found.
     */
    public String get(String key) {
        for (int i = 0; i < keys.size(); i++) {
            if (keys.get(i).equals(key)) {
                return values.get(i);
            }
        }
        return null;
    }

    public String get(int key) {
        for (int i = 0; i < keys.size(); i++) {
            if (keys.get(i).equals("" + key)) {
                return values.get(i);
            }
        }
        return null;
    }

    public String getAbsPath() { return absPath; }
    
    public Boolean getBoolean(String key) {
        String value = get(key);
        if (value != null) {
            if (value.toUpperCase().equals("TRUE")) return true;
            if (value.toUpperCase().equals("FALSE")) return false;
        }
        return null; // either unset or not a boolean
    }

    public Boolean getBooleanOrFalse(String key) {
        String value = get(key);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return false;
    }

    public Boolean getBooleanOrTrue(String key) {
        String value = get(key);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return true;
    }

    public Color getColor(String key) {
        String value = get(key);
        if (value == null) return null;
        int rStart = value.indexOf("[") + 1;
        int rStop = value.indexOf(",");
        int gStart = rStop + 1;
        int gStop = value.indexOf(',',gStart + 1);
        int bStart = gStop + 1;
        int bStop = value.indexOf(",",bStart + 1);
        int aStart = bStop + 1;
        int aStop = value.length() - 1;
        int r = Integer.parseInt(value.substring(rStart,rStop));
        int g = Integer.parseInt(value.substring(gStart,gStop));
        int b = Integer.parseInt(value.substring(bStart,bStop));
        int a = Integer.parseInt(value.substring(aStart,aStop));
        return new Color(r,g,b,a);
    }
    
    public List<String> getCSV(String key) {
        String val = get(key);
        StringBuffer buf = new StringBuffer();
        List<String> result = new ArrayList<>();
        char ch;
        boolean insideQuotes = false;
        for(int i = 0; i < val.length();i++) {
            ch = val.charAt(i);
            if (ch == '\"' && !insideQuotes) {          // start working
                insideQuotes = true;                  
            } else if (insideQuotes && ch != '\"') {    // add until unquoted
                buf.append(ch);                       
            } else if (insideQuotes && ch == '\"') {    //unquoted add the buf to list
                result.add(buf.toString());                              
                buf = new StringBuffer();
                insideQuotes = false;
            } else if (ch == ',' && !insideQuotes) {    // skip commas inside quotes
                // do nothing, just skip over
            }
        }
        return result;
    }
    
    public double getDouble(String key) {
        String value = get(key);
        return Double.parseDouble(value);
    }

    public String getFilename() {
        return absPath;
    }

    public Integer getInt(String key) {
        String sVal = (String) get(key);
        // handle null
        if (sVal == null) {
            return null;
        }
        // return stored, write when setting
        return Integer.valueOf(sVal);
    }

    public int getIntOrZero(String key) {
        String sVal = (String) get(key);
        if (sVal == null) {
            return 0;
        }
        return Integer.parseInt(sVal);
    }

    public String getKey(int index) {
        return keys.get(index);
    }

    public List<String> getKeys() {
        return keys;
    }

    /**
     *
     * @param key the 'key'
     * @return the 0 based index or -1 if not found
     */
    public int getKeyIndex(String key) {
        for (int i = 0; i < keys.size(); i++) {
            if (keys.get(i).equals(key)) {
                return i;
            }
        }
        return -1;
    }

    public List<String> getList(String key) {
        String value = get(key);
        if (value == null || value.equals("")) {
            return new ArrayList<String>();
        }
        return StringTool.explode(value, ',');
    }

    public List<Point> getListOfPoint(String entry) {
        List<Point> points = new ArrayList<>();
        StringBuffer buf = new StringBuffer();
        char ch;
        String xStr;
        String yStr;
        for (int i = 0; i < entry.length(); i++) {
            ch = entry.charAt(i);
            if (ch == ';') {
                xStr = entry.substring(0, buf.toString().indexOf(','));
                yStr = entry.substring(buf.toString().indexOf(',') + 1);
                points.add(getListOfPoint_getPoint(buf.toString()));
                buf = new StringBuffer();
            } else {
                buf.append(ch);
            }
        }
        return points;
    }

    private Point getListOfPoint_getPoint(String entry) {
        String xStr = entry.substring(0, entry.indexOf(','));
        String yStr = entry.substring(entry.indexOf(',') + 1);
        return new Point(Integer.parseInt(xStr), Integer.parseInt(yStr));
    }

    public Long getLong(String key) {
        String value = get(key);
        if (value != null) {
            return Long.valueOf(value);
        } else {
            return null;
        }
    }
    
    public int getNativeIntOr0(String key) {
        Integer i = getInt(key);
        if (i == null) {
            return 0;
        } else {
            return (int) i;
        }
    }

    public List<String> getOutputList(boolean includeSystem) {
        List<String> output = new ArrayList<>();
        if (includeSystem) {
            String key;
            Enumeration javaKeys = System.getProperties().keys();
            while (javaKeys.hasMoreElements()) {
                key = (String)javaKeys.nextElement();
                if (key.equals("line.separator")) {
                    String val = System.getProperty(key);
                    if (val.equals("\n")) {
                        val = "\\n";
                    } else if (val.equals("\r\n")) {
                        val = "\\r\\n";
                    } else {
                        val = StringTool.replaceAll(val,'\n',"\\n");
                        val = StringTool.replaceAll(val,'\r',"\\r");
                    }
                    output.add(key + ": " + val);
                } else {
                    output.add(key + ": " + System.getProperty(key));
                }
            }
        }

        for (int i = 0; i < keys.size(); i++) {
            output.add(keys.get(i) + ": " + values.get(i));
        }
        return Sort.sort(output);
    }
    
    public Point getPoint(String key) {
        String value = get(key);
        if (value != null && value.contains(",")) {
            String x = value.substring(0,value.indexOf(","));
            String y = value.substring(value.indexOf(",") + 1);
            return new Point(x,y);
        } else {
            return null;
        }
    }
    
    public String getPrintOutput() {
        String s = "";
        for (int i = 0; i < keys.size(); i++) {
            s += i + ": Key: " + keys.get(i) + ": Value: " + values.get(i);
        }
        return s;
    }
    
    @Override
    public String getProperty(String key) {
        return super.getProperty(key);
    }
    
    @Override
    public String getProperty(String key,String defaultValue) {
        return super.getProperty(key,defaultValue);
    }

    public List<String> getSorted(boolean includeSystem) {
        List<String> data = Sort.getSorted(getOutputList(includeSystem));
        return data;
    }
    
    public java.util.Properties getSystem() {
        return parent;
    }
    
    public TColor getTColor(String key) {
        return new TColor(getColor(key));
    }

    public String getValue(int index) {
        return values.get(index);
    }

    public List<String> getValues() {
        return values;
    }

    /**
     *
     * @param index
     * @return the 0 based index or -1 if not found
     * @analysis does what it's told, huh. it!
     */
    public int getValueIndex(String value) {
        for (int i = 0; i < values.size(); i++) {
            if (values.get(i).equals(value)) {
                return i;
            }
        }
        return -1;
    }

    public boolean hasKey(String name) {
        return getKeys().contains(name);
    }
    
    public boolean hasValue(String value) {
        return getValues().contains(value);
    }
    
    public void increment(String key, int amount) {
        int val;
        String sVal = (String) get(key);
        if (sVal == null) {
            val = 0;
        } else {
            val = Integer.parseInt(sVal);
        }
//        System.out.println("Data.storage.increment: " + val);
        val += amount;
//        System.out.println("Data.storage.increment: " + val);
        set(key, val);
    }

    public void incrementLongString(Object src, String key) {
        set(key, StringTool.incrementLongString(get(key)));
    }

    public Boolean isStandalone() {
        return getBoolean("standalone");
    }
    
    public static void main(String[] args) {
        Properties props = new Properties(new File("\"C:\\Users\\tim\\Documents\\tecreations\\properties\\JavaLauncher_Apps.properties\""),true,true);
        System.out.println("Props: exists: " + new File(props.getFilename()));
        props.print();
    }

    public void parse(String line) {
        // the key must start at the beginning of the line and be delimited by a colon.
        String key = "";
        if (line.contains(": ")) {
            key = line.substring(0, line.indexOf(": "));
        }
        // remove any whitespace
        try {
            String value = line.substring(line.indexOf(": ") + 2).trim();
            if (debug) {
                System.out.println("Parse: '" + line + "' : key: '" + key + "' : value: '" + value + "'");
            }
            for (int i = 0; i < keys.size(); i++) {
                if (keys.get(i).equals(key)) {
                    values.set(i, value);
                    return;
                }
            }
            keys.add(key);
            values.add(value); 
        } catch (StringIndexOutOfBoundsException sioobe) {
            keys.add(key);
            values.add("");
        }
    }
 
    public void print() {
        for (int i = 0; i < keys.size(); i++) {
            System.out.println(i + ": Key: " + keys.get(i) + ": Value: " + values.get(i));
        }
    }

    public synchronized void read(boolean output) {
        if (debug) System.out.println("Reading properties file: '" + absPath + "'");
        File parent = new File(absPath).getDeepestDirectoryFile();
        
        if (!parent.exists()) {
            System.out.print("Creating parent directory: " + parent + " : " + parent.mkdirs() + " : Parent: " + parent.getAppPermissionsString());
            System.out.println();
        }
        if (!new File(absPath).exists()) {
            if (autoCreate) write();
            created = true;
        }
        if (new File(absPath).exists()) {
            synchronized (lock) {
                LineNumberReader reader = null;
                try {                              // here it might be wrapped, so unwrap the path
                    reader = new LineNumberReader(new FileReader(StringTool.getUnwrapped(absPath)));
                    //System.out.println("Reading: " + absPath);
                    try {
                        boolean done = false;
                        String line = "";
                        while (line != null) {
                            // so not a comment 
                            if (!line.startsWith("#")) {
                                // do we need to include comments?
                                if (!line.trim().equals("")) {
                                    // not an empty line, parse it
                                    parse(line);
                                }
                            }
                            line = reader.readLine();
                        }
                        reader.close();
                    } catch (IOException ioe) {
                        System.out.println("IO Exception: reading: " + absPath);
                    }
                } catch (FileNotFoundException fnfe) {
                    System.err.println("Properties: read: Unable to read file: " + absPath);
                }
            }
        }
    }
    
    public void reload() {
        keys = new ArrayList<>();
        values = new ArrayList<>();
        read(false);
    }
    
    public void reset() {
        keys = new ArrayList<>();
        values = new ArrayList<>();
        write();
    }

    public void reverse() {
        List<String> keys2 = new ArrayList<>();
        List<String> vals2 = new ArrayList<>();
        for (int i = keys.size() - 1; i >= 0; i--) {
            keys2.add(keys.get(i));
            vals2.add(values.get(i));
        }
        keys = keys2;
        values = vals2;
    }

    
    
    public void set(String key, String value) {
        set(key,value,true);
    }
        
    public void set(String key, String value, boolean write) {
        if (value == null) {
            value = "null";
        }
        int index = 0;
        boolean found = false;
        for (int i = 0; i < keys.size(); i++) {
            if (debug && verbose) {
                System.out.println("Checking[" + i + "/" + keys.size() + "]  : key: " + key + " value: " + value + " keys[i]: " + keys.get(i) + " values[i]: " + values.get(i));
            }
            if (keys.get(i).equals(key)) {
                index = i;
                found = true;     // and we found it
                break;
            }
        }
        if (debug) {
            System.out.println("delayWrite: " + delayWrite);
        }
        if (found) {
            values.set(index, value);
            super.put(key,value);
        } else {
            // add it
            keys.add(key);
            values.add(value);
            super.put(key,value);
            sortByKeys();
        }
        if (write) write();
    }
    
    public void set(String key, boolean val) {
        set(key, String.valueOf(val).toUpperCase());
    }

    public void set(String key, char val) {
        set(key, String.valueOf(val));
    }

    public void set(String key, byte val) {
        set(key, String.valueOf(val));
    }

    public void set(String key, int val) {
        set(key, String.valueOf(val));
    }

    public void set(String key, short val) {
        set(key, String.valueOf(val));
    }

    public void set(String key, long val) {
        set(key, String.valueOf(val));
    }

    public void set(String key, float val) {
        set(key, String.valueOf(val));
    }

    public void set(String key, double val) {
        set(key, String.valueOf(val));
    }

    public void set(String key, Color c) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        int a = c.getAlpha();
        set(key,"Color[" + r + "," + g + "," + b + "," + a + "]");
    }
    

    public void set(String key, Enumeration<String> enumeration) {
        String val = "";
        while (enumeration.hasMoreElements()) {
            val += enumeration.nextElement();
            if (enumeration.hasMoreElements()) {
                val += ",";
            }
        }
        set(key, val);
    }
    
    public void set(String key, List<String> list) {
        String value = "";
        if (!list.isEmpty()) {
            for (int i = 0; i < list.size() - 1; i++) {
                value += list.get(i) + ",";
            }
            value += list.get(list.size() - 1);
        }
        set(key, value);
    }

    public void setEnumeration(String key, Enumeration<String> enumeration) {
        String val = "";
        while (enumeration.hasMoreElements()) {
            val += enumeration.nextElement();
            if (enumeration.hasMoreElements()) {
                val += ",";
            }
        }
        set(key, val);
    }

    public void set(String key, char[] chars) {
        StringBuffer value = new StringBuffer();
        for (int i = 0; i < chars.length; i++) {
            value.append(chars[i]);
        }
        set(key, value.toString());
    }

    public void setColors(String key, List<Color> colors) {
        String s = "";
        for (int i = 0; i < colors.size() - 1; i++) {
            s += colors.get(i) + "; ";
        }
        s += colors.get(colors.size() - 1);
        set(key, s);
    }

    public void set(String key, Point p) {
        set(key, p.toString());
    }

    public void setCreated(boolean flag) {
        created = flag;
    }

    public void setCSV(String key, List<String> vals) {
        String csv = "";
        String val;
        for(int i = 0; i < vals.size();i++) {
            val = vals.get(i);
            if (!val.startsWith("\"") && !val.endsWith("\"")) {
                csv += "\"" + val + "\"";
            } else {
                csv += val;
            }
            if (i < vals.size() - 1) csv += ",";
        }
        set(key,csv);
    }
    
    public void setDebug(boolean f) {
        debug = f;
    }

    /**
     * @param flag
     *
     * Sets or clears the delay write flag to postpone write()'s when setting.
     * Call storage.write() when done.
     */
    public void setDelayWrite(boolean flag) {
        delayWrite = flag;
    }

    public void setDelayWrite() {
        delayWrite = true;
    }

    public void setFilename(String absPath) {
        this.absPath = absPath;
        reload();
    }
    
    public void setListOfPoint(String key, List<Point> points) {
        String s = "";
        if (points.size() > 0) {
            for (int i = 0; i < points.size() - 1; i++) {
                s += points.get(i) + "; ";
            }
            s += points.get(points.size() - 1);
            set(key, s);
        }
    }

    public void setListOfPoint(String key, List<Point> points, boolean write) {
        String s = "";
        if (points.size() > 0) {
            for (int i = 0; i < points.size() - 1; i++) {
                s += points.get(i) + "; ";
            }
            s += points.get(points.size() - 1);
        }
        set(key, s,false);
    }

    public void sortByKeys() {
        // x becomes --> names, so values gets placed there also, watch
        int j;
        boolean flag = true;  // will determine when the sort is finished
        String tempName, tempValue;
        while (flag) {
            flag = false;
            for (j = 0; j < keys.size() - 1; j++) {
                if (keys.get(j).compareToIgnoreCase(keys.get(j + 1)) > 0) {
                    // ascending sort
                    tempName = keys.get(j);
                    tempValue = values.get(j);
                    keys.set(j, keys.get(j + 1));
                    values.set(j, values.get(j + 1));     // swapping
                    keys.set(j + 1, tempName);
                    values.set(j + 1, tempValue);
                    flag = true;
                }
            }
        }
    }

    public String toString() {
        String s = "Properties: " + getFilename() + "\n";
        for (int i = 0; i < keys.size(); i++) {
            s += "Key: " + keys.get(i) + "  Value: " + values.get(i) + "\n";
        }
        return s;
    }

    public boolean wasCreated() {
        return created;
    }

    /**
     * Writes the keys & values to the data store and clears the delayWrite
     * flag, if set.
     */
    public void write() {
        synchronized (lock) {
            PrintWriter out = null;
            try {
                out = new PrintWriter(StringTool.getUnwrapped(absPath));
                for (int i = 0; i < keys.size(); i++) {
                    out.println(keys.get(i) + ": " + values.get(i));
                }
                out.flush();
                out.close();
                delayWrite = false; // written, clear delayWrite
                if (debugWrite) {
                    System.out.println("Properties: Wrote: " + absPath);
                }
            } catch (IOException ioe) {
                System.out.println("Unable to create/open: " + absPath);
            }
        }
    }
}
