package ca.tecreations;

import ca.tecreations.net.Client;
import ca.tecreations.time.Time;

import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author tim
 */
public class FileEntry {
    Client client;
    File file;
    String absPath;
    String name;
    long sizeLong = -1L;
    String sizeString;
    boolean canRead = false;
    boolean canWrite = false;
    boolean canExecute = false;
    String lastModified;

    // get the platform specific information
    String dosAttrs = "";
    String owner = "";
    String group = "";
    String filePerms = "";

    boolean selected = false;

    boolean isNix = false;
    String fileSeparator;
    char fileSeparatorChar;
    String pathSeparator;
    char pathSeparatorChar;
    
    boolean isDir = false;

    boolean hasJava = false;
    boolean isJar = false;
    boolean isJava = false;
    List<String> lines = new ArrayList<>();
    boolean hasMatchingClass = false;
    boolean hasMain = false;
    String pkg = null;
    String pkgPathPart = null;
    String projectPath = null;

    
    
    public static boolean debug = false;
    
    public FileEntry(String entry) {
        List<String> parts = StringTool.explode(entry,",");
        absPath = parts.get(0);
        _setPlatformData(absPath);
        file = new File(absPath);
        if (debug) System.out.println("FileEntry(0): AbsPath: " + absPath);
        sizeString = parts.get(1);
        if (!sizeString.equals("GET") && !sizeString.equals("")) {
            try {
                sizeLong = Long.parseLong(sizeString);
            } catch (NumberFormatException nfe) {
                System.err.println("FileEntry(0): Invalid sizeString: " + sizeString);
            }
        } else if (sizeString.equals("GET")) {
            isDir = true;
            sizeLong = File.getDirSize(absPath);
            sizeString = sizeLong + "";
        }
        String appPerms = parts.get(2);
        canRead = appPerms.contains("R");
        canWrite = appPerms.contains("W");
        canExecute = appPerms.contains("X");
        lastModified = parts.get(3);
        String attr = parts.get(4);
        String unwrapped = StringTool.getUnwrapped(absPath);
        _setPlatformData(absPath);
        if (isNix) {
            if (!attr.equals("")) {
                owner = attr.substring(0, attr.indexOf("."));
                group = attr.substring(attr.indexOf(".", 1) + 1, attr.lastIndexOf("."));
                filePerms = attr.substring(attr.lastIndexOf(".") + 1);
            }
        }
        if (client != null) {
            isDir = client.isDir(absPath);
        }
        if (isDir) {
            hasJava = client.hasJava(absPath);
            if (hasJava) {
                pkgPathPart = getPackagePathPart(absPath);
            }
            if (debug) System.err.println("FileEntry(1): absPath: " + absPath + " pkgPathPart: " + pkgPathPart);
        }
        if (file.is("jar")) {
            isJar = true;
        }
        if (file.is("java")) {
            isJava = true;
            hasMatchingClass = client.hasMatchingClass(absPath);
            doJavaComputations();
        }
    }

    public FileEntry(Client client, String absPath) {
        this(client,absPath,"","","","");
        file = new File(absPath);
        //System.err.println("FileEntry(): absPath: " + file.getAbsolutePath());
        this.absPath = absPath;
        _setPlatformData(absPath);
        if (client != null) {
            isDir = client.isDir(absPath);
        }
        if (isDir) {
            hasJava = client.hasJava(absPath);
            if (hasJava) {
                pkgPathPart = getPackagePathPart(absPath);
            }
            if (debug) System.err.println("FileEntry(1): absPath: " + absPath + " pkgPathPart: " + pkgPathPart);
        }
        if (file.is("jar")) {
            isJar = true;
        }
        if (file.is("java")) {
            isJava = true;
            hasMatchingClass = client.hasMatchingClass(absPath);
            doJavaComputations();
        }
    }
      
    public FileEntry(Client client, String absPath, String sizeString, String appPerms, String lastModified, String attributesString) {
        file = new File(absPath);
        this.client = client;
        this.absPath = absPath;
        _setPlatformData(absPath);
        if (debug) System.out.println("FileEntry(2): AbsPath: " + absPath);
        this.sizeString = sizeString;
        if (!sizeString.equals("GET") && !sizeString.equals("")) {
            try {
                sizeLong = Long.parseLong(sizeString);
            } catch (NumberFormatException nfe) {
                System.err.println("FileEntry(): Invalid sizeString: " + sizeString);
            }
        } 
        canRead = appPerms.contains("R");
        canWrite = appPerms.contains("W");
        canExecute = appPerms.contains("X");
        this.lastModified = lastModified;
        String attr = attributesString;
        String unwrapped = StringTool.getUnwrapped(absPath);
        if (isNix) {
            if (!attr.equals("")) {
                owner = attr.substring(0, attr.indexOf(","));
                group = attr.substring(attr.indexOf(",") + 1, attr.lastIndexOf(","));
                filePerms = attr.substring(attr.lastIndexOf(",") + 1);
            }
        } else {
            dosAttrs = attr;
        }
        if (!TecData.isDir(absPath)) {
            if (file.is("jar")) {
                isJar = true;
            }
            if (file.is("java")) {
                isJava = true;
                hasMatchingClass = client.hasMatchingClass(absPath);
                doJavaComputations();
            }
        }
    }

    public void _setPlatformData(String absPath) {
        isNix = absPath.contains("/");
        if (isNix) {
            fileSeparator = "/";
            fileSeparatorChar = '/';
            pathSeparator = ":";
            pathSeparatorChar = ':';
        } else {
            fileSeparator = "\\";
            fileSeparatorChar = '\\';
            pathSeparator = ";";
            pathSeparatorChar = ';';
        }
    }
    
    public boolean canRead() { 
        return canRead; 
    }
    
    public boolean canWrite() { 
        return canWrite;
    }
    
    public boolean canExecute() { 
        return canExecute; 
    }

    private Boolean computeMatchingClass() {
        //was: File aClassFile = new File(file.getDeepestDirectory().getUnwrapped() + file.getFileNameOnly() + ".class");
        File aClassFile = null;
        if (file.isDirectory()) {
            return null;
        } else {
            aClassFile = new File(file.getUnwrapped() + file.getFileNameOnly() + ".class");
        }
        
        if (client.exists(aClassFile.getAbsolutePath())) {
            return true;
        }
        return false;
    }
    
    public void deselect() {
        selected = false;
    }
    
    public void doJavaComputations() {
        hasMatchingClass = hasMatchingClass();
        lines = new ArrayList<>();
        lines = client.getFileLines(absPath);
        String line;
        if (lines.get(0).equals(TecData.TEC_NULL)) {
            System.err.println("Unexpected: Empty .java File: " + absPath);
        }
        for (int i = 0; i < lines.size(); i++) {
            line = lines.get(i).trim();
            if (pkg == null && line.startsWith("package")) {
                pkg = line.substring("package".length(), line.indexOf(";")).trim();
            } else if (!hasMain && line.startsWith("public static void main(")) {
                hasMain = true;
            }
        } 
        // determine package
        String fileUnwrapped = file.getUnwrapped();
        if (pkg == null) {
            pkg = pkgPathPart = "";
            projectPath = fileUnwrapped.substring(0, fileUnwrapped.indexOf(file.getName()));
        } else {
            pkgPathPart = pkg;
            // for these, the pkg + "." makes the object like a path, but we
            // replace for File separators and use the client's file separator
            if (pkgPathPart.contains(".")) {
                // we have to add the "." to pkg to make it like a path element
                pkgPathPart = StringTool.replaceAll(pkg + ".", ".", client.getFileSeparator());
            } else {
                // -- just a single pkg, no sub-packages 
                pkgPathPart += client.getFileSeparator(); // conform to path
            }
            // now we get the root of the package, or the classPath
            if (fileUnwrapped.contains(pkgPathPart)) {
                projectPath = fileUnwrapped.substring(0, fileUnwrapped.indexOf(pkgPathPart));
            } else {
                // the specified path segment does not exist in filename,
                // user programmer error
                projectPath = file.getDeepestDirectoryFile().getAbsolutePath();
            }
        }
        projectPath = StringTool.getDoubleQuoted(projectPath);
        //System.err.println("Name: " + name + " Package: " + pkg + " hasMatchingClass: " + hasMatchingClass + " hasMain: " + hasMain + " pp: " + projectPath + " pkgPathPart: " + pkgPathPart);
    }
    
    public String getAbsPath() { return file.getAbsolutePath(); }
    public String getAbsolutePath() { return file.getAbsolutePath(); }

    public String getAllButExtension() {
        String unwrapped = getUnwrapped();
        return unwrapped.substring(0,unwrapped.lastIndexOf("."));
    }
    
    public String getAppPermissions() {
        String val = (canRead ? "R" : "-");
        val += (canWrite ? "W" : "-");
        val += (canExecute ? "X" : "-");
        return val;
    }

    public String getDisplayName() {
        String unwrapped = file.getUnwrapped();
        String last = StringTool.getLastCharacter(unwrapped);
        boolean isDir = (last.equals("/") | last.equals("\\")) ? true : false;
        String val;
        if (isDir) {
            val = file.getDeepestDirectoryFile().getFilenameOnly();
        } else {
            String ext = file.getExtension();
            if (ext.length() > 0) {
                val = file.getName();
            } else {
                val = file.getFilenameOnly();
            }
        }
        return val;
    }
    
    public String getDOSAttributes() { return dosAttrs; }
    
    public String getExtension() {
        return file.getExtension();
    }
    
    public File getFile() { return file; }
    
    public String getFileSeparator() { return fileSeparator; }
    
    public char getFileSeparatorChar() { return fileSeparatorChar; }
    
    public String getLastModified() { return Time.longToYMD_HMS(lastModified); }
    
    public String getName() { return file.getName(); }
    
    public String getPackage() { return pkg; }
    
    public String getPackagePathPart() { return pkgPathPart; }
    
    public String getPackagePathPart(String root) {
        // get the first java FileEntry
        FileEntry javaFE = getFirstJavaFileEntry(root);
        if (javaFE != null) {
            
        }
        
        return pkgPathPart;
    }
    
    public FileEntry getFirstJavaFileEntry(String root) {
        List<File> entries = new File(root).tecGetListFiles();
        if (entries != null) {
            for(int i = 0; i < entries.size();i++) {
                if (entries.get(i).getExtension().equals("java")) {
                    return new FileEntry(client,entries.get(i).getAbsolutePath());
                } else if (entries.get(i).isDirectory()) {
                    return getFirstJavaFileEntry(entries.get(i).getAbsolutePath());
                }
            }
        }
        return null;
    }
    
    public String getPart(int col) {
        if (col == 0) return getDisplayName();
        else if (col == 1) return sizeLong + ""; 
        else if (col == 2) return getAppPermissions();
        else if (col == 3) return getLastModified();
        else if (col == 4) {
            if (absPath.contains("/")) return getPOSIXOwner();
            else return getDOSAttributes();
        } else if (col == 5) return getPOSIXGroup();
        else return getPOSIXFilePermissions();
    }
    
    public String getPathSeparator() { return pathSeparator; }
    
    public char getPathSeparatorChar() { return pathSeparatorChar; }
    
    public String getPkgPathPart() { return pkgPathPart; }
    
    public String getPOSIXDetails() {
        return getPOSIXOwner() + "," + getPOSIXGroup() + "," + getPOSIXFilePermissions();
    }
    
    public String getPOSIXFilePermissions() { return filePerms; }
    
    public String getPOSIXGroup() { return group; }
    
    public String getPOSIXOwner() { return owner; }
    
    public String getProjectPath() { return projectPath; }
    
    public boolean getSelected() { return selected; }
    
    public long getSizeLong() { return sizeLong; }
    
    public String getSizeString() { return sizeString; }
    
    public String getToExtension() { return file.getUnwrapped().substring(0,file.getUnwrapped().lastIndexOf(".")); }
    
    public String getUnwrapped() { return file.getUnwrapped(); }
    
    public boolean has(String extension) {
        return new File(getToExtension() + "." + extension).exists();
    }
    
    public boolean hasFileDotClass() {
        return has("class");
    }
    
    public boolean hasFileDotJava() {
        return file.is("java");
    }
    
    public boolean hasJava_Recurse(String absPath) {
        File[] entries = new File(absPath).tecListFiles();
        if (entries != null) {
            for(int i = 0;i < entries.length;i++) {
                if (entries[i].isDirectory()) {
                    return hasJava_Recurse(absPath);
                } else if (entries[i].is("java") || entries[i].is("class")) {
                    return true;
                }
            }
        }
        return false;
    }
    
    public boolean hasMain() { return hasMain; }
    
    public boolean hasMatchingClass() { return hasMatchingClass; }
    
    public boolean isClassFile() { 
        return file.getExtension().equals("class");
    }
    
    public boolean isDirectory() {
        String unwrapped = file.getUnwrapped();
        if (unwrapped.endsWith("\\") || unwrapped.endsWith("/")) return true;
        return false;
    }
    
    public boolean isFile() {
        return !isDirectory();
    }
    
    public boolean isJar() { return file.is("jar"); }
    
    public boolean isJava() { return file.is("java"); }
    
    public boolean isNix() { return isNix; }
    
    public boolean isSelected() { return selected; }
    
    public boolean isSet(int columnIndex) {
        if (columnIndex < 2 | columnIndex > 4) throw new IllegalArgumentException("FileEntry.isSet(): Out Of Range: 2-4. : Submitted: " + columnIndex);
        if (columnIndex == 2) return canRead();
        if (columnIndex == 3) return canWrite();
        else return canExecute();
    }
    
    public boolean isText() { 
        String ext = file.getExtension();
        if (ext.equals("c")) return true;
        if (ext.equals("cpp")) return true;
        if (ext.equals("html")) return true;
        if (ext.equals("java")) return true;
        if (ext.equals("php")) return true;
        if (ext.equals("pl")) return true;
        if (ext.equals("properties")) return true;
        if (ext.equals("py")) return true;
        if (ext.equals("sh")) return true;
        if (ext.equals("txt")) return true;
        if (ext.equals("txt")) return true;
        if (ext.equals("xml")) return true;
        return false;
    }
    
    public boolean isWin() { return Platform.isWin(); }
    
    public static void main(String[] args) {

    }
    
    public void printSourceLines() {
        for(int i = 0; i < lines.size();i++) {
            System.out.println(lines.get(i));
        }
    }
    
    public void runJava(String args) {
        SystemTool st = new SystemTool();
        String unwrapped = file.getUnwrapped();
        String classPath = unwrapped.substring(0,unwrapped.indexOf(pkgPathPart));
        if (client == null) {
            TecData.st.spawnJava(classPath,pkg + "." + file.getFileNameOnly(),args,debug);
        } else {
            client.execSpawnJava(classPath,pkg + "." + file.getFileNameOnly(),args);
        }
    }
    
    public void setDOSAttributes(String attributes) {
        dosAttrs = attributes;
    }
    
    public void setExecutable(boolean f) { 
        canExecute = f;
    }
    
    public void setExecutable(String s) { 
        if (s.equals("1") | s.toLowerCase().equals("true")) {
            canExecute = true;
        } else {
            canExecute = false;
        }
    }
    
    public void setLastModified(long lastModified) {
        this.lastModified = "" + lastModified;
    }
    
    public void setLastModified(String lastModified) {
        this.lastModified = lastModified;
    }
    
    public void setName(String name) { this.name = name; }
    
    public void setPOSIXOwner(String owner) {
        this.owner = owner;
    }
    
    public void setPOSIXGroup(String group) {
        this.group = group;
    }
    
    public void setPOSIXFilePermissions(String permissions) {
        filePerms = permissions;
    }
    
    public void setReadable(boolean f) { 
        canRead = f;
    }

    public void setReadable(String s) { 
        if (s.equals("1") | s.toLowerCase().equals("true")) {
            canRead = true;
        } else {
            canRead = false;
        }
    }
    
    public void setSelected(boolean f) { selected = f; }
    
    public void setSizeLong(long sizeLong) {
        this.sizeLong = sizeLong;
        this.sizeString = sizeLong + "";
    }
    
    public void setSizeString(String sizeString) {
        this.sizeString = sizeString;
        this.sizeLong = Long.parseLong(sizeString);
    }
    
    public void setWritable(boolean f) { 
        canWrite = f;
    }
    
    public void setWritable(String s) { 
        if (s.equals("1") | s.toLowerCase().equals("true")) {
            canWrite = true;
        } else {
            canWrite = false;
        }
    }

    public String toString() {
        String output = "";
        output += absPath + ",";
        output += sizeLong + ",";
        output += (canRead ? "R" : "-");
        output += (canWrite ? "W" : "-");
        output += (canExecute ? "X" : "-");
        output += ",";
        output += Time.longToYMD_T_HMS(Long.toString(file.lastModified())) + ",";
        if (isNix) {
            output += getPOSIXDetails();
        } else {
            output += getDOSAttributes();
        }
        if (isJava) {
            output += " Java[ class:" + hasMatchingClass + " main: " + hasMain + "]";
        }
        return output;
    }
}
