package ca.tecreations.net.tsp;

import java.net.*;
import java.io.*;

public class TecStreamPrinterServer implements Runnable {
    ServerSocket serverSocket;
    BufferedReader in = null;
    boolean running = false;
    
    public TecStreamPrinterServer() {
        try {
            serverSocket = new ServerSocket(TecStreamPrinterData.port);
            running = true;
            newListener();
            System.out.println("Started TSPS on port: " + TecStreamPrinterData.port);
        } catch (IOException ioe) {
            System.out.println("TSPS: opening port: " + TecStreamPrinterData.port + " : " + ioe);
        }
    }
    
    public void exit() {
        System.exit(0);
    }
    
    public static void launch() {
        new TecStreamPrinterServer();
    }
    
    public static void main(String[] args) {
        new TecStreamPrinterServer();
    }

    public void newListener() {
        new Thread(this).start();
    } 
    
    @Override
    public void run() {
        Socket clientSocket = null;
        if (serverSocket != null) {
            try {
                clientSocket = serverSocket.accept();
                in = new BufferedReader(new InputStreamReader(clientSocket.getInputStream()));
                newListener();
            } catch (IOException ioe) {
                System.err.println("Unable to accept connection: " + ioe);
            }
        } else {
            System.out.println("Server socket is null in call to TSPS.run()");
        }
        String inputLine;
        while (running) {
            try {
                inputLine = in.readLine();
                if (inputLine != null) {
                    // will start with either "OUT: txt" or "ERR: txt"
                    if (inputLine.length() >= 5) {
                        String type = inputLine.substring(0,5); 
                        String text = inputLine.substring(5);
                        //System.out.println("inputLine: '" + inputLine + "'");
                        //System.out.println("type     : '" + type + "'");
                        //System.out.println("text     : '" + text + "'");
                        if (type.equals("ERR: ")) System.err.println(text);
                        else System.out.println(text);
                    } 
                }
            } catch (IOException ioe) {
            }
        } 
    }
    
    public void stopRunning() {
        running = false;
    }
}