package ca.tecreations.net.tsp;

import ca.tecreations.Platform;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

import javax.net.ssl.SSLSocket;

/** 
 *
 * @author Tim
 */ 
public class TLS_TSPS_Thread extends Thread {
    SSLSocket socket = null;
 
    PrintWriter out = null;

    boolean running = true;

    List<String> toSend = new ArrayList<>();
    
    TLS_TSPS tsps;
    
    public TLS_TSPS_Thread(TLS_TSPS tsps, SSLSocket socket) {
        this.tsps = tsps;
        try {
            out = new PrintWriter(socket.getOutputStream(),true);
            System.out.println("Client: " + socket.getInetAddress() + " out: " + out);
        } catch (IOException ioe) {
            System.err.println("Unable to connect: " + ioe);
        }
        start();
    }

    public synchronized void err(String s) {
        toSend.add("ERR: " + s);
    }

    public synchronized void out(String s) {
        toSend.add("OUT: " + s);
    }

    public void run() {
        List<String> preamble = tsps.getPreamble();
        for(int i = 0; i < preamble.size();i++) {
            out.println(preamble.get(i));
        }
        while (running) {
            Platform.sleep(1000);
            for(int i = 0; i < toSend.size();i++) {
                out.println(toSend.get(i));
            }
            toSend = new ArrayList<>();
        }
    }

    public void stopRunning() {
        running = false; 
    }
    
    public synchronized void send() {
        toSend.add("");
    } 

    public synchronized void send(String s) {
        toSend.add(s);
    }

}
