package ca.tecreations.net.tsp;

import ca.tecreations.ExceptionHandler;
import ca.tecreations.Platform;
import ca.tecreations.Properties;
import ca.tecreations.net.Internet;
import ca.tecreations.net.PKIData;
import ca.tecreations.net.bc.SecurityTool;

import java.io.IOException;
import java.io.PrintWriter;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;

import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;

/** 
 *
 * @author Tim
 */ 
public class TLS_TSPS implements Runnable {
    public static final String SN = TLS_TSPS.class.getSimpleName();
    public TLS_TSPS instance;
    public Properties properties;
    static SSLServerSocket serverSocket = null;

    public static int port;
    KeyStore keyStore = null;
    char[] keyStorePass;
    KeyStore trustStore = null;

    PrintWriter out = null;
    boolean running = true;
 
    boolean debug = false;
    
    List<TLS_TSPS_Thread> threads = new ArrayList<>();
    List<String> preamble;
    
    SSLContext sslContext;
    KeyManagerFactory keyMgrFact;
    SSLServerSocketFactory fact;
    
    public TLS_TSPS(Properties properties) {
        this(properties,new ArrayList<>());
    }
    
    public TLS_TSPS(Properties properties,List<String> preamble) {
        instance = this;
        this.properties = properties;
        this.preamble = preamble;
        port = properties.getInt(PKIData.REMOTE_PORT) + 1;
        
        String ksPass = properties.get(PKIData.REMOTE_KEYSTORE_PASSWORD);
        if (ksPass != null) {
            if (ksPass.toLowerCase().equals("prompt")) {
                keyStorePass = Platform.requestPassword(null,"Enter " + SN + " keystore password...");
            } else {
                keyStorePass = ksPass.toCharArray();
            }
        } else {
            keyStorePass = Platform.requestPassword(null,"Enter " + SN + " keystore password...");
        }
        try {
            keyStore = SecurityTool.openKeyStore(SecurityTool.JKS, properties.get(PKIData.REMOTE_KEYSTORE), keyStorePass);
            sslContext = SSLContext.getInstance(SecurityTool.TLS, SecurityTool.BCJSSE);
            keyMgrFact = KeyManagerFactory.getInstance(SecurityTool.PKIX, SecurityTool.BCJSSE);
            keyMgrFact.init(keyStore, keyStorePass);
            for(int i = 0;i < keyStorePass.length;i++) keyStorePass[i] = '\0';
            sslContext.init(keyMgrFact.getKeyManagers(), null, null);
            fact = sslContext.getServerSocketFactory();
        } catch (Exception e) {
            ExceptionHandler.handle(TLS_TSPS.class.getSimpleName(), e);
            System.out.println(SN + "(): No Keystore: " + properties.get(PKIData.REMOTE_KEYSTORE));
            System.out.println(SN + "(): properties: " + properties.getFilename());
            System.out.println(SN + "(): Exiting.");
            System.exit(0);
        }
        trustStore = SecurityTool.openTrustStore(SecurityTool.JKS, properties.get(PKIData.REMOTE_TRUSTSTORE));
        if (keyStore == null || trustStore == null) {
            System.out.println(SN + "(): Unable to open keyStore or trustStore. Cannot continue.");
            System.out.println(SN + "(): Verify setup and re-run: " + properties.getFilename());
            System.exit(0);
        }
    }
    
    public synchronized void err(String s) {
        for(int i = 0; i < threads.size();i++) {
            threads.get(i).err(s);
        }
    }

    
    public boolean getDebug() {
        return debug;
    }

    public String getLanIP() {
        return Internet.getLanIP();
    } 
    
    public List<String> getPreamble() { return preamble; }
    
    public String getWanIP() {
        return Internet.getWanIP();
    }
    
/*
public static void launch() {
        Properties properties = new Properties(ProjectPath.getTecPropsPath() + "NetworkConfig" + File.separator + "TLS_TSPS.properties");
        new TLS_TSPS(properties);
    }
    
    public static void main(String[] args) {
        Properties properties = new Properties(ProjectPath.getTecPropsPath() + "NetworkConfig" + File.separator + "TLS_TSPS.properties");
        new TLS_TSPS(properties);
    }
*/
    public void openServerSocket() {
        if (serverSocket == null) {
            try {
                serverSocket = (SSLServerSocket) fact.createServerSocket(port);
            } catch (Exception e) {
                if (e instanceof java.net.BindException) {
                } else {
                    ExceptionHandler.handle(SN + ".openServerSocket", e);
                    System.exit(0);
                }
            }
        } else {
            System.out.println("==========> " + SN + ".openServerSocket: already constructed.");
        }
    } 

    public synchronized void out(String s) {
        for(int i = 0; i < threads.size();i++) {
            threads.get(i).out(s);
        }
    }

    public void run() {
        if (serverSocket == null) {
            openServerSocket();
            if (serverSocket == null) return;
        }
        while (running) {
            try {
                threads.add(new TLS_TSPS_Thread(this,(SSLSocket)serverSocket.accept()));
            } catch (IOException ioe) {
                System.err.println("Unable to accept connection: " + ioe);
            }
        }
    }

    public synchronized void send() {
        for(int i = 0; i < threads.size();i++) {
            threads.get(i).send("");
        }
    } 

    public synchronized void send(String s) {
        for(int i = 0; i < threads.size();i++) {
            threads.get(i).send(s);
        }
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }
    
    public void setPort(int port) {
        this.port = port;
    } 
    
    public void start() {
        openServerSocket();
        while (serverSocket == null) {
            Platform.sleep(125);
        }
        new Thread(this).start();
        System.out.println("Started " + SN + " on port: " + port);
    }

    public void stopRunning() {
        running = false; 
    }
    
    public void write(String msg) {
        for(int i = 0; i < threads.size();i++) {
            threads.get(i).send(msg);
        }
    }
    
    public void writeErr(String msg) {
        for(int i = 0; i < threads.size();i++) {
            threads.get(i).send(msg); // as you can see, I don't post into it. You could. You could the pattern.
            ////////stumMDGrannyLou. / // or you could. /*
            /*
                     no, I wouldn't '
                    */
    }}
    
}
