package ca.tecreations.lang.java;

import ca.tecreations.File;
import ca.tecreations.JarReader;
import ca.tecreations.Pair;
import ca.tecreations.ProjectPath;
import ca.tecreations.StringTool;

import java.util.List;
/**
 *
 * @author Tim

* Usage:
 * 
 *    String new GetClassPathFor( absPath | jarPath ).getResult();
 * 
 *      DOES NOT PROVIDE "-cp"
 * 
 */
public class GetClassPathFor {
    String absPath;
    boolean useTecPath = false;
    String result = "";
    String delimiter;
    boolean debug = false;
     
    public GetClassPathFor(String absPath) {
        this.absPath = absPath;
        delimiter = (absPath.contains("/") ? ":" : ";");
        if (debug) {
            System.err.println("GetClassPathFor(" + absPath + ")");
        }
        if (new File(absPath).getExtension().equals("jar")) {
            doForJar(absPath);
        } else {
            doForClassPath(absPath);
        }
    }
     
    public void doForClassPath(String absPath) {
        if (debug) System.out.println("GetClassPathFor.doForClassPath(" + absPath + ")");
        String unwrapped = StringTool.getUnwrapped(absPath);
        if (!unwrapped.endsWith(File.separator)) unwrapped += File.separator;
        if (!new File(unwrapped).isDirectory()) {
            throw new IllegalArgumentException("GetClassPathFor: Not a directory: " + absPath);
        } 
        if (!new File(unwrapped).exists()) { 
            throw new IllegalArgumentException("GetClassPathFor: Non-existent directory: " + absPath);
        }
        result += unwrapped + delimiter; 
        //System.out.println("Unwrapped: " + unwrapped);
        //System.out.println("Jars: exists: " + new File(unwrapped + "jars").exists());
        if (new File(unwrapped + "jars").exists()) {
            result += getJarsDirs(new File(unwrapped + "jars"));
        } else if (new File(unwrapped + "libs").exists()) {
            result += getLibsDirs(new File(unwrapped + "libs"));
        }
        if (!result.contains(File.separator + ProjectPath.instance.getProjectDir() + File.separator)) {
            result += ProjectPath.instance.getTecSourceJarPath() + delimiter;
        }
    }  
    
    public void doForJar(String absPath) {
        if (debug) System.out.println("GetClassPathFor.doForJar(" + absPath + ")");
        File jarFile = new File(absPath);
        JarReader reader = new JarReader(jarFile.getAbsolutePath());
        if (!jarFile.exists()) {
            throw new IllegalArgumentException("GetClassPathFor: Non-existent file: " + jarFile.getAbsolutePath());
        }
        String outPath = reader.getTecreationsUnpackPath();
        result = "";
        if (!jarFile.getUnwrapped().equals(ProjectPath.instance.getSourceJarPath())) {
            result += ProjectPath.instance.getSourceJarPath() + delimiter; // add my jar
        } 
        result += jarFile.getUnwrapped() + delimiter;           // add the target
        // get unwrapped to pass to java command line
        
        // now add all the jars [of the jar, so tecreations, maven, gradle, or something/someone else]
        result += getJarsDirs(new File(outPath));
        if (!result.contains(ProjectPath.instance.getTecSourceJarPath())) {
            result += delimiter + ProjectPath.instance.getTecSourceJarPath();
        }

    }
    
    public String getJarsDirs(File dir) {
        List<File> dirs = new Pair(dir).getDirs();
        String result = "";
        result += dir.getUnwrapped() + "*" + delimiter; // add this dir, note this is for a java.io.File
                                                        // and we are adding to the pathSpec, so 
                                                        // we must unwrap first
        if (debug) System.out.println("Result: " + result);

        for(int i = 0; i < dirs.size();i++) {
            result += getJarsDirs(dirs.get(i));
            if (debug) System.out.println("Result: " + result);
        }
        return result; // and return as String for platform
    }

    public String getLibsDirs(File dir) {
        List<File> dirs = new Pair(dir).getDirs();
        String result = "";
        result += dir.getUnwrapped() + "*" + delimiter; // add this dir, note this is for a java.io.File
                                                        // and we are adding to the pathSpec, so 
                                                        // we must unwrap first
        if (debug) System.out.println("Result: " + result);

        for(int i = 0; i < dirs.size();i++) {
            result += getLibsDirs(dirs.get(i));
            if (debug) System.out.println("Result: " + result);
        }
        return result; // and return as String for platform
    }

    public String getResult() { return result; }
    
    public static void main(String[] args) {
        //GetClassPathFor getter = new GetClassPathFor("F:\\projects\\DependencyViewer");
        //System.out.println(getter.getResult());
        GetClassPathFor getter2 = new GetClassPathFor("C:\\Users\\Tim\\Downloads\\tec8.jar");
        System.out.println(getter2.getResult());
    }
    
}
