package ca.tecreations.components;

import ca.tecreations.Platform;
import ca.tecreations.components.event.*;

import java.util.*;
/**
 *
 * @author tim
 */
public class ProgressDialogTestThread extends Thread {
    List<ProgressListener> listeners = new ArrayList<>();
    boolean running = false;
    
    public ProgressDialogTestThread() {
    }
    
    public void addListener(ProgressListener pl) {
        if (!listeners.contains(pl)) {
            listeners.add(pl);
        }
        System.out.println("Listeners.size: " + listeners.size());
    }
    
    public void updateProgress(int percent) {
        for(int i = 0; i < listeners.size();i++) {
            listeners.get(i).updateItem(percent);
        }
    }

    public boolean isRunning() { return running; }
    
    public void run() {
        for(int i = 0; i <= 100; i++) {
            System.out.println("PDTT: Running(" + i + "): " + running);
            updateProgress(i);
            Platform.sleep(50);
        }
        running = false;
        System.out.println("Running: " + running);
    }
    
    public void start() {
        running = true;
        super.start();
    }
    
}
