package ca.tecreations.apps._gui.renderer;

import ca.tecreations.TColor;
import ca.tecreations.FileEntry;

import java.awt.Component;

import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.table.TableCellRenderer;

/**
 *
 * @author tim
 */
public class ModifiableTextRenderer extends JLabel implements TableCellRenderer {

    public ModifiableTextRenderer() {
        setHorizontalAlignment(SwingConstants.LEFT);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected,
            boolean hasFocus, int row, int column) {
        FileEntry entry = (FileEntry) value;
        if (entry != null) {
            if (entry.isSelected()) {
                setOpaque(true);
                setBackground(TColor.TEC_SELECTED);
            } else {
                setOpaque(false);
                setBackground(table.getBackground());
            }
            super.setForeground(TColor.TEC_PURPLE);
            if (column == 4) {
                setText(entry.getPOSIXOwner());
            } else if (column == 5) {
                setText(entry.getPOSIXGroup());
            }
        }
        return this;
    } 
}
