package ca.tecreations.apps._data;

import ca.tecreations.*;
import ca.tecreations.apps._gui.*;
import ca.tecreations.net.Client;
import ca.tecreations.net.NoTLSConnectionException;

import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

/**
 *
 * @author tim
 */
public class SizeGetter_Dir extends Thread {
    public static List<SizeGetter_Dir> actives = new ArrayList<>();
    public static final String SN = SizeGetter_Dir.class.getSimpleName();
    EntriesPanel entriesPanel;
    int index;
    FileEntry entry;
    Client client;
    boolean post = true;
    
    public SizeGetter_Dir(EntriesPanel entriesPanel, int index, FileEntry entry, Client client) {
        try {
            this.client = new Client(client);
        } catch (NoTLSConnectionException ntlsce) {
            ExceptionHandler.handle(SN + "()","reinstantiating", ntlsce,true);
        }
        this.entriesPanel = entriesPanel;
        this.index = index;
        this.entry = entry;
    } 
 
    public void run() {
        String sizeString = "-1L";
        try {
            sizeString = client.getDirSize(entry.getAbsolutePath());
            if (post) {
                entry.setSizeString(sizeString);
                SwingUtilities.invokeLater(() -> {
                    entriesPanel.updateEntry(index, entry);
                    entriesPanel.repaint();
                });
            }
        } catch (Exception e) {
            System.err.println(SN + ".run: exception: " + e);
        } catch (Error err) {
            System.err.println(SN + ".run: error: " + err);
        }
    }

    public void start() {
        actives.add(this);
        super.start();
    }
    
    public static void stopAll() {
        for(int i = 0; i < actives.size();i++) {
            actives.get(i).setPost(false);
        } 
        actives = new ArrayList<>();
    }
    
    public void setPost(boolean flag) {
        post = flag;
    }
}