package ca.tecreations;

// https://www.baeldung.com/java-lock-files#:~:text=File%20Locks%20in%20Java,method%20that%20returns%20a%20FileChannel.
// https://www.tutorialspoint.com/java_nio/java_nio_filelock.htm

import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.StandardOpenOption;

/**
 *
 * @author tim
 */
public class LockFile {
    String path;
    FileChannel channel = null;
    FileLock lock = null;
    FileOutputStream fos = null;
    DataOutputStream out = null;
    boolean locked = false;
    
    public LockFile(String path) {
        this.path = path;
    }
    
    public FileChannel getChannel() { return channel; }
    
    public FileLock getFileLock() { return lock; }

    public String getPath() { return path; }
     
    public boolean isLocked() { return locked; }
     
    public void lock() {
        if (!locked) {
            try {
                channel = FileChannel.open(new File(path).toPath(), StandardOpenOption.WRITE,StandardOpenOption.APPEND);  
                lock = channel.tryLock();
                if (lock != null) {
                    fos = new FileOutputStream(StringTool.getUnwrapped(path));
                    out = new DataOutputStream(fos); 
                    locked = true;
                }
            } catch (IOException ioe) {
                System.err.println("LockFile.lock: Unable to process block to open output stream to create lock.");
            }
        }
    }
 
    public static void main(String[] args) {
    }
    
    public void unlock() {
        try {
            if (fos != null) {
                fos.close();
                fos = null;
            }
            if (out != null) { 
                out.close(); 
                out = null; 
            }
            if (lock != null) { 
                lock.release(); 
                lock.close(); 
                lock = null; 
            }
            if (channel != null) { 
                channel.close(); 
                channel = null; 
            }
            locked = false;
        } catch (IOException ioe) {
            System.err.println("LockFile.unlock: Unable to release lock: " + path);
        }
    }
} 
