package ca.tecreations.net;

import ca.tecreations.ExceptionHandler;
import ca.tecreations.Pair;
import ca.tecreations.StringTool;
import ca.tecreations.SystemToken;
import ca.tecreations.TecData;
import ca.tecreations.TypeToType;
import static ca.tecreations.net.Server.doLogAction;
import java.io.*;
import java.net.Socket;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author tim
 */
class ClientHandler implements Runnable {
    public static final String SN = ClientHandler.class.getSimpleName();
    private Socket clientSocket;

    OutputStream out;
    InputStream in;

    BufferedReader inBR = null;
    InputStreamReader inISR = null;
    PrintWriter outPW = null;
    
    public ClientHandler(Socket socket) {
        this.clientSocket = socket;
        textOpen(SN + "()");
    }
    
    public void binaryCloseIn() {
        try { in.close(); } catch (IOException ioe) { System.err.println(SN + ".binaryCloseIn: " + ioe); }
    }

    public void binaryCloseOut() {
        try { out.close(); } catch (IOException ioe) { System.err.println(SN + ".binaryCloseOut: " + ioe); }
    }
    
    public void binaryOpenIn(String caller) {
        try {
            in = clientSocket.getInputStream();
        } catch (IOException ioe) {
            ExceptionHandler.handleIO(SN + ".binaryOpenIn(" + caller + ")","opening in",ioe,false);
        }
    }
    
    public void binaryOpenOut(String caller) {
        try {
            out = clientSocket.getOutputStream();
        } catch (IOException ioe) {
            ExceptionHandler.handleIO(SN + ".binaryOpenOut(" + caller + ")","opening out",ioe,false);
        }
    }
    
    public String getDirSize(String path) {
        return TNData.GET_DIR_SIZE + " " + StringTool.getDoubleQuoted(path) + " " + new ca.tecreations.File(path).getSize();
    }

    public List<String> getDirSizes(String path) {
        List<String> results = new ArrayList<>();
        List<ca.tecreations.File> dirs = new Pair(path).getDirs();
        for(int i = 0;i < dirs.size();i++) {
            String response = getDirSize(dirs.get(i).getAbsolutePath());
            results.add(TNData.GET_DIR_SIZES + " " + dirs.get(i).getAbsolutePath() + " " + response.substring(response.lastIndexOf(" ") + 1));
        }
        return results;
    }

    public List<String> listDirs(String path) {
        List<ca.tecreations.File> dirs = new Pair(path).getDirs();
        List<String> result = new ArrayList<>();
        for(int i = 0; i < dirs.size();i++) {
            result.add(dirs.get(i).getAbsolutePath());
        }
        return result;
    }
    
    public void process(String line) {
        String op;
        String args = "";
        if (line.contains(" ")) {
            op = line.substring(0,line.indexOf(" "));
            args = line.substring(line.indexOf(" ") + 1);
        } else {
            op = line;
        }
        
        String src = null;
        String dst = null;
        String remainder = "";
        if (StringTool.hasFile(args)) {
            String[] srcArray = StringTool.getFileAndTrimmedRemainder(args);
            src = srcArray[0];
            remainder = srcArray[1];
            if (StringTool.hasFile(remainder)) {
                String[] dstArray = StringTool.getFileAndTrimmedRemainder(remainder);
                dst = dstArray[0];
                remainder = dstArray[1];
            }
        } else {
            remainder = args;
        }
        //System.out.println(SN + ".process: src      : " + src);
        //System.out.println(SN + ".process: dst      : " + dst);
        //System.out.println(SN + ".process: args     : " + args);
        //System.out.println(SN + ".process: remainder: " + remainder);
        if (op.equals(TNData.EXEC_FOR_OUTPUT)) {
            List<SystemToken> tokens = TecData.st.runForOutput(args, true);
            List<String> lines = TypeToType.toListString(tokens);
            replyBulk(lines);
        } else if (op.equals(TNData.EXEC_FOR_OUTPUT_JAVA)) {
            List<SystemToken> tokens = TecData.st.runForOutput(args, true);
            List<String> systemTokensList = new ArrayList<>();
            for(int i = 0; i < tokens.size();i++) {
                systemTokensList.add(tokens.get(i).getRawWithType());
            }
            replyBulk(systemTokensList);
        } else if (op.equals(TNData.GET)) {
            reply(TNData.OK);
            getFile(src);
        } else if (op.equals(TNData.GET_DIR_SIZE)) {
            reply(getDirSize(args));
        } else if (op.equals(TNData.GET_DIR_SIZES)) {
            replyBulk(getDirSizes(args));
        } else if (op.equals(TNData.GET_FILE_SIZE)) {
            reply(op + " " + args + " " + new ca.tecreations.File(src).length());
        } else if (op.equals(TNData.LIST_DIRS)) {
            replyBulk(listDirs(args));
        } else if (op.equals(TNData.PUT)) {
            reply(TNData.OK);
            putFile(src,Long.parseLong(remainder));
        } else if (op.equals(TNData.SHUTDOWN)) {
            reply("EXITING");
            System.exit(0);
        } else {
            System.err.println("Unknown command: " + line);
        }
    }
    
    public void reply(String line) {
        outPW.println(line);
        outPW.println("\0");
    }
    
    public void replyBulk(List<String> lines) {
        for(int i = 0; i < lines.size();i++) {
            outPW.println(lines.get(i));
        }
        outPW.println("\0");
    }
    

    @Override
    public void run() {
        try (
            BufferedReader in = new BufferedReader(new InputStreamReader(clientSocket.getInputStream()));
            PrintWriter out = new PrintWriter(clientSocket.getOutputStream(), true);
        ) {
            String inputLine;
            while ((inputLine = in.readLine()) != null) {
                System.out.println("Received from client " + clientSocket.getInetAddress() + ": " + inputLine);
                //out.println("Server received: " + inputLine); // Echo back
                process(inputLine);

            }
        } catch (IOException e) {
            System.err.println("Error handling client " + clientSocket.getInetAddress() + ": " + e.getMessage());
        } finally {
            try {
                clientSocket.close();
                System.out.println("Client disconnected: " + clientSocket.getInetAddress());
            } catch (IOException e) {
                System.err.println("Error closing client socket: " + e.getMessage());
            }
        }
    }

    public void textClose() {
        outPW.close();
        try { inBR.close(); } catch (IOException ioe) {
            ExceptionHandler.handleIO(SN + ".textClose","closing inBR",ioe,false);
        }
        try { inISR.close(); } catch (IOException ioe) {
            ExceptionHandler.handleIO(SN + ".textClose","closing inISR",ioe,false);
        }
    }
    
    
    public void textOpen(String caller) {
        try {
            inISR = new InputStreamReader(clientSocket.getInputStream());
        } catch (IOException ioe) {
            ExceptionHandler.handleIO(SN + ".textOpen(" + caller + ")","opening inISR",ioe,false);
        }
        inBR = new BufferedReader(inISR);
        try {
            outPW = new PrintWriter(clientSocket.getOutputStream(),true);
        } catch (IOException ioe) {
            ExceptionHandler.handleIO(SN + ".textOpen(" + caller + ")","opening outPW",ioe,false);
        }
    }

    //--------------------------------------------------------------------------
    public void getFile(String src) {
        binaryOpenOut("getFile");
        long total = 0;
        int bytesRead;
        byte buffer[] = new byte[TNData.SIXTY_GEES];
        ca.tecreations.File srcFile = new ca.tecreations.File(src);
        FileInputStream fis = new ca.tecreations.File(src).getFileInputStream();
        if (fis != null) {
            try {
                boolean done = false;
                while (!done) {
                    bytesRead = fis.read(buffer, 0, buffer.length);
                    if (bytesRead == -1) {
                        done = true;
                    } else {
                        out.write(buffer, 0, bytesRead);
                        out.flush();
                        total += bytesRead;
                    }
                    if (total == srcFile.length()) done = true;
                    doLogAction(SN + ".getFile: bytesRead: " + bytesRead + " Total: " + total);
                }
                //out.close(); // from signed-SSLServer
            } catch (IOException ioe) {
                System.err.println(SN + ".getFile: reading and writing: " + ioe);
            } finally {
                try {
                    fis.close();
                    //socket.close(); // from signed-SSLServer
                } catch (IOException ioe) {
                    ExceptionHandler.handleIO(SN + ".getFile", "closing input", ioe, false);
                }
            }
        } else {
            System.err.println(SN + ".getFile: failure: fis: " + fis);
        }
        textOpen("getFile");
        reply(TNData.OK);
    }

    public void putFile(String dst,long length) {
        binaryOpenIn("putFile");
        ca.tecreations.File deepest = new ca.tecreations.File(dst).getDeepestDirectoryFile();
        deepest.mkdirs();
        OutputStream os = null;
        try {
            os = Files.newOutputStream(new ca.tecreations.File(dst).toPath());
        } catch (IOException ioe) {
            System.err.println(SN + ".putFile: opening output: " + ioe);
        }
        if (os != null) {
            long total = 0;
            byte[] buffer = null;
            if ((int) length < 60000) {
                buffer = new byte[(int) length];
            } else {
                buffer = new byte[TNData.SIXTY_GEES];
            }
            int bytesRead = 0;
            try {
                boolean done = false;
                while (!done) {
                    bytesRead = in.read(buffer);
                    if (bytesRead == -1) {
                        done = true;
                    } else {
                        os.write(buffer, 0, bytesRead);
                        os.flush();
                        total += bytesRead;
                    }
                    if (total == length) {
                        done = true;
                    }
                    doLogAction(SN + ".putFile: bytesRead: " + bytesRead + " Total: " + total);
                }
            } catch (IOException ioe) {
                ExceptionHandler.handleIO(SN + ".putFile", "copying", ioe, false);
            }
            doLogAction(SN + ".putFile: bytesRead: " + bytesRead + " Total: " + total);
        }
        textOpen("putFile");
        reply(TNData.OK);
    }
    
}