package ca.tecreations.net;

import ca.tecreations.*;
import ca.tecreations.apps._data.*;
import ca.tecreations.components.event.ProgressListener;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.UnrecoverableKeyException;

import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;

/**
 *
 * @author tim
 */
public class Client extends Thread {

    public static final String ENCRYPTED = "encrypted";
    public static final String UN_ENCRYPTED = "un-encrypted";
    public static final String SN = Client.class.getSimpleName();
    BufferedReader stdIn = new BufferedReader(new InputStreamReader(System.in));

    public Client instance;
    Properties properties;

    String host = "localhost";
    int port = 52820;

    boolean encrypt = false;
    Socket rawSocket;
    Socket tlsSocket;

    OutputStream out = null; // these two should be used for reading/writing binary
    InputStream in = null;

    PrintWriter outPW = null; // this should be for writing text to the server (op + args)

    BufferedReader inBR = null; // these should be for reading text from the server
    InputStreamReader inISR = null;

    KeyStore keyStore;
    char[] keyStorePass;
    KeyStore trustStore;

    //public static boolean timedOut = false;
    SSLContext sslContext;
    KeyManagerFactory keyMgrFact;
    TrustManagerFactory trustMgrFact;
    SSLSocketFactory fact;

    public boolean trace = false;
    public boolean debug = false;
    public boolean verbose = false;

    List<ProgressListener> progressListeners = new ArrayList<>();

    public String fileSeparator = null;
    public String pathSeparator = null;
    public String serverOS = null;
    public Boolean isWin = null;

    public boolean running = true;

    MyMap map = new MyMap();
    String lastOp;

    public TextFile log = null;

    public Client(Client c) throws NoTLSConnectionException {
        this.properties = c.getClientProperties();
        if (properties.wasCreated()) {
            return;
        }
        this.host = properties.get(PKIData.REMOTE_HOST);
        this.encrypt = c.getCommsType().equals(ENCRYPTED);
        keyStorePass = properties.get(PKIData.REMOTE_KEYSTORE_PASSWORD).toCharArray(); // note this makes a String!
        openSocket();
        textOpen(SN + "(1)");
    }

    public Client(Properties properties, boolean encrypt, char[] ksp)
            throws NoTLSConnectionException {
        this.properties = properties;
        if (properties.wasCreated()) {
            doInitialSetup(properties);
            System.out.println("Properties file created in: " + properties.getFilename());
            System.out.println("Configure properties and re-run.");
            System.exit(0);
        }
        this.host = properties.get(PKIData.REMOTE_HOST);
        this.encrypt = encrypt;
        keyStorePass = ksp;
        openSocket();
        textOpen(SN + "(2)");
    }

    public void binaryCloseIn() {
        try {
            in.close();
        } catch (IOException ioe) {
            ExceptionHandler.handleIO(SN + ".binaryCloseIn", "closing input", ioe, false);
        }
    }

    public void binaryCloseOut() {
        try {
            out.close();
        } catch (IOException ioe) {
            ExceptionHandler.handleIO(SN + ".binaryCloseOut", "closing output", ioe, false);
        }
    }

    public void binaryOpenIn(String caller) {
        try {
            in = getSocket().getInputStream();
        } catch (IOException e) {
            ExceptionHandler.handle(SN + ".binaryOpenIn(" + caller + ")", "opening input", e, false);
        }
    }

    public void binaryOpenOut(String caller) {
        try {
            out = getSocket().getOutputStream();
        } catch (IOException e) {
            ExceptionHandler.handle(SN + ".binaryOpenOut", "opening output", e, false);
        }
    }

    private static final void doInitialSetup(ca.tecreations.Properties properties) {
        properties.setDelayWrite(true);
        properties.set(PKIData.DEBUG_SSL, "false");
        properties.set(PKIData.MAKE_SECURE, "true");
        String propsName = new ca.tecreations.File(properties.getFilename()).getName();
        String remoteHost = "localhost";
        int index = propsName.indexOf("_client");
        if (index > 0) {
            remoteHost = propsName.substring(0, index);
        }
        properties.set(PKIData.REMOTE_HOST, remoteHost);
        boolean isWin = Platform.isWin();
        properties.set(PKIData.REMOTE_KEYSTORE, (isWin ? "S:\\" : "/") + "security" + ca.tecreations.File.separator + "client_keystore");
        properties.set(PKIData.REMOTE_KEYSTORE_PASSWORD, "prompt");
        properties.set(PKIData.REMOTE_PORT, 52820);
        properties.set(PKIData.REMOTE_TRUSTSTORE, (isWin ? "S:\\" : "/") + "security" + ca.tecreations.File.separator + "client_truststore");
        properties.write();
        System.out.println(SN + ".doInitialSetup: Configure properties and re-run: " + properties.getFilename());
        System.exit(0);
    }

    public static void doLogAction(String s) {
        System.out.println(s);
    }

    public static void doLogAction(int sysStreamType, String s) {
        if (sysStreamType == TecData.SYS_ERR) {
            System.err.println(s);
        } else {
            System.out.println(s);
        }
    }

    public void doTLSConnect() throws NoTLSConnectionException {
        if (verbose) {
            System.out.println(SN + ".doTLSConnect(1): Properties: " + properties.getFilename());
            System.out.println(SN + ".doTLSConnect(2): Password:   " + TypeToType.toString(this.keyStorePass));
        }
        try {
            String ksPath = properties.get(PKIData.REMOTE_KEYSTORE);
            if (ksPath == null) {
                doInitialSetup(properties);
                System.err.println("Invalid configuration: " + properties.getFilename());
                System.err.println("Please validate. Exiting.");
                System.exit(0);
            }
            if (!new File(ksPath).exists()) {
                System.err.println("Keystore file does not exist: " + ksPath + " Exiting.");
                System.err.println("Properties: " + properties.getFilename());
                System.exit(0);
            }
            keyStore = SecurityTool.openKeyStore(SecurityTool.JKS, ksPath, this.keyStorePass);
        } catch (UnrecoverableKeyException uke) {
            ExceptionHandler.handle(SN + ".doTLSConnect(3): ", "bad pass", uke, true);
            System.exit(0);
        } catch (Exception e) {
            ExceptionHandler.handle(SN + ".doTLSConnect(4): ", "unknown", e, true);
        }
        String tsPath = properties.get(PKIData.REMOTE_TRUSTSTORE);
        if (tsPath == null) {
            doInitialSetup(properties);
            System.err.println("Invalid configuration: " + properties.getFilename());
            System.err.println("Please validate. Exiting.");
            System.exit(0);
        }
        if (!new File(tsPath).exists()) {
            System.err.println("Truststore file does not exist: " + tsPath);
            System.err.println("Properties: " + properties.getFilename());
            System.exit(0);
        }
        trustStore = SecurityTool.openTrustStore(SecurityTool.JKS, tsPath);
        if (keyStore == null | trustStore == null) {
            System.out.println(SN + ".doTLSConnect(4): Unable to open keyStore or trustStore. Cannot continue.");
            System.out.println(SN + ".doTLSConnect(5): Keystore: " + keyStore + " Path: " + properties.get(PKIData.REMOTE_KEYSTORE));
            System.out.println(SN + ".doTLSConnect(6): Truststore: " + trustStore + " Path: " + properties.get(PKIData.REMOTE_TRUSTSTORE));
            System.out.println(SN + ".doTLSConnect(7): Verify setup and re-run: " + properties.getFilename());
            System.exit(0);
        }
        try {
            sslContext = SSLContext.getInstance(SecurityTool.TLS, SecurityTool.BCJSSE);;
            keyMgrFact = KeyManagerFactory.getInstance(SecurityTool.PKIX, SecurityTool.BCJSSE);;
            keyMgrFact.init(keyStore, this.keyStorePass);
            trustMgrFact = TrustManagerFactory.getInstance(SecurityTool.PKIX, SecurityTool.BCJSSE);
            trustMgrFact.init(trustStore);
            sslContext.init(keyMgrFact.getKeyManagers(), trustMgrFact.getTrustManagers(), null);
            fact = sslContext.getSocketFactory();
        } catch (UnrecoverableKeyException e) {
            System.out.println(SN + ".doTLSConnect(8) : Unrecoverable Key: pass: " + TypeToType.toString(this.keyStorePass));
            System.out.println(SN + ".doTLSConnect(9) : properties: " + properties.getFilename());
            System.out.println(SN + ".doTLSConnect(10): Keystore missing. Exiting.");
            System.exit(0);
        } catch (Exception e) {
            ExceptionHandler.handle(SN + "()", e);
        }
        if (properties.getBoolean("make.secure")) {
            for (int i = 0; i < this.keyStorePass.length; i++) {
                this.keyStorePass[i] = '\0';
            }
        }
        try {
            tlsSocket = (SSLSocket) fact.createSocket(host, port);
        } catch (Exception e) {
            System.err.println("Unable to connect: properties: " + properties.getFilename());
            throw new NoTLSConnectionException(SN + ".doTLSConnect: " + e.getMessage());
        }
    }
    
    public List<SystemToken> execForOutput(String command) {
        String op = TNData.EXEC_FOR_OUTPUT;
        sendToServer(op, command);
        return TypeToType.toListSystemToken(readFromServer(op));
    }


    public void execSpawnJava(String classPath, String className, String appArgs) {

    }

    public boolean exists(String path) {
        return false;
    }

    public Properties getClientProperties() {
        return properties;
    }

    public String getCommsType() {
        return (encrypt ? "encrypted" : "un-encrypted");
    }

    public String getDirSize(String path) {
        sendToServer(TNData.GET_DIR_SIZE, path);
        List<String> lines = readFromServer(TNData.GET_DIR_SIZE);
        return lines.get(0);
    }

    public List<String> getDirSizes(String path) {
        sendToServer(TNData.GET_DIR_SIZES, path);
        List<String> lines = readFromServer(TNData.GET_DIR_SIZES);
        return lines;
    }

    public List<String> getFileLines(String path) {
        return new ArrayList<String>();
    }

    public String getFileSeparator() {
        return "!";
    }

    public String getPathSeparator() {
        return "!!";
    }

    public List<String> getServerProperties() {
        String op = TNData.GET_SERVER_PROPERTIES;
        //send(op,"");
        //return readFromServer("getServerProperties");
        return new ArrayList<String>();
    }

    public Socket getSocket() {
        if (encrypt) {
            return tlsSocket;
        } else {
            return rawSocket;
        }
    }

    public boolean hasJava(String path) {
        return false;
    }

    public boolean hasShutDownLetters(String t) {
        return t.length() == 8
                && (t.contains("S") || t.contains("s"))
                && (t.contains("H") || t.contains("h"))
                && (t.contains("U") || t.contains("u"))
                && (t.contains("T") || t.contains("t"))
                && (t.contains("D") || t.contains("d"))
                && (t.contains("O") || t.contains("o"))
                && (t.contains("W") || t.contains("w"))
                && (t.contains("N") || t.contains("n"));
    }

    public boolean isDir(String path) {
        return false;
    }

    public boolean isEncrypted() {
        return encrypt;
    }

    public boolean isNix() {
        validateServerProperties();
        return !isWin;
    }

    public boolean isRunning() {
        return running;
    }

    public boolean isWin() {
        validateServerProperties();
        return isWin;
    }

    public static void main(String[] args) {
        Properties properties = new ca.tecreations.Properties(ProjectPath.getTecPropsPath() + "Client.properties");
        Client client = null;
        try {
            client = new Client(properties, true, null);
        } catch (NoTLSConnectionException ntlsce) {
            System.out.println("No TLS Connection: " + ntlsce.getMessage());
        }

        if (client != null) {
            client.start();
            System.out.println("Started Client(" + properties.get(PKIData.REMOTE_HOST) + "): "
                    + properties.get(PKIData.REMOTE_PORT) + " : " + client.getCommsType());
            List<SystemToken> tokens = client.execForOutput("/usr/lib/jvm/jdk-19/bin/java -cp /mnt/data/projects/BCTLSNetwork:/mnt/data/projects/BCTLSNetwork/jars/* ca.tecreations.BuildProject");
            for(int i = 0; i < tokens.size();i++) tokens.get(i).println();
        }
    }

    public final void openSocket() throws NoTLSConnectionException {
        Integer port = properties.getInt(PKIData.REMOTE_PORT);
        if (port == null) {
            properties.set(PKIData.REMOTE_PORT, 52820);
        } else {
            this.port = port;
        }
        try {
            if (encrypt) {
                if (keyStorePass == null) {
                    // check properties for password
                    String pass = this.properties.get(PKIData.REMOTE_KEYSTORE_PASSWORD);
                    if (pass == null || pass.toLowerCase().equals("prompt")) {
                        this.keyStorePass = Platform.requestPassword(null, "Enter the keystore pass for: host: " + host + "--[" + Internet.getWanIP() + "]:" + Internet.getLanIP() + " : " + port);
                    } else {
                        this.keyStorePass = pass.toCharArray();
                    }
                } else if (SharedCode.isPrompt(keyStorePass)) {
                    this.keyStorePass = Platform.requestPassword(null, "Enter the keystore pass for: host: " + host + "--[" + Internet.getWanIP() + "]:" + Internet.getLanIP() + " : " + port);
                }
                doTLSConnect();
            } else {
                rawSocket = new Socket(host, port);
            }
        } catch (UnknownHostException e) {
            System.err.println("Unknown host " + host);
            System.exit(1);
        } catch (IOException e) {
            System.err.println("Couldn't get I/O for the connection to " + host);
            System.exit(1);
        }
    }

    private void parseProperties(List<String> list) {
        String s;
        for (int i = 0; i < list.size(); i++) {
            s = list.get(i);
            if (s.startsWith("file.separator")) {
                fileSeparator = s.substring(s.indexOf(":") + 1).trim();
            } else if (s.startsWith("path.separator")) {
                pathSeparator = s.substring(s.indexOf(":") + 1).trim();
            } else if (s.startsWith("os.name")) {
                serverOS = s.substring(s.indexOf(":") + 1).trim();
                isWin = serverOS.toLowerCase().contains("win");
            }
        }
    }

    public static void print(List<String> list) {
        for (int i = 0; i < list.size(); i++) {
            System.out.println(i + ": " + list.get(i));
        }
    }

    public void process(String op, String args) {
        if (op.equals(TNData.EXEC_FOR_OUTPUT)) {
            List<SystemToken> tokens = execForOutput(args);
            for (int i = 0; i < tokens.size(); i++) {
                tokens.get(i).println();
            }
        } else if (op.equals(TNData.EXEC_FOR_OUTPUT_JAVA)) {
            sendToServer(op, args);
        } else {
            sendToServer(op, args);
            readFromServer(op);
        }
    }
    

    public void processGet(String src, String dst) {
        String op = TNData.GET;

        // we need the file size for the ProgressListener
        String op2 = TNData.GET_FILE_SIZE;
        sendToServer(op2, src);
        List<String> result = readFromServer(op2);
        String line = result.get(0);
        String size = line.substring(line.lastIndexOf(" ") + 1);
        System.out.println(SN + ".process(" + op + "): size: " + size);

        // do the transfer
        sendToServer(op, src); // send GET ...
        List<String> expectOK = readFromServer(op);
        if (expectOK.get(0).equals(TNData.OK)) {
            // server response should be OK
            getFile(Long.parseLong(size), dst);
            expectOK = readFromServer(TNData.OK);
            if (!expectOK.get(0).equals(TNData.OK)) {
                System.err.println(SN + ".run(" + op + "): !ok: " + expectOK);
            }
        } else {
            System.err.println(SN + ".run(" + op + "): !ok: " + expectOK);
        }
    }

    public void processPut(String src, String dst, Long length) {
        String op = TNData.PUT;

        // do the transfer
        sendToServer(op, dst + " " + new File(src).length()); // send PUT ...
        List<String> expectOK = readFromServer(op);
        if (expectOK.get(0).equals(TNData.OK)) {
            // server response should be OK
            putFile(src);
            expectOK = readFromServer(op);
            if (!expectOK.get(0).equals(TNData.OK)) {
                System.err.println(SN + ".run(" + op + "): !ok(1): " + expectOK.get(0));
            }
        } else {
            System.err.println(SN + ".run(" + op + "): !ok(2): " + expectOK.get(0));
        }
    }

    public List<String> readFromServer(String op) {
        List<String> lines = new ArrayList<>();
        try {
            boolean done = false;
            String output = "";
            while (output != null && !done) {
                output = inBR.readLine();
                if (output.length() == 1 && output.charAt(0) == '\0') {
                    done = true;
                } else {
                    System.out.println(SN + ".readFromServer(" + op + "): " + output);
                    lines.add(output);
                }
            }
        } catch (IOException ioe) {
            ExceptionHandler.handleIO(SN + ".readFromServer(" + op + ")", "reading from server", ioe, false);
        }
        return lines;
    }

    public void run() {
        while (running) {
            String userInput;
            try {
                System.err.println("Enter a command:");
                while ((userInput = stdIn.readLine()) != null) {
                    String trimmed = userInput.trim();
                    System.err.println(SN + ".run:console: got: " + trimmed);
                    if (!trimmed.equals("")) {
                        String op;
                        String args = null;
                        int spaceIndex = trimmed.indexOf(" ");
                        if (spaceIndex > 0) {
                            op = trimmed.substring(0, spaceIndex);
                            args = trimmed.substring(spaceIndex + 1);
                        } else {
                            op = trimmed;
                        }
                        op = op.toUpperCase();

                        String src = null;
                        String dst = null;
                        String remainder = null;
                        if (args != null) {
                            if (StringTool.hasFile(args)) {
                                String[] srcArray = StringTool.getFileAndTrimmedRemainder(args);
                                src = srcArray[0];
                                remainder = srcArray[1];
                                if (StringTool.hasFile(remainder)) {
                                    String[] dstArray = StringTool.getFileAndTrimmedRemainder(remainder);
                                    dst = dstArray[0];
                                    remainder = dstArray[1];
                                }
                            } else {
                                remainder = args;
                            }
                        }

                        if (op.equals("QUIT") | op.equals("EXIT")) {
                            System.exit(0);
                        } else if (hasShutDownLetters(op)) {
                            shutdown();
                        } else if (op.equals(TNData.GET)) {
                            processGet(src, dst);
                        } else if (op.equals(TNData.PUT)) {
                            processPut(src, dst, new File(src).length());
                        } else {
                            process(op, args);
                        }
                    }
                }
                System.err.println("Enter a command:");
            } catch (IOException ioe) {
                ExceptionHandler.handleIO(SN + ".run", "reading user input", ioe, false);
            }
        }
    }

    public void sendToServer(String op, String args) {
        outPW.println(op + " " + args);
    }

    public void shutdown() {
        String op = TNData.SHUTDOWN;
        process(op, "");
        System.exit(0);
    }

    public void spawn(String op, String args) {

    }

    @Override
    public void start() {
        running = true;
        super.start();
    }

    public void textClose() {
        outPW.close();
        try {
            inISR.close();
        } catch (IOException ioe) {
            ExceptionHandler.handle(SN + "closeText", "closing inISR", ioe, false);
        }
        try {
            inBR.close();
        } catch (IOException ioe) {
            ExceptionHandler.handle(SN + "closeText", "closing inBR", ioe, false);
        }
    }

    public void textOpen(String caller) {
        try {
            outPW = new PrintWriter(getSocket().getOutputStream(), true);
        } catch (IOException ioe) {
            ExceptionHandler.handleIO(SN + ".textOpen(" + caller + ")", "opening outPW", ioe, false);
        }
        try {
            inISR = new InputStreamReader(getSocket().getInputStream());
        } catch (IOException ioe) {
            ExceptionHandler.handleIO(SN + ".textOpen(" + caller + ")", "opening inISR", ioe, false);
        }
        inBR = new BufferedReader(inISR);
    }

    public void validateServerProperties() {
        if (isWin == null) {
            List<String> list = getServerProperties();
            parseProperties(list);
        }
    }

    public void waitFor(String op, String args) {

    }

    //--------------------------------------------------------------------------
    public long jobTotal = 0L;
    public long jobRead = 0L;
    public int jobPercent = 0;
    public int oldJobPercent = 0;

    public boolean getFile(long length, File dst) {
        return getFile(length, dst.getAbsolutePath());
    }

    public boolean getFile(long length, String dst) {
        binaryOpenIn("getFile");
        boolean successful = false;
        boolean allSuccessful = false;
        boolean failed = false;
        if (debug) {
            SharedCode.doLogAction(log, SN + ".getFile: EDT: " + javax.swing.SwingUtilities.isEventDispatchThread() + " Size: " + length + " -> " + dst);
        }
        int oldMegs = 0;
        for (int i = 0; i < progressListeners.size(); i++) {
            progressListeners.get(i).updateItem(0);
        }
        FileOutputStream fos = null;
        byte[] buffer = null;
        long remaining = length;
        if (length >= 60000) {
            buffer = new byte[60000];
        } else {
            buffer = new byte[(int) length];
        }
        long itemTotal = 0;
        int bytesRead;

        new File(dst).getParentFile().mkdirs();
        try {
            fos = new FileOutputStream(new File(dst));
        } catch (FileNotFoundException fnfe) {
            ExceptionHandler.handleIO(SN + ".getFile", "file not found", fnfe, true);
        }
        if (fos != null) {
            try {
                boolean done = false;
                while (!done) {
                    bytesRead = in.read(buffer, 0, buffer.length);
                    if (bytesRead == -1) {
                        done = true;
                    } else {
                        fos.write(buffer, 0, bytesRead);
                        fos.flush();
                        itemTotal += bytesRead;
                        jobRead += bytesRead;
                        verboseDebug(SN + ".getFile: Wrote(1): " + bytesRead + " Total: " + itemTotal);
                        int megs = (int) (itemTotal / TecData.MEGA);
                        if (megs > oldMegs) {
                            oldMegs = megs;
                            verboseDebug(SN + ".getFile: Wrote(2): " + bytesRead + " Total: " + itemTotal);
                        }
                        //seconds = (int) ((double) (now - jobStart) / (double) 1000);
                        int jobPercent = (int) ((double) jobRead / (double) jobTotal * (double) 100);
                        int itemPercent = (int) ((double) itemTotal / (double) length * (double) 100);
                        for (int i = 0; i < progressListeners.size(); i++) {
                            progressListeners.get(i).update("Get: (" + jobPercent + " %): File: " + new File(dst).getName(), jobPercent, itemPercent);
                        }
                        oldJobPercent = jobPercent;
                    }
                    if (itemTotal == length /* && dst.length() == length */) {
                        done = true;
                    }
                }
                successful = true;
            } catch (IOException ioe) {
                ExceptionHandler.handleIO(SN + ".getFile", "copying", ioe, false);
                failed = true;
            } finally {
                try {
                    fos.close();
                    allSuccessful = true;
                } catch (IOException ioe) {
                    ExceptionHandler.handleIO(SN + ".getFile", "closing", ioe, false);
                    failed = true;
                }
            }
        } else {
            System.err.println(SN + ".getFile: failure: in: " + in + " fos: " + fos);
            SharedCode.doLogAction(log, SN + ".getFile: Failure: in: " + in + " fos: " + fos);
        }
//        doneGetFile = true;
        textOpen("getFile");
        return successful && allSuccessful && !failed;
    }

    public boolean putFile(String src) {
        return putFile(new File(src));
    }

    public boolean putFile(File src) {
        binaryOpenOut("putFile");
        boolean successful = false;
        //OutputStream out = getSocket().getOutputStream();
        long oneMeg = 1024 * 1024;
        int oldMegs = 0;
        int read_count = 0;
//        fireUpdate(oldJobPercent, 0);

        int length = (int) src.length();
        byte[] buffer = null;
        if (length > 0 && length < TNData.SIXTY_GEES) {
            buffer = new byte[length];
        } else {
            buffer = new byte[TNData.SIXTY_GEES];
        }

        int bytesRead = 0;
        long itemTotal = 0;
        FileInputStream fis = null;
        try {
            String path = src.toPath().toString();
            fis = new FileInputStream(path);
        } catch (IOException ioe) {
            SharedCode.doLogAction(log, SN + ".putFile: opening input: " + ioe);
        }
        try {
            boolean done = false;
            while (!done) {
                bytesRead = fis.read(buffer);
                if (bytesRead == -1) {
                    done = true;
                    verboseDebug(SN + ".putFile: Wrote: " + bytesRead + " Total: " + itemTotal);
                } else {
                    out.write(buffer, 0, bytesRead);
                    out.flush();
                    read_count++;
                    itemTotal += bytesRead;
                    jobRead += bytesRead;
                    int jobPercent = (int) ((double) jobRead / (double) jobTotal * (double) 100);
                    int itemPercent = (int) ((double) itemTotal / (double) length * (double) 100);
                    int megs = (int) (itemTotal / oneMeg);
                    if (megs > oldMegs || bytesRead == -1) {
                        oldMegs = megs;
                        SharedCode.doLogAction(log, SN + ".putFile: Wrote: " + bytesRead + " Total: " + itemTotal);
                    } else {
                        verboseDebug(SN + ".putFile: Wrote: " + bytesRead + " Total: " + itemTotal);
                    }
                    update("Put: (" + jobPercent + " %): File: " + new File(src).getName(), jobPercent, itemPercent);
                    oldJobPercent = jobPercent;
                }
            }
            successful = true;
//            fireUpdate(oldJobPercent, 100);
            SharedCode.doLogAction(log, SN + ".putFile: Wrote: " + bytesRead + " Total: " + itemTotal);
        } catch (IOException ioe) {
            ExceptionHandler.handleIO(SN + ".putFile", "reading and writing", ioe, false);
        } finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            } catch (IOException ioe) {
            } // why do anything?
        }
        textOpen("putFile");
        return successful;
    }

    public void update(String msg, int job, int item) {
        for (int i = 0; i < progressListeners.size(); i++) {
            progressListeners.get(i).update(msg, job, item);
        }
    }

    public void verboseDebug(String s) {
        if (debug && verbose) {
            doLogAction(s);
        }
    }

}
