package ca.tecreations.db.mysql;

import ca.tecreations.File;
import ca.tecreations.ProjectPath;
import ca.tecreations.StringTool;
import ca.tecreations.TypeToType;
import ca.tecreations.components.SizedPanel;
import ca.tecreations.components.TFrame;
import ca.tecreations.Properties;

import ca.tecreations.db.mysql.MySQL;
import ca.tecreations.db.mysql.MySQL_Ops;
import ca.tecreations.db.mysql.MySQLUser;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.event.*;
import java.sql.ResultSet;
import java.util.List;

import javax.swing.*;
import javax.swing.border.EmptyBorder;
import javax.swing.event.*;
/**
 *
 * @author tim
 */
public class MySQLAdmin extends TFrame implements ActionListener, DocumentListener, ItemListener, ChangeListener {
    static Properties properties = new Properties(new File(ProjectPath.instance.getPropertiesPath() + "properties" + File.separator + "MySQLAdmin.properties"),false,true);
 
    public static boolean debug = true;
    
    MySQL_Ops ops = null;


    JTabbedPane tabbedPane = new JTabbedPane();
    
    JLabel hostLabel = new JLabel("Hostname: ");
    JTextField host = new JTextField(16);
    JLabel portLabel = new JLabel("Port: ");
    JTextField port = new JTextField(5);
    JLabel userLabel = new JLabel("Username: ");
    JTextField user = new JTextField(16);
    JLabel passLabel = new JLabel("Password: ");
    JPasswordField pass = new JPasswordField(16);
    char echoChar = pass.getEchoChar();
    JCheckBox showPass = new JCheckBox("Show Pass");
    JButton connection = new JButton("Connect");
    
    JLabel databasesLabel = new JLabel("Databases: ");
    JComboBox<String> databases = new JComboBox<>();
    JButton dropDatabase = new JButton("DROP DATABASE");
    JLabel dbNameLabel = new JLabel("Database Name: ");
    JTextField dbName = new JTextField(16);
    JButton createDatabase = new JButton("Create");
    JLabel tablesLabel = new JLabel("Tables: ");
    JComboBox<String> tables = new JComboBox<>();
    JButton dropTable = new JButton("DROP TABLE");
    JLabel usersLabel = new JLabel("Users: ");
    JComboBox<String> users = new JComboBox<>();
    List<MySQLUser> userList;
    JButton dropUser = new JButton("DROP USER");
    JTextField userName = new JTextField(16);
    JTextField userPass = new JTextField(16);
    JButton createUser = new JButton("CREATE USER");
    JButton setPassword = new JButton("Set User Password");
    JTextField userTxt = new JTextField(16);
    JTextField targetDBTxt = new JTextField(16);
    JButton grant = new JButton("Grant All");
    JButton grantGrant = new JButton("Grant All With Grant");
    JButton grantMin = new JButton("Grant Minimim");

    JLabel sqlLabel = new JLabel("SQL:");
    JScrollPane sqlScroller;
    JTextArea sqlArea = new JTextArea(40,80);
    JLabel resultLabel = new JLabel("Result:");
    JScrollPane resultScroller;
    JTextArea resultArea = new JTextArea(40,80);
    JButton issue = new JButton("Issue");
    
    boolean doLayout = true;
    
    public MySQLAdmin() {
        super(properties,"MySQLAdmin");
        setTitle("MySQL Administration");
        setVisible(true);
        setLayout(new BorderLayout());
        loadProperties();
        JComponent connection = makeConnectionPanel();
        tabbedPane.addTab("Connection", null, connection,
                  "Connection Operations");
        tabbedPane.setMnemonicAt(0, KeyEvent.VK_1);
        
        JComponent admin = makeAdminPanel();
        tabbedPane.addTab("Admin", null, admin,
                  "Admin Operations");
        tabbedPane.setMnemonicAt(0, KeyEvent.VK_2);
        
        JComponent sqlIssuer = makeSQLIssuerPanel();
        tabbedPane.addTab("SQL", null, sqlIssuer,
                  "Custom SQL Statement");
        tabbedPane.setMnemonicAt(1, KeyEvent.VK_4);
        
        add(tabbedPane,BorderLayout.CENTER);
        tabbedPane.addChangeListener(this);
        validate();
        disconnect();
        setSize(840,480);

        // here is where I set my auto-connect parameters for testing
        //user.setText("");
        //pass.setText("");
        //doConnect();
        //if (ops.isConnected()) processSQL();
    }
    
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == connection) {
            if (ops == null || !ops.isConnected()) {
                doConnect();
            } else if (ops.isConnected()) {
                disconnect();
                connection.setText("Connect");
            }
        } else if (e.getSource() == dropDatabase) {
            String dbName = (String)databases.getSelectedItem();
            ops.dropDatabase(dbName,true);
            refreshDatabases();
        } else if (e.getSource() == createDatabase) {
            ops.createDatabase(dbName.getText(),true);
            refreshDatabases();
            dbName.setText("");
        } else if (e.getSource() == dropTable) {
            ops.dropTable((String)tables.getSelectedItem(),true);
        } else if (e.getSource() == dropUser) {
            MySQLUser entry = userList.get(users.getSelectedIndex());
            ops.dropUserAtHost(entry.getName(),entry.getHost(),true);
            refreshUsers();
        } else if (e.getSource() == createUser) {    
            ops.createUser(userName.getText(),userPass.getText(),true);
            if (ops.getMySQL() != null) {
                if (ops.getMySQL().getException() != null) {
                    resultArea.setText(ops.getMySQL().getException().toString());
                }
            }
            refreshUsers();
            userName.setText("");
            userPass.setText("");
        } else if (e.getSource() == setPassword) {
//            if (userPass.getText().equals("")) {
//                Platform.message(this,"Password cannot be empty.");
//            } else {
//                ops.setPassword(userName.getText(),userPass.getText());
//            }
        } else if (e.getSource() == grant) {
            String targetDB = targetDBTxt.getText();
            if (!targetDB.contains(".")) targetDB += ".*";
            ops.grantAllOnDBToUser(targetDB,userTxt.getText());
            refreshUsers();
        } else if (e.getSource() == grantGrant) {
            String targetDB = targetDBTxt.getText();
            if (!targetDB.contains(".")) targetDB += ".*";
            ops.grantWithOnDBToUser(targetDB,userTxt.getText());
            refreshUsers();
        } else if (e.getSource() == grantMin) {
            String targetDB = targetDBTxt.getText();
            if (!targetDB.contains(".")) targetDB += ".*";
            ops.grantMinimal(targetDB,userTxt.getText());
            refreshUsers();
        } else if (e.getSource() == issue) {
            processSQL();
        }
    }
    
    @Override
    public void changedUpdate(DocumentEvent e) {
        setProperties();
    }
    
    @Override
    public void componentResized(ComponentEvent e) {
    }
    
    public void connected() {
        tabbedPane.setEnabledAt(1,true);
        tabbedPane.setEnabledAt(2,true);
    }
    
    public void disconnect() {
        ops = null;
        tabbedPane.setEnabledAt(1,false);
        tabbedPane.setEnabledAt(2,false);
    }
    
    public void doConnect() {
        ops = new MySQL_Ops(new MySQL(host.getText(),Integer.parseInt(port.getText()),
                                      dbName.getText(),user.getText(),
                                      TypeToType.toCharArray(pass.getText())));
        if (ops.isConnected()) {
            connected();
            connection.setText("Disconnect");
            tabbedPane.setSelectedIndex(1);
        }
    }
    
    public void loadProperties() {
        host.setText(properties.get("host"));
        port.setText(properties.get("port"));
        user.setText(properties.get("user"));
    }
    
    @Override
    public void insertUpdate(DocumentEvent e) {
        setProperties();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
//        if (e.getSource() == ifNotExists) {
//            ifNotExistsLbl.setEnabled(ifNotExists.isSelected());
//        } else 
        if (e.getSource() == showPass) {
            if (showPass.isSelected()) {
                pass.setEchoChar('\0');
            } else {
                pass.setEchoChar(echoChar);
            }
        } else if (e.getSource() == databases) {
            String dbName = (String)e.getItem();
            ops.useDatabase(dbName);
            tables.removeAllItems();
            List<String> tablesList = ops.getTables();
            for(int i = 0; i < tablesList.size();i++) {
                tables.addItem(tablesList.get(i));
            }
        }
    }
    
    public static void main(String[] args) {
        new MySQLAdmin();
    }
    
    public JPanel makeAdminPanel() {
        JPanel panel = new JPanel(new GridBagLayout(),false);
        panel.setBorder(new EmptyBorder(20,20,20,20));
        GridBagConstraints gbc;

        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = gbc.VERTICAL;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        panel.add(new SizedPanel(20,20,java.awt.Color.cyan),gbc);

        
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 4;
        gbc.gridheight = 1;
        gbc.fill = gbc.HORIZONTAL;
        gbc.weightx = 1.0;
        panel.add(databasesLabel,gbc);
        
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 1;
        gbc.gridwidth = 4;
        gbc.gridheight = 1;
        gbc.fill = gbc.HORIZONTAL;
        gbc.weightx = 1.0;
        panel.add(databases,gbc);
        databases.addItemListener(this);
        
        gbc = new GridBagConstraints();
        gbc.gridx = 7;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = gbc.NONE;
        panel.add(new SizedPanel(10,10,getBackground()),gbc);
        
        gbc = new GridBagConstraints();
        gbc.gridx = 8;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.fill = gbc.HORIZONTAL;
        gbc.weightx = 1.0;
        panel.add(dropDatabase,gbc);
        dropDatabase.addActionListener(this);
        
        gbc = new GridBagConstraints();
        gbc.gridx = 10;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.fill = gbc.HORIZONTAL;
        panel.add(new SizedPanel(10,10,getBackground()),gbc);
        
        

        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.fill = gbc.NONE;
        panel.add(new SizedPanel(10,10,java.awt.Color.green/*getBackground()*/),gbc);


        
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.fill = gbc.HORIZONTAL;
        gbc.weightx = 1.0;
        panel.add(dbNameLabel,gbc);
        
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = gbc.NONE;
        panel.add(new SizedPanel(10,10,getBackground()),gbc);
        
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 3;
        gbc.gridwidth = 4;
        gbc.gridheight = 1;
        gbc.fill = gbc.HORIZONTAL;
        gbc.weightx = 1.0;
        panel.add(dbName,gbc);
        
        gbc = new GridBagConstraints();
        gbc.gridx = 7;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = gbc.NONE;
        panel.add(new SizedPanel(10,10,getBackground()),gbc);
        
        gbc = new GridBagConstraints();
        gbc.gridx = 8;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.fill = gbc.HORIZONTAL;
        gbc.weightx = 1.0;
        panel.add(createDatabase,gbc);
        createDatabase.addActionListener(this);
        
        gbc = new GridBagConstraints();
        gbc.gridx = 10;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.fill = gbc.HORIZONTAL;
        gbc.weightx = 1.0;
        panel.add(new SizedPanel(10,10,getBackground()),gbc);
        
        
        
        
        gbc = new GridBagConstraints();
        gbc.gridy = 4;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = gbc.VERTICAL;
        gbc.weighty = 1.0;
        panel.add(new SizedPanel(20,20,java.awt.Color.blue/*getBackground()*/),gbc);
        
        
        
        
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.fill = gbc.HORIZONTAL;
        panel.add(tablesLabel,gbc);
        
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 5;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = gbc.NONE;
        panel.add(new SizedPanel(10,10,getBackground()),gbc);
        
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 5;
        gbc.gridwidth = 4;
        gbc.gridheight = 1;
        gbc.fill = gbc.HORIZONTAL;
        gbc.weightx = 1.0;
        panel.add(tables,gbc);

        gbc = new GridBagConstraints();
        gbc.gridx = 7;
        gbc.gridy = 5;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = gbc.NONE;
        panel.add(new SizedPanel(10,10,getBackground()),gbc);
        
        gbc = new GridBagConstraints();
        gbc.gridx = 8;
        gbc.gridy = 5;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.fill = gbc.HORIZONTAL;
        gbc.weightx = 1.0;
        panel.add(dropTable,gbc);
        dropTable.addActionListener(this);
        
        gbc = new GridBagConstraints();
        gbc.gridx = 11;
        gbc.gridy = 5;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        panel.add(new SizedPanel(10,10,getBackground()),gbc);
        
        
        
        
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = gbc.VERTICAL;
        gbc.weighty = 1.0;
        panel.add(new SizedPanel(20,20,java.awt.Color.red),gbc);

        
        
        
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 7;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.fill = gbc.HORIZONTAL;
        panel.add(usersLabel,gbc);
        
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 7;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = gbc.NONE;
        panel.add(new SizedPanel(10,10,getBackground()),gbc);
        
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 7;
        gbc.gridwidth = 4;
        gbc.gridheight = 1;
        gbc.fill = gbc.HORIZONTAL;
        gbc.weightx = 1.0;
        panel.add(users,gbc);

        gbc = new GridBagConstraints();
        gbc.gridx = 7;
        gbc.gridy = 7;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = gbc.NONE;
        panel.add(new SizedPanel(10,10,getBackground()),gbc);
        
        gbc = new GridBagConstraints();
        gbc.gridx = 8;
        gbc.gridy = 7;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.fill = gbc.HORIZONTAL;
        gbc.weightx = 1.0;
        panel.add(dropUser,gbc);
        dropUser.addActionListener(this);
        
        gbc = new GridBagConstraints();
        gbc.gridx = 11;
        gbc.gridy = 7;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        panel.add(new SizedPanel(10,10,getBackground()),gbc);
        
        
        
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 8;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = gbc.VERTICAL;
        panel.add(new SizedPanel(10,10,java.awt.Color.orange),gbc);

        JPanel row10 = new JPanel(new GridLayout(1,2));
        JPanel fields = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        gbc.fill = gbc.NONE;
        fields.add(new JLabel("User: "),gbc);
        
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridwidth = 3;
        gbc.fill = gbc.HORIZONTAL;
        gbc.weightx = 1.0;
        fields.add(userName,gbc);
        
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridwidth = 1;
        gbc.fill = gbc.NONE;
        fields.add(new JLabel("Password: "),gbc);
        
        gbc = new GridBagConstraints();
        gbc.gridx = 5;
        gbc.gridwidth = 3;
        gbc.fill = gbc.HORIZONTAL;
        gbc.weightx = 1.0;
        fields.add(userPass,gbc);
        row10.add(fields);
        
        JPanel buttonPanel = new JPanel(new FlowLayout(FlowLayout.LEFT));
        buttonPanel.add(createUser);
        buttonPanel.add(setPassword);
        createUser.addActionListener(this);
        setPassword.addActionListener(this);
        row10.add(buttonPanel);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 9;
        gbc.gridwidth = 12;
        gbc.fill = gbc.HORIZONTAL;
        panel.add(row10,gbc);
        
        
        
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 10;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = gbc.VERTICAL;
        panel.add(new SizedPanel(10,10,java.awt.Color.orange),gbc);

        
        
        JPanel row11 = new JPanel(new GridLayout(1,2));
        JPanel userFields = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        gbc.fill = gbc.NONE;
        userFields.add(new JLabel("User: "),gbc);
        
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridwidth = 3;
        gbc.fill = gbc.HORIZONTAL;
        gbc.weightx = 1.0;
        userFields.add(userTxt,gbc);
        
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridwidth = 1;
        gbc.fill = gbc.NONE;
        userFields.add(new JLabel("Target DB: "),gbc);
        
        gbc = new GridBagConstraints();
        gbc.gridx = 5;
        gbc.gridwidth = 3;
        gbc.fill = gbc.HORIZONTAL;
        gbc.weightx = 1.0;
        userFields.add(targetDBTxt,gbc);
        row11.add(userFields);
        
        JPanel buttons = new JPanel(new FlowLayout(FlowLayout.CENTER));
        buttons.add(grant);
        buttons.add(grantGrant);
        buttons.add(grantMin);
        grant.addActionListener(this);
        grantGrant.addActionListener(this);
        grantMin.addActionListener(this);
        row11.add(buttons);
        
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 11;
        gbc.gridwidth = 12;
        gbc.fill = gbc.HORIZONTAL;
        panel.add(row11,gbc);
        
        
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 12;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = gbc.VERTICAL;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        panel.add(new SizedPanel(20,20,java.awt.Color.magenta),gbc);
        return panel;
    }
    
    public JPanel makeConnectionPanel() {
        JPanel panel = new JPanel(new BorderLayout(),false);
        JPanel center = new JPanel(new GridBagLayout(),false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.anchor = gbc.LINE_START;
        center.add(hostLabel,gbc);
         
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridwidth = 5;
        gbc.gridheight = 1;
        gbc.fill = gbc.HORIZONTAL;
        center.add(host,gbc);
        host.getDocument().addDocumentListener(this);
        
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.anchor = gbc.LINE_START;
        center.add(portLabel,gbc);
        
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.gridwidth = 5;
        gbc.gridheight = 1;
        gbc.anchor = gbc.LINE_START;
        center.add(port,gbc);
        port.getDocument().addDocumentListener(this);
        
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.anchor = gbc.LINE_START;
        center.add(userLabel,gbc);
        
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.gridwidth = 5;
        gbc.gridheight = 1;
        gbc.fill = gbc.HORIZONTAL;
        center.add(user,gbc);
        user.getDocument().addDocumentListener(this);
        
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.anchor = gbc.LINE_START;
        center.add(passLabel,gbc);
        
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 3;
        gbc.gridwidth = 5;
        gbc.gridheight = 1;
        gbc.fill = gbc.HORIZONTAL;
        center.add(pass,gbc);
        
        gbc = new GridBagConstraints();
        gbc.gridx = 7;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        center.add(showPass,gbc);
        showPass.addItemListener(this);
        
        panel.add(center,BorderLayout.CENTER);
        panel.add(connection,BorderLayout.SOUTH);
        connection.addActionListener(this);
        return panel;
    }
  
    public JPanel makeSQLIssuerPanel() {
        JPanel panel = new JPanel(new BorderLayout(),false);
        JPanel center = new JPanel(new GridLayout(2,1),false);
        JPanel sqlPanel = new JPanel(new BorderLayout(),false);
        InputMap iMap = sqlArea.getInputMap();
        ActionMap aMap = sqlArea.getActionMap();
        iMap.put(KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, InputEvent.CTRL_DOWN_MASK), "ctrlEnter");
        aMap.put("ctrlEnter", new AbstractAction() {
            @Override
            public void actionPerformed(ActionEvent e) {
                processSQL();
            }
        });
        sqlScroller = new JScrollPane(sqlArea,JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
        sqlPanel.add(sqlLabel,BorderLayout.NORTH);
        sqlPanel.add(sqlScroller,BorderLayout.CENTER);
        JPanel resultPanel = new JPanel(new BorderLayout(),false);
        resultScroller = new JScrollPane(resultArea,JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
        resultPanel.add(resultLabel,BorderLayout.NORTH);
        resultPanel.add(resultScroller,BorderLayout.CENTER);
        center.add(sqlPanel);
        center.add(resultPanel);
        panel.add(center,BorderLayout.CENTER);
        panel.add(issue,BorderLayout.SOUTH);
        issue.addActionListener(this);
        sqlArea.setText("USE " + properties.get("last.database") + ";\nSHOW TABLES;\n");
        return panel;

    }
    
    /** 
     * 
     * @param sql The query to execute.
     * @return true if no error
     */
    public boolean issueSQL(String sql) {
        MySQL mysql = ops.getMySQL();
        resultArea.setText("");
        ResultSet rs = null;
        if (sql.toLowerCase().startsWith("use")) {
            properties.set("last.database",sql.substring(4));
        }
        if (sql.toLowerCase().startsWith("describe") ||
            sql.toLowerCase().startsWith("select ") || 
            sql.toLowerCase().startsWith("show ")
           ) 
        {
            rs = mysql.query(sql,debug);
        } else {
            mysql.issue(sql,debug);
        }
        if (mysql.getException() != null) {
            resultArea.setText(mysql.getException().toString());
            return false;
        } else if (rs != null) {
            List<List<String>> rows = mysql.getRows(sql,true);
            List<String> row;
            for(int i = 0; i < rows.size();i++) {
                row = rows.get(i);
                for(int j = 0; j < row.size() - 1;j++) {
                    resultArea.append(row.get(j) + ",");
                }
                resultArea.append(row.get(row.size() - 1));
                resultArea.append("\n");
                resultArea.setCaretPosition(0);
            }
        }
        return true;
    }
    
    public void processSQL() {
        String sql = sqlArea.getText().trim();
        if (sql.contains(";")) {
            List<String> queries = StringTool.explode(sql,';');
            for(int i = 0; i < queries.size();i++) {
                if (!queries.get(i).trim().equals("")) issueSQL(queries.get(i).trim());
            }
        } else {
            issueSQL(sql);
        }
    }
    
    public void refreshDatabases() {
        databases.removeAllItems();
        List<String> dbs = ops.getDatabases();
        for(int i = 0; i < dbs.size();i++) {
            databases.addItem(dbs.get(i));
        }
    }
    
    
    public void refreshUsers() {
        users.removeAllItems();
        userList = ops.getMySQLUsersList();
        for(int i = 0; i < userList.size();i++) {
            users.addItem(userList.get(i).toString());
        }
    }
    
    public void removeUpdate(DocumentEvent e) {
//        if (e.getDocument() == dbName.getDocument()) {
//            dot.setEnabled(!dbName.getText().equals(""));
//        } else {
        setProperties();
//        }
    }
    
    public void setProperties() {
        properties.set("host",host.getText());
        properties.set("port",port.getText());
        properties.set("user",user.getText());
    }
    
    public void setSQLPanelEnabled(boolean state) {
        sqlLabel.setEnabled(state);
        sqlScroller.setEnabled(state);
        sqlArea.setEnabled(state);
        resultLabel.setEnabled(state);
        resultScroller.setEnabled(state);
        resultArea.setEnabled(state);
        issue.setEnabled(state);
    }
    
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() instanceof JTabbedPane) {
            JTabbedPane tabbedPane = (JTabbedPane) e.getSource();
            int selectedIndex = tabbedPane.getSelectedIndex();
        
            if (selectedIndex == 1) {
                refreshDatabases();
                refreshUsers();
            }
        } else if (e.getSource() == databases) {
            System.err.println("Databases: " + ((JComboBox)e.getSource()).getSelectedItem());
        }
    }
    
    public void windowClosing(WindowEvent e) {
        System.out.println("Frame: " + this.getSize());
    }

}
