package ca.tecreations.components;

import ca.tecreations.ProjectPath;
import ca.tecreations.Properties;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;

/**
 *
 * @author Tim
 */
public class YesNoDialog extends JDialog implements ActionListener {
    TFrame tframe;
    Properties properties;
    JLabel question;
    boolean isYes = false;
    JButton yes = new JButton("Yes");
    JButton no = new JButton("No");
    
    public YesNoDialog(TFrame tframe, String question) {
        this.question = new JLabel(question);
        this.tframe = tframe;
        this.properties = tframe.getProperties();
        setTitle(question);
        setupGUI();
        pack();
        setLocationRelativeTo(tframe);
        setModal(true);
        setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == yes) {
            isYes = true;
        } else if (e.getSource() == no) {
            isYes = false;
        }
        setVisible(false);
    }
    
    public boolean isYes() { 
        return isYes; 
    }
 
    public void setupGUI() {
        JPanel holder = new JPanel();
        holder.setLayout(new GridLayout(3,1));
        holder.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        holder.add(question);
        JPanel buttons = new JPanel(new FlowLayout());
        buttons.add(yes);
        buttons.add(no);
        holder.add(buttons);
        yes.addActionListener(this);
        no.addActionListener(this);
        add(holder,BorderLayout.CENTER);
    }
 
    public static void main(String[] args) {
        YesNoDialog dialog = new YesNoDialog(new TFrame(ProjectPath.instance.getPropertiesPath() + "TFrame.properties","TFrame"),"Yes or no?");
        System.out.println("dialog.isYes: " + dialog.isYes());
    }
    
}
