package ca.tecreations.apps._data;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.util.List;

public class FileListTransferable implements Transferable {

    protected static final DataFlavor listFlavor =
            new DataFlavor(List.class, "A List Of String Items (Typically, a List<FileNames,Wrapped or not.>");

    protected static final DataFlavor[] supportedFlavors = {
            listFlavor
    };
 
    private final List<String> list;

    public FileListTransferable(List<String> list) {
        this.list = list;
    }
    
    public static DataFlavor getListFlavor() { return listFlavor; }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return supportedFlavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {

        if (flavor.equals(listFlavor)) return true;
        return false;
    }

    @Override
    public Object getTransferData(DataFlavor flavor)
            throws UnsupportedFlavorException {

        if (flavor.equals(listFlavor)) {
            return list;
        } else {
            throw new UnsupportedFlavorException(flavor);
        }
    }
}