package ca.tecreations;

import java.util.ArrayList;
import java.util.List; 

/**
 *
 * @author tim
 */
public final class FindInProjects {
    int item = 0;
    public List<String> output = new ArrayList<>();
    
    String needle;
    
    public static boolean debug = false;
    public static boolean trace = true;
    
    // we conform to lowercase for needle and haystack
    
    public FindInProjects(String needle) {
        this.needle = needle.toLowerCase();
        System.out.println("Searching for: " + needle);
//        if (TecData.TSPC != null) TecData.TSPC.out("FindInComputer(): Searching for: " + needle);
        String projectsHome = ProjectPath.getProjectsHome();
        process(projectsHome);
        System.out.println("Done.");
    }
    
    public void check(String path) {
        if (path.contains(needle)) {
            System.out.println(path);
        }
        if (new File(path).canRead()) {
            List<String> lines = new TextFile(path).getLines();
            String line;
            for(int i = 0; i < lines.size();i++) {
                line = lines.get(i);
                if (line.toLowerCase().contains(needle)) {
                    System.out.println(++item + ": " + path + " (" + (i+1) + ") : " + line);
                }
            }
        }
    }
    
    public boolean include(String filePath) {
        String xt;
        boolean including;
        File aFile = new File(filePath);
        including = false;
        xt = aFile.getExtension();
        switch (xt) {
            case "c":
            case "cpp":
            case "html":
            case "java":
            case "php":
            case "pl":
            case "properties":
            case "py":
            case "sh":
            case "sql":
            case "txt":
                including = true;
                break;
            default:
                including = false;
                break;
        }
        if (debug) System.out.println(filePath + " : Incl.: " + including);
        return including;
    }

    public static void main(String[] args) {
        String needle = "Set 'needle' to your search string...";
        needle = "needle";
        for(int i = 0; i < args.length;i++) {
            System.out.println(i + ": " + args[i]);
        }
        if (args.length > 1) {
            String argsString = "";
            for(int i = 0;i < args.length - 1;i++) {
                argsString += args[i] + " ";
            }
            argsString += args[args.length - 1];
            needle = StringTool.getUnwrapped(argsString);
        } else if (args.length == 1) {
            needle = args[0];
        } else if (args.length == 0) {
            System.out.println("Searching for hard coded: '" + needle + "'");
        }
        
        //if (debug) System.out.println("ProjectPath: " + pp.getProjectPath());
        //new FindInFiles(pp.getProjectPath(),needle); 
        new FindInProjects(needle); 
    }  
 
    public void process(String path) {
        Pair pair = new Pair(new File(path));
        List<File> files = pair.getFiles();
        List<File> dirs = pair.getDirs();
        for(int i = 0; i < files.size();i++) {
            String unwrapped = files.get(i).getUnwrapped();
            if (files.get(i).getUnwrapped().contains(needle)) {
                System.out.println(++item + ": " + files.get(i).getAbsolutePath() + " (" + (i+1) + ")");
            }
            if (include(unwrapped)) check(unwrapped);
        }
        for(int i = 0; i < dirs.size();i++) {
            if (dirs.get(i).getUnwrapped().contains(needle)) {
                System.out.println(++item + ": " + dirs.get(i).getAbsolutePath() + " (" + (i+1) + ")");
            }
            process(dirs.get(i).getAbsolutePath());
        }
    }   
}
