package ca.tecreations;

import java.util.ArrayList;
import java.util.List; 

/**
 *
 * @author tim
 */
public final class FindInProject {
    int item = 0;
    public List<String> output = new ArrayList<>();
    public static ProjectPath pp;
    
    String needle;
    
    public static boolean debug;
    public static boolean trace = true;
    
    // we conform to lowercase for needle and haystack
    
    public FindInProject(String projectPath, String needle,boolean debug) {
        this.needle = needle.toLowerCase();
        this.debug = debug;
        System.out.println("Searching for: " + needle);
//        if (TecData.tspc != null) TecData.tspc.out("FindInFiles(): Searching for: " + needle);
        if (projectPath.toLowerCase().contains(needle)) {
            System.out.println("ProjectPath contains: " + needle + " : " + ProjectPath.getProjectPath());
        }
        process(projectPath);
        System.out.println("Done.");
    }
    
    public void check(String path) {
        List<String> lines = new TextFile(path).getLines();
        String line;
        for(int i = 0; i < lines.size();i++) {
            line = lines.get(i);
            if (line.toLowerCase().indexOf(needle) != -1) {
                System.out.println(++item + ": " + path + " (" + (i+1) + ") : " + line);
            }
        }
    }
    
    public boolean include(String filePath) {
        String xt;
        boolean including;
        File aFile = new File(filePath);
        including = false;
        xt = aFile.getExtension();
        switch (xt) {
            case "c":
            case "cpp":
            case "html":
            case "java":
            case "php":
            case "pl":
            case "properties":
            case "py":
            case "sh":
            case "sql":
            case "txt":
                including = true;
                break;
            default:
                including = false;
                break;
        }
        if (debug) System.out.println(filePath + " : Incl.: " + including);
        return including;
    }

    public static void main(String[] args) {
        String needle = "Color";
        if (args.length == 1) {
            needle = args[0];
        } 
        boolean debug = false;
        new FindInProject(ProjectPath.getProjectPath(),needle,debug); 

        System.out.println("Processing is done.");
    } 
 
    public void process(String path) {
        Pair pair = new Pair(new File(path));
        List<File> dirs = pair.getDirs();
        List<File> files = pair.getFiles();
        for(int i = 0; i < files.size();i++) {
            String unwrapped = files.get(i).getUnwrapped();
            if (unwrapped.toLowerCase().contains(needle.toLowerCase())) {
                System.out.println(++item + ": " + files.get(i).getAbsolutePath() + " (" + (i+1) + ")");
            }
            if (include(unwrapped)) check(unwrapped);
        }
        for(int i = 0; i < dirs.size();i++) {
            if (dirs.get(i).getUnwrapped().contains(needle)) {
                System.out.println(++item + ": " + dirs.get(i).getAbsolutePath() + " (" + (i+1) + ")");
            }
            process(dirs.get(i).getAbsolutePath());
        }
    }   
}
 