package ca.tecreations.net;

import ca.tecreations.Drag;
import ca.tecreations.ExceptionHandler;
import ca.tecreations.File;
import ca.tecreations.ImageTool;
import ca.tecreations.Mouse;
import ca.tecreations.Pair;
import ca.tecreations.Platform;
import ca.tecreations.ProjectPath;
import ca.tecreations.StringTool;
import ca.tecreations.SystemToken;
import ca.tecreations.TecData;
import ca.tecreations.TextFile;
import ca.tecreations.TypeToType;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author tim
 */
class ClientHandler implements Runnable {

    public static final String SN = ClientHandler.class.getSimpleName();
    public static Server server;
    private Socket clientSocket;
    private String ip;
    private String host;

    OutputStream out;
    InputStream in;

    BufferedReader inBR = null;
    InputStreamReader inISR = null;
    PrintWriter outPW = null;
 
    boolean debug = true;
    boolean verbose = false;
    boolean trace = false;
    
    public ClientHandler(Server server, Socket socket, String ip, String host, boolean debug) {
        this.server = server;
        this.clientSocket = socket;
        this.ip = ip;
        this.host = host;
        this.debug = debug;
        textOpen(SN + "()"); 
    }

    public static void ban(String ip) {
        TextFile blacklist = new TextFile(ProjectPath.getNetConfigPath() + "clients.blacklist");
        blacklist.add(ip);
    } 

    public void binaryCloseIn() {
        try {
            in.close();
        } catch (IOException ioe) {
            System.err.println(SN + ".binaryCloseIn: " + ioe);
        }
    }

    public void binaryCloseOut() {
        try {
            out.close();
        } catch (IOException ioe) {
            System.err.println(SN + ".binaryCloseOut: " + ioe);
        }
    }

    public void binaryOpenIn(String caller) {
        try {
            in = clientSocket.getInputStream();
        } catch (IOException ioe) {
            ExceptionHandler.handleIO(SN + ".binaryOpenIn(" + caller + ")", "opening in", ioe, false);
        }
    }

    public void binaryOpenOut(String caller) {
        try {
            out = clientSocket.getOutputStream();
        } catch (IOException ioe) {
            ExceptionHandler.handleIO(SN + ".binaryOpenOut(" + caller + ")", "opening out", ioe, false);
        }
    }

    public void capture() {
        ImageTool.saveImage(Platform.getScreenCapture(),Server.SCREENSHOT_PATH);
    }
    
    public String delete(String path) {
        File target = new File(path);
        target.delete(debug);
        return TNData.DELETE + " " + wrap(path) + " exists: " + (target.exists() + "").toUpperCase();
    }

    public String wrap(String s) {
        return StringTool.getDoubleQuoted(s);
    }

    public List<String> getAll(String path) {
        List<String> rows = new ArrayList<>();
        Pair p = new Pair(new File(path));
        List<File> dirs = p.getDirs();
        List<File> files = p.getFiles();
        System.out.println(SN + ".getAll: dirs: " + dirs);
        System.out.println(SN + ".getAll: files: " + files);
        for (int i = 0; i < dirs.size(); i++) {
            rows.add(getDetail(dirs.get(i)));
        }
        for (int i = 0; i < files.size(); i++) {
            rows.add(getDetail(files.get(i)));
        }
        return rows;
    }

    private String getDetail(File target) {
        String result = target.getAbsolutePath() + ",";
        if (target.isDirectory()) {
            result += "GET" + ","; // signify we aren't getting the directory size
        } else {
            result += target.length() + ",";
        }
        result += target.getAppPermissionsString() + ",";
        result += target.lastModified() + ",";
        if (File.separator.equals("/")) {
            result += target.getPOSIXAttributesCSV();
        } else {
            result += target.getDOSAttributesString();
        }
        return result;
    }

    public String getDirSize(String path) {
        return TNData.GET_DIR_SIZE + " " + StringTool.getDoubleQuoted(path) + " " + new ca.tecreations.File(path).getSize();
    }

    public List<String> getDirSizes(String path) {
        List<String> results = new ArrayList<>();
        List<ca.tecreations.File> dirs = new Pair(path).getDirs();
        for (int i = 0; i < dirs.size(); i++) {
            String response = getDirSize(dirs.get(i).getAbsolutePath());
            results.add(TNData.GET_DIR_SIZES + " " + dirs.get(i).getAbsolutePath() + " " + response.substring(response.lastIndexOf(" ") + 1));
        }
        return results;
    }

    public List<String> getDirs(String path) {
        Pair pair = new Pair(path);
        return TypeToType.listFileToListString(pair.getDirs());
    }
    
    public void getFile(String src) {
        binaryOpenOut("getFile");
        long total = 0;
        int bytesRead;
        byte buffer[] = new byte[TNData.SIXTY_GEES];
        ca.tecreations.File srcFile = new ca.tecreations.File(src);
        FileInputStream fis = new ca.tecreations.File(src).getFileInputStream();
        if (fis != null) {
            try {
                boolean done = false;
                while (!done) {
                    bytesRead = fis.read(buffer, 0, buffer.length);
                    if (bytesRead == -1) {
                        done = true;
                    } else {
                        out.write(buffer, 0, bytesRead);
                        out.flush();
                        total += bytesRead;
                    }
                    if (total == srcFile.length()) {
                        done = true;
                    }
                    server.doLogAction(SN + ".getFile: bytesRead: " + bytesRead + " Total: " + total);
                }
                //out.close(); // from signed-SSLServer
            } catch (IOException ioe) {
                System.err.println(SN + ".getFile: reading and writing: " + ioe);
            } finally {
                try {
                    fis.close();
                    //socket.close(); // from signed-SSLServer
                } catch (IOException ioe) {
                    ExceptionHandler.handleIO(SN + ".getFile", "closing input", ioe, false);
                }
            }
        } else {
            System.err.println(SN + ".getFile: failure: fis: " + fis);
        }
        textOpen("getFile");
        reply(TNData.OK);
    }

    public static List<String> getFileLines(String path) {
        return new TextFile(path).getLines();
    }

    public List<String> getFiles(String path) {
        Pair pair = new Pair(path);
        return TypeToType.listFileToListString(pair.getFiles());
    }
    
    
    
    public List<String> getPOSIXGroups() {
        List<String> result = new ArrayList<>();
        TextFile groups = new TextFile("/etc/group");
        List<String> lines = groups.getLines();
        String line;
        for (int i = 0; i < lines.size(); i++) {
            line = lines.get(i);
            result.add(line.substring(0, line.indexOf(":")));
        }
        return result;
    }

    public String getPOSIXUser(String path) {
        return new File(path).getPOSIXUser();
    }

    public List<String> getPOSIXUsers() {
        List<String> result = new ArrayList<>();
        TextFile file = new TextFile("/etc/passwd");
        List<String> lines = file.getLines();
        String line;
        String user;
        for (int i = 0; i < lines.size(); i++) {
            line = lines.get(i);
            user = line.substring(0, line.indexOf(":"));
            result.add(user);
        }
        return result;
    }

    public static String getUsableSpace(String path) {
        return new File(path).getUsableSpace() + "";
    }

    public String listItem(String path) {
        File target = new File(path);
        String result = target.getAbsolutePath() + ",";
        if (target.isDirectory()) {
            result += getDirSize(path);
        } else {
            result += path.length() + ",";
        }
        result += target.getAppPermissionsString() + ",";
        result += target.lastModified() + ",";
        if (ca.tecreations.File.separator.equals("/")) {
            result += target.getPOSIXAttributesCSV();
        } else {
            result += target.getDOSAttributesString();
        }
        return result;
    }

    public List<String> listRoots() {
        List<String> roots = new ArrayList<>();
        File[] rootFiles = File.tecListRoots();
        for (int i = 0; i < rootFiles.length; i++) {
            roots.add(rootFiles[i].getAbsolutePath());
        }
        return roots;
    }

    public static void main(String[] args) {
        List<String> lines = getFileLines("c:\\audio.log");
        for (int i = 0; i < lines.size(); i++) {
            System.out.println(i + ": " + lines.get(i));
        }
    }

    public String mkdirs(String path) {
        File file = new File(path);
        file.mkdirs();
        return TNData.MKDIRS + " " + path + " " + (file.exists() + "").toUpperCase();
    }

    public synchronized void process(String line) {
        String op;
        String args = "";
        if (line.contains(" ")) {
            op = line.substring(0, line.indexOf(" "));
            args = line.substring(line.indexOf(" ") + 1).trim();
        } else {
            op = line;
        }

        System.out.println(ip + ":" + host + ": got: " + op + " args: " + args);


        String classPath = "";
        String fqcn = "";
        String appArgs = "";
        String src = null;
        String dst = null;
        String remainder = "";
        if (op.contains("_JAVA")) {
            int item1Stop;
            int item2Start;
            int item2Stop;
            item1Stop = args.indexOf(TecData.TEC_SEP);
            item2Start = item1Stop + TecData.TEC_SEP.length();
            item2Stop = args.indexOf(TecData.TEC_SEP, item2Start + 1);
            classPath = args.substring(0, item1Stop);
            fqcn = args.substring(item2Start, item2Stop);
            appArgs = args.substring(item2Stop + TecData.TEC_SEP.length());
            if (debug && verbose) {
                System.out.println(SN + ".process: classpath : " + classPath);
                System.out.println(SN + ".process: fqcn      : " + fqcn);
                System.out.println(SN + ".process: appArgs   : " + appArgs);
            }
        } else {
            if (args.startsWith("\"")) {
                src = SharedCode.getFirstQuoted(args);
                remainder = args.substring(src.length()).trim();
                if (remainder.startsWith("\"")) {
                    dst = SharedCode.getFirstQuoted(remainder);
                    remainder = remainder.substring(dst.length()).trim();
                }
            } else {
                remainder = args;
            }
        }
        if (debug && verbose) {
            System.out.println(SN + ".process: src      : " + src);
            System.out.println(SN + ".process: dst      : " + dst);
            System.out.println(SN + ".process: remainder: " + remainder);
        }
        if (op.equals(TNData.BAN)) {
            ban(args);
            reply(op + " BANNED " + args);
        } else if (op.equals(TNData.DO_PLATFORM_QUERY)) {
            List<String> lines = new ArrayList<>();
            lines.add(System.getProperty("os.name"));
            lines.add(System.getProperty("file.separator"));
            lines.add(StringTool.escape(System.getProperty("line.separator")));
            lines.add(System.getProperty("path.separator"));
            if (!Platform.isHeadless()) lines.add(Server.SCREENSHOT_PATH);
            else lines.add(null);
            replyStrings(lines); 
        } else if (op.equals(TNData.EXEC_FOR_OUTPUT)) {
            List<SystemToken> tokens = TecData.st.runForOutput(args, true);
            List<String> lines = TypeToType.toListString(tokens);
            replyStrings(lines);
        } else if (op.equals(TNData.EXEC_FOR_OUTPUT_JAVA)) {
            List<SystemToken> tokens = TecData.st.runForOutputJava(classPath, fqcn, appArgs, true);
            replyTokens(tokens);
        } else if (op.equals(TNData.EXEC_SPAWN)) {
            TecData.st.spawn(args, true); // here, args == entire command string
            reply("EXECUTED");
        } else if (op.equals(TNData.EXEC_SPAWN_JAVA)) {
            TecData.st.spawnJava(classPath, fqcn, appArgs, debug); // here, args gets parsed for a Java entity and arguments
            reply("EXECUTED");
        } else if (op.equals(TNData.EXISTS)) {
            reply(op + " " + src + " " + (new File(src).exists() + "").toUpperCase());
        } else if (op.equals(TNData.GET)) {
            reply(TNData.OK);
            getFile(src);
        } else if (op.equals(TNData.GET_ALL)) {
            replyStrings(getAll(src));
        } else if (op.equals(TNData.GET_DIR_SIZE)) {
            reply(getDirSize(args));
        } else if (op.equals(TNData.GET_DIR_SIZES)) {
            replyStrings(getDirSizes(args));
        } else if (op.equals(TNData.GET_DIRS)) {
            replyStrings(getDirs(args));
        } else if (op.equals(TNData.GET_DOS_FILE_ATTRIBUTES)) {
            if (Platform.isWin()) {
                reply(op + " " + src + " " + new File(src).getDOSAttributesString());
            } else {
                reply(op + " " + src + " WRONG_PLATFORM");
            }
        } else if (op.equals(TNData.GET_FILE_LINES)) {
            replyStrings(getFileLines(src));
        } else if (op.equals(TNData.GET_FILE_SIZE)) {
            reply(op + " " + args + " " + new ca.tecreations.File(src).length());
        } else if (op.equals(TNData.GET_FILES)) {
            replyStrings(getFiles(args));
        } else if (op.equals(TNData.GET_POSIX_FILE_PERMISSIONS)) {
            if (!Platform.isWin()) {
                reply(op + " " + src + " " + new File(src).getPOSIXFilePermissions());
            } else {
                reply(op + " " + src + " WRONG_PLATFORM");
            }
        } else if (op.equals(TNData.GET_POSIX_GROUP)) {
            if (!Platform.isWin()) {
                reply(op + " " + src + " " + new File(src).getPOSIXGroup());
            } else {
                reply(op + " " + src + " WRONG_PLATFORM");
            }
        } else if (op.equals(TNData.GET_POSIX_GROUPS)) {
            if (!Platform.isWin()) {
                replyStrings(getPOSIXGroups()); 
            } else {
                reply(op + " " + src + " WRONG_PLATFORM");  
            }
        } else if (op.equals(TNData.GET_POSIX_USER)) { 
            if (!Platform.isWin()) {
                reply(op + " " + src + " " + getPOSIXUser(src));
            } else {
                reply(op + " " + src + " WRONG_PLATFORM: os.name: " + Platform.getOSName());
            }
        } else if (op.equals(TNData.GET_POSIX_USERS)) {
            if (!Platform.isWin()) {
                replyStrings(getPOSIXUsers());
            } else {
                reply(op + " " + src + " WRONG_PLATFORM");
            }
        } else if (op.equals(TNData.GET_USABLE_SPACE)) {
            reply(getUsableSpace(src));
        } else if (op.equals(TNData.HAS_JAVA)) {
            if (new File(src).isFile()) {
                reply(op + " " + src + " " + File.hasJava(src));
            } else {
                if (!remainder.equals("")) {
                    String b = remainder.toUpperCase();
                    Boolean recurse;
                    if (b.equals("1") || b.equals("TRUE")) {
                        recurse = true;
                    } else {
                        recurse = false;
                    }
                    reply(op + " " + src + " " + File.hasJava(src, recurse));
                } else {
                    reply(op + " " + src + " " + File.hasJava(src, false)); // This path makes it so if you only want to know about
                    // the current directory, you don't need to specify false.
                    // If you do specify anything other than blank or not 1|TRUE
                    // it defaults to false for recursing sub directories.
                }
            }
        } else if (op.equals(TNData.IS_DIR)) {
            reply(op + " " + src + " " + new File(src).isDirectory());
        } else if (op.equals(TNData.IS_FILE)) {
            reply(op + " " + src + " " + new File(src).isFile());
        } else if (op.equals(TNData.LIST_DIRS)) {
            replyStrings(File.listDirs(args));
        } else if (op.equals(TNData.LIST_FILES)) {
            replyStrings(File.listFiles(args));
        } else if (op.equals(TNData.LIST_ITEM)) {
            reply(listItem(src));
        } else if (op.equals(TNData.LIST_ROOTS)) {
            replyStrings(listRoots());
        } else if (op.equals(TNData.MKDIRS)) {
            reply(mkdirs(src));
        } else if (op.equals(TNData.PUT)) {
            reply(TNData.OK);
            putFile(src, Long.parseLong(remainder));
        } else if (op.equals(TNData.RENAME)) {
            reply(rename(src, dst));
        } else if (op.equals(TNData.SEND_MOUSE_CLICK)) {
            Mouse mouse = Mouse.fromString(args);
            Platform.robot.mouseMove(mouse.getComponentX(),mouse.getComponentY());
            Platform.robot.mousePress(mouse.getDownMask()); 
            Platform.robot.mouseRelease(mouse.getDownMask());
        } else if (op.equals(TNData.SEND_MOUSE_DOWN)) {
            Mouse mouse = Mouse.fromString(args);
            Platform.robot.mouseMove(mouse.getComponentX(),mouse.getComponentY());
            Platform.robot.mousePress(mouse.getDownMask());
            reply("DONE");
        } else if (op.equals(TNData.SEND_MOUSE_DRAG)) {
            Drag drag = Drag.fromString(args);
            Mouse start = drag.getStart();
            Mouse stop = drag.getStop();
            Platform.robot.mouseMove(start.getComponentX(),start.getComponentY()); 
            Platform.robot.mousePress(start.getDownMask());
            Platform.robot.mouseMove(stop.getComponentX(),stop.getComponentY());
            Platform.robot.mouseRelease(start.getDownMask());
            reply("DONE");
        } else if (op.equals(TNData.SEND_MOUSE_MOVE)) {
            String xString = args.substring(0,args.indexOf(","));
            String yString = args.substring(args.indexOf(",") + 1);
            int x = Integer.parseInt(xString);
            int y = Integer.parseInt(yString);
            Platform.robot.mouseMove(x,y);
            reply("MOVED");
        } else if (op.equals(TNData.SEND_MOUSE_UP)) {
            Mouse mouse = Mouse.fromString(args);
            Platform.robot.mouseMove(mouse.getComponentX(),mouse.getComponentY());
            Platform.robot.mousePress(mouse.getUpMask());
            reply("DONE");
        } else if (op.equals(TNData.SET_DOS_FILE_ATTRIBUTES)) {
            if (Platform.isWin()) {
                File srcFile = new File(src);
                srcFile.setDOSFileAttributes(remainder);
                reply(op + " " + src + " " + srcFile.getDOSFileAttributes());
            } else {
                reply(op + " " + src + " WRONG_PLATFORM");
            }
        } else if (op.equals(TNData.SET_EXECUTABLE)) {
            File srcFile = new File(src);
            srcFile.setExecutable(Boolean.parseBoolean(remainder));
            reply(op + " " + src + " " + (srcFile.canExecute() + "").toUpperCase());
        } else if (op.equals(TNData.SET_POSIX_FILE_PERMISSIONS)) {
            if (!Platform.isWin()) {
                File srcFile = new File(src);
                srcFile.setPOSIXFilePermissions(remainder);
                reply(op + " " + src + " " + srcFile.getPOSIXFilePermissions()); 
            } else {
                reply(op + " " + src + " WRONG_PLATFORM");
            } 
        } else if (op.equals(TNData.SET_POSIX_GROUP)) {
            if (!Platform.isWin()) {
                File srcFile = new File(src);
                srcFile.setPOSIXGroup(remainder);
                reply(op + " " + src + " " + srcFile.getPOSIXGroup());
            } else {
                reply(op + " " + src + " WRONG_PLATFORM");
            } 
        } else if (op.equals(TNData.SET_POSIX_USER)) {
            if (!Platform.isWin()) {
                File srcFile = new File(src);
                srcFile.setPOSIXUser(remainder);
                reply(op + " " + wrap(src) + " " + srcFile.getPOSIXUser());
            } else {
                reply(op + " " + src + " WRONG_PLATFORM");
            }
        } else if (op.equals(TNData.SET_READABLE)) {
            File srcFile = new File(src);
            srcFile.setReadable(Boolean.parseBoolean(remainder));
            reply(op + " " + src + " " + (srcFile.canRead() + "").toUpperCase());
        } else if (op.equals(TNData.SET_WRITABLE)) {
            File srcFile = new File(src);
            srcFile.setWritable(Boolean.parseBoolean(remainder));
            reply(op + " " + src + " " + (srcFile.canWrite() + "").toUpperCase());
        } else if (op.equals(TNData.SHUTDOWN)) {
            reply("EXITING");
            Platform.sleep(250);
            server.shutdown();
        } else if (op.equals(TNData.TAKE_SCREENSHOT)) {
            capture();
            reply("CAPTURED");
        } else {
            System.err.println("Unknown command: " + line);
        }
    }

    public void putFile(String dst, long length) {
        binaryOpenIn("putFile");
        ca.tecreations.File deepest = new ca.tecreations.File(dst).getDeepestDirectoryFile();
        deepest.mkdirs();
        OutputStream os = null;
        try {
            os = Files.newOutputStream(new ca.tecreations.File(dst).toPath());
        } catch (IOException ioe) {
            System.err.println(SN + ".putFile: opening output: " + ioe);
        }
        if (os != null) {
            long total = 0;
            byte[] buffer = null;
            if ((int) length < 60000) {
                buffer = new byte[(int) length];
            } else {
                buffer = new byte[TNData.SIXTY_GEES];
            }
            int bytesRead = 0;
            try {
                boolean done = false;
                while (!done) {
                    bytesRead = in.read(buffer);
                    if (bytesRead == -1) {
                        done = true;
                    } else {
                        os.write(buffer, 0, bytesRead);
                        os.flush();
                        total += bytesRead;
                    }
                    if (total == length) {
                        done = true;
                    }
                    server.doLogAction(SN + ".putFile: bytesRead: " + bytesRead + " Total: " + total);
                }
            } catch (IOException ioe) {
                ExceptionHandler.handleIO(SN + ".putFile", "copying", ioe, false);
            }
            server.doLogAction(SN + ".putFile: bytesRead: " + bytesRead + " Total: " + total);
        }
        textOpen("putFile");
        reply(TNData.OK);
    }

    public String rename(String oldName, String newName) {
        File oldFile = new File(oldName);
        File newFile = new File(newName);
        oldFile.renameTo(newFile);
        return TNData.RENAME + " " + oldName + " --> " + newName + " exists: " + newFile.exists();
    }

    public void reply(String line) {
        outPW.println(line);
        outPW.println("\0");
    }

    public void replyStrings(List<String> lines) {
        for (int i = 0; i < lines.size(); i++) {
            outPW.println(lines.get(i));
        }
        outPW.println("\0");
    }

    public void replyTokens(List<SystemToken> tokens) {
        for (int i = 0; i < tokens.size(); i++) {
            outPW.println(tokens.get(i).getRawWithType());
        }
    }

    @Override
    public void run() {
        try (
                BufferedReader in = new BufferedReader(new InputStreamReader(clientSocket.getInputStream())); PrintWriter out = new PrintWriter(clientSocket.getOutputStream(), true);) {
            String inputLine;
            while ((inputLine = in.readLine()) != null) {
                //    System.out.println("Received from client " + clientSocket.getInetAddress() + ": " + inputLine);
                //out.println("Server received: " + inputLine); // Echo back
                process(inputLine);

            }
        } catch (IOException e) {
            System.err.println("Error handling client " + ip + ":" + host + " : " + e.getMessage());
        } finally {
            try {
                clientSocket.close();
                System.out.println("Client disconnected: " + ip + ":" + host);
            } catch (IOException e) {
                System.err.println("Error closing client socket: " + e.getMessage());
            }
        }
    }

    public void setDOSFileAttributes(String path, String attributes) {
        new File(path).setDOSFileAttributes(attributes);
        reply(TNData.SET_DOS_FILE_ATTRIBUTES + " " + path + " " + new File(path).getDOSFileAttributes());
    }

    public void setPOSIXGroup(String path, String group) {
        new File(path).setPOSIXGroup(group);
        reply(TNData.SET_POSIX_GROUP + " " + path + " " + new File(path).getPOSIXGroup());
    }

    public void setPOSIXUser(String path, String user) {
        new File(path).setPOSIXUser(user);
        reply(TNData.SET_POSIX_USER + " " + path + " " + new File(path).getPOSIXUser());
    }

    public void setPOSIXFilePermissions(String path, String permissions) {
        File file = new File(path);
        file.setPOSIXFilePermissions(permissions);
        reply(TNData.SET_POSIX_FILE_PERMISSIONS + " " + path + " " + file.getPOSIXFilePermissions());
    }

    public void textClose() {
        outPW.close();
        try {
            inBR.close();
        } catch (IOException ioe) {
            ExceptionHandler.handleIO(SN + ".textClose", "closing inBR", ioe, false);
        }
        try {
            inISR.close();
        } catch (IOException ioe) {
            ExceptionHandler.handleIO(SN + ".textClose", "closing inISR", ioe, false);
        }
    }

    public void textOpen(String caller) {
        try {
            inISR = new InputStreamReader(clientSocket.getInputStream());
        } catch (IOException ioe) {
            ExceptionHandler.handleIO(SN + ".textOpen(" + caller + ")", "opening inISR", ioe, false);
        }
        inBR = new BufferedReader(inISR);
        try {
            outPW = new PrintWriter(clientSocket.getOutputStream(), true);
        } catch (IOException ioe) {
            ExceptionHandler.handleIO(SN + ".textOpen(" + caller + ")", "opening outPW", ioe, false);
        }
    }

}
