package ca.tecreations.lang.java;

import ca.tecreations.File;
import ca.tecreations.JarReader;
import ca.tecreations.StringTool;

import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
/** 
 *
 * @author Tim
 */
public class AllJarsEqualSize {
    JarReader reader;
    boolean result = true;
    boolean debug = false;
    
    public AllJarsEqualSize(File jarFile, String outDir) {
        outDir = StringTool.getUnwrapped(outDir);
        if (!outDir.endsWith(File.separator)) outDir += File.separator;
        reader = new JarReader(jarFile.getAbsolutePath());
        List<String> names = reader.getJarsNames();
        if (debug) System.out.println("JarNames: " + names);
        List<JarEntry> entries = reader.getJarsEntries();
        if (debug) System.out.println("JarEntries: " + entries);
        for(int i = 0; i < entries.size();i++) {
            String nameAndPath = entries.get(i).getName().substring(5);
            long length = new File(outDir + nameAndPath).length();
            long size = entries.get(i).getSize();
            if (debug) System.out.println("Checking: " + nameAndPath + " File.length(): " + length + " Jar.size(): " + size);
            if (length != size) {
                result = false;
                break;
            }
        }
    }
    
    public List<String> getJarNames(String absPath) {
        //so, for tecreations, we do like jarsDirectory == absPath?
        List<String> names = new ArrayList<>();
        File[] entries = new File(absPath).tecListFiles();
        if (entries != null) {
            for(int i = 0; i < entries.length;i++) {
                if (entries[i].isDirectory()) {
                    List<String> subs = getJarNames(entries[i].getAbsolutePath());
                    for(int j = 0; j < subs.size();j++) {
                        names.add(subs.get(j));
                    }
                } else {
                    // we assume these are .jars within the /jars/ directory, or one of its' subdirs
                    // if the entries' name is test.txt, we include it.
                    names.add(entries[i].getFileNameOnly());
                    // duplicates will be added, so please keep your jars directory clean (ie: containing .jars only)
                    // REMEMBER GIGO, garbage in, garbage out
                }
            }
        }
        return names;
    }
    
    public boolean isTrue() {
        return result;
    }
    
}
