package ca.tecreations.db.mysql;

import ca.tecreations.Platform;

import java.util.ArrayList;
import java.util.List;
/**
 *
 * @author tim
 */
public class MySQL_Ops {
    static MySQL_Ops instance;
    static MySQL mysql;
    
    private MySQL_Ops() {
    }
     
    public MySQL_Ops(MySQL mysql) {
        this.mysql = mysql;
        instance = this;
    }
 
    public void createDatabase(String name,boolean debug) {
        mysql.issue("CREATE DATABASE " + name, false);
    }
    
    public void createDatabaseIfNotExists(String name,boolean debug) {
        mysql.issue("CREATE DATABASE IF NOT EXISTS " + name, debug);
    }

    public void createTable(String createStmt, boolean debug) {
        mysql.issue(createStmt,debug);
    }
    
    public void createUser(String name, String pass,boolean debug) {
        mysql.issue("CREATE USER '" + name + "' IDENTIFIED BY '" + pass + "'",debug);
    }
    
    public List<List<String>> describe(String name, boolean withHeader, boolean debug) {
        return mysql.getRows("DESCRIBE " + name, withHeader, debug);
    }
    
    public void dropDatabase(String name, boolean debug) {
        mysql.issue("DROP DATABASE " + name,debug);
    }
    
    public void dropTable(String name, boolean debug) {
        mysql.issue("DROP TABLE " + name,debug);
    }
    
    public void dropUserAtHost(String name, String host, boolean debug) {
        mysql.issue("DROP USER '" + name + "'@'" + host + "'",debug);
        flushPrivileges(debug);
    }
    
    public void flushPrivileges(boolean debug) {
        mysql.issue("FLUSH PRIVILEGES",debug);
    }

    public List<String> getDatabases() {
        String sql = "SHOW DATABASES";
        List<List<String>> rows = mysql.getRows(sql,false, false);
        List<String> databases = new ArrayList<>();
        for(int i = 0; i < rows.size();i++) {
            databases.add(rows.get(i).get(0));
        }
        return databases;
    }
    
    public String getHostIP(boolean debug) {
        String ip = mysql.get("SELECT SUBSTRING_INDEX(host,':',1) AS 'ip' FROM information_schema.processlist WHERE ID=connection_id()","ip",debug);
        return ip;
    }
    
    public static MySQL_Ops getInstance() {
        return instance;
    }
    
    public MySQL getMySQL() { return mysql; }
    
    public List<String> getMySQLUsers() {
        String sql = "SELECT user FROM mysql.user";
        List<List<String>> rows = mysql.getRows(sql,false,false);
        List<String> users = new ArrayList<>();
        for(int i = 0; i < rows.size();i++) {
            users.add(rows.get(i).get(0));
        }
        return users;
    }
    
    public List<MySQLUser> getMySQLUsersList() {
        String sql = "SELECT user,host FROM mysql.user";
        List<List<String>> rows = mysql.getRows(sql,false,false);
        List<MySQLUser> users = new ArrayList<>();
        for(int i = 0; i < rows.size();i++) {
            users.add(new MySQLUser(rows.get(i).get(0),rows.get(i).get(1)));
        }
        return users;
    }
    
    public List<String> getTables() {
        String sql = "SHOW TABLES";
        List<List<String>> rows = mysql.getRows(sql,false,false);
        List<String> tables = new ArrayList<>();
        for(int i = 0; i < rows.size();i++) {
            tables.add(rows.get(i).get(0));
        }
        return tables;
    }
    
    public void grantAllOnDBToUser(String dbAndPrivLevel,String user) {
        String sql = "GRANT ALL ON " + dbAndPrivLevel + " TO '" + user + "'";
        mysql.issue(sql,true);
        flushPrivileges(true);
    }
    
    public void grantAllOnDBAtHostIPToUser(String dbAndPrivLevel,String user) {
        String sql = "GRANT ALL ON " + dbAndPrivLevel + " TO '" + user + "'@'" + getHostIP(false) + "'";
        mysql.issue(sql,true);
        flushPrivileges(true);
    }
    
    public void grantMinimal(String dbAndPrivLevel, String user) {
        String sql = "GRANT SELECT, INSERT, DELETE, UPDATE ON " + dbAndPrivLevel;
        sql += ".* TO '" + user + "'";
        mysql.issue(sql,true);
        flushPrivileges(true);
    }
    
    public void grantWithOnDBToUser(String privLevel,String user) {
        String sql = "GRANT ALL ON " + privLevel + " TO '" + user + "' WITH GRANT OPTION";
        mysql.issue(sql,true);
        flushPrivileges(true);
    }
    
    public boolean isConnected() {
        if (mysql == null) return false;
        return mysql.isConnected();
    }
    
    public static void main(String[] args) {
    }
        
    public void makeTableFromSQL(String filename) {
        List<String> sqlLines = Platform.getFileLines(filename);
        String sql = "";
        for(int i = 0; i < sqlLines.size();i++) {
            sql += sqlLines.get(i);
        }
        mysql.issue(sql,true);
    }

    public static void print(List<List<String>> list) {
        List<String> row;
        for(int i = 0; i < list.size();i++) {
            row = list.get(i);
            for(int j = 0; j < row.size() - 1;j++) {
                System.out.print(row.get(j) + ",");
            }
            if (row.size() > 0) System.out.println(row.get(row.size() - 1));
        }
    }
    
    public void useDatabase(String name) {
        useDatabase(name,false);
    }
    
    public void useDatabase(String name,boolean debug) {
        mysql.issue("USE " + name,debug);
    }
    
}
