package ca.tecreations.net;

import ca.tecreations.*;
import ca.tecreations.components.ProgressDialog;
import ca.tecreations.components.event.ProgressListener;

import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.UnrecoverableKeyException;

import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;

/**
 *
 * @author tim 
 */ 
public class Client extends Thread {
    
    // @ReadOnly
    public static long instances = 1;
    
    private final long classNum; // authors/editors must set in constructor
                                 // -- unsure what happens with 'getInstance()'
    public static final String ENCRYPTED = "encrypted";
    public static final String UN_ENCRYPTED = "un-encrypted";
    public static final String SN = Client.class.getSimpleName();
    BufferedReader stdIn = new BufferedReader(new InputStreamReader(System.in));

    public Client instance;
    Properties properties;

    String host = "localhost";
    int port = 52820;

    boolean encrypt = false;
    Socket rawSocket;
    Socket tlsSocket;

    OutputStream out = null; // these two should be used for reading/writing binary
    InputStream in = null;

    PrintWriter outPW = null; // this should be for writing text to the server (op + args)

    BufferedReader inBR = null; // these should be for reading text from the server
    InputStreamReader inISR = null;

    KeyStore keyStore;
    char[] keyStorePass;
    KeyStore trustStore;

    //public static boolean timedOut = false;
    SSLContext sslContext;
    KeyManagerFactory keyMgrFact;
    TrustManagerFactory trustMgrFact;
    SSLSocketFactory fact;

    public boolean trace = false;
    public boolean debug = false;
    public boolean verbose = false;

    List<ProgressListener> progressListeners = new ArrayList<>();

    public String    serverOS = null;
    public String    fileSeparator = null;
    public Character fileSeparatorChar = null;
    public String    lineSeparator = null;
    public String    pathSeparator = null;
    public Character pathSeparatorChar = null;
    public String    serverScreenshotPath = null;
    
    public boolean running = true;

    MyMap map = new MyMap();
    String lastOp;

    public TextFile log = null;

    String clientScreenshotPath = "";
    
    public long jobTotal = 0L;
    public long jobRead = 0L;
    public int jobPercent = 0;
    public int oldJobPercent = 0;


    public Client(Client c) throws NoTLSConnectionException {
        this.properties = c.getClientProperties();
        classNum = instances++;
        
        // This is redundant as the same if block in Client(1) causes exit if true
        // @MarkedForDeletion
        if (properties.wasCreated()) {
            return; // unreachable
        }
        serverOS = c.getServerOS();
        fileSeparator = c.getFileSeparator();
        lineSeparator = c.getLineSeparator();
        pathSeparator = c.getPathSeparator();
        serverScreenshotPath = c.getServerScreenshotPath();
        clientScreenshotPath = ProjectPath.getTecImagesPath() + properties.get(PKIData.REMOTE_HOST) + "_screenshot.png";
        this.host = properties.get(PKIData.REMOTE_HOST);
        this.encrypt = c.getCommsType().equals(ENCRYPTED); // pulls the encryption flag from the "parent" Client instance
        
        // We assume you've decided to somehow store and retrieve the pass at this point.
        // At some point, this should be constructed to retrieve the pass from a secure manner, or just store and 
        // set make.secure to false, that's what I do for development. If you have paid employees or require ultra-high security,
        // you could enforce a password being entered for each access. To enforce a password each access, 
        // set make.secure to true in properties of client config for host.
        keyStorePass = properties.get(PKIData.REMOTE_KEYSTORE_PASSWORD).toCharArray(); // Note: This makes a String! // SECURITY RISK
        _finishInstantiation();
    }

    public Client(Properties properties, boolean encrypt, char[] ksp) throws NoTLSConnectionException {
        this.properties = properties;
        classNum = instances++;
        if (properties.wasCreated()) {
            createDefaultProperties(properties);
            System.out.println("Properties file created in: " + properties.getFilename());
            System.out.println("Configure properties and re-run.");
            System.exit(0);
        }
        clientScreenshotPath = ProjectPath.getTecImagesPath() + properties.get(PKIData.REMOTE_HOST) + "_screenshot.png";
        this.host = properties.get(PKIData.REMOTE_HOST);
        this.encrypt = encrypt;
        keyStorePass = ksp; // determine how to process KeyStorePass
        _finishInstantiation();
    }

    private void _finishInstantiation() throws NoTLSConnectionException {
        openSocket();
        textOpen(SN + "(" + classNum + ")");
        if (serverOS == null) {
            process(TNData.DO_PLATFORM_QUERY,"");
        }
    }

    //--------------------------------------------------------------------------
    // I'll try to use this separator when construction blocks are more than 
    // just a single block.
    //--------------------------------------------------------------------------
    
    public void binaryCloseIn() {
        try {
            in.close();
        } catch (IOException ioe) {
            ExceptionHandler.handleIO(SN + ".binaryCloseIn", "closing input", ioe, false);
        }
    }

    public void binaryCloseOut() {
        try {
            out.close();
        } catch (IOException ioe) {
            ExceptionHandler.handleIO(SN + ".binaryCloseOut", "closing output", ioe, false);
        }
    }

    public void binaryOpenIn(String caller) {
        try {
            in = getSocket().getInputStream();
        } catch (IOException e) {
            ExceptionHandler.handle(SN + ".binaryOpenIn(" + caller + ")", "opening input", e, false);
        }
    }

    public void binaryOpenOut(String caller) {
        try {
            out = getSocket().getOutputStream();
        } catch (IOException e) {
            ExceptionHandler.handle(SN + ".binaryOpenOut", "opening output", e, false);
        }
    }

    public static final void createDefaultProperties(ca.tecreations.Properties properties) {
        properties.setDelayWrite(true);
        properties.set(PKIData.DEBUG_SSL, "false");
        properties.set(PKIData.MAKE_SECURE, "true");
        String propsName = new ca.tecreations.File(properties.getFilename()).getName();
        String remoteHost = "localhost";
        int index = propsName.indexOf("_client");
        if (index > 0) {
            remoteHost = propsName.substring(0, index);
        }
        properties.set(PKIData.REMOTE_HOST, remoteHost);
        boolean isWin = Platform.isWin();
        String probableKeystore = ProjectPath.getUserSecurityPath() + "tecreations.jks"; 
        properties.set(PKIData.REMOTE_KEYSTORE, probableKeystore);
        properties.set(PKIData.REMOTE_KEYSTORE_PASSWORD, "prompt");
        properties.set(PKIData.REMOTE_PORT, 52820);
        properties.set(PKIData.REMOTE_TRUSTSTORE, probableKeystore);
        properties.write();
        System.out.println(SN + ".doInitialSetup: Configure properties and re-run: " + properties.getFilename());
    }

    public void delete(String path) {
        sendToServer(TNData.DELETE,wrap(path));
        System.out.println(readFromServer(TNData.DELETE));
    }
    
    // @Hidden
    // @HelpHide
    // @NoMultitaskingData
    // @ProvidesJobData
    // @ProvidesItemData
    public boolean does_________________getFile(long length, String dst) {
        binaryOpenIn("getFile");
        boolean successful = false;
        boolean allSuccessful = false;
        boolean failed = false;
        if (debug) {
            SharedCode.doLogAction(log, SN + ".getFile: EDT: " + javax.swing.SwingUtilities.isEventDispatchThread() + " Size: " + length + " -> " + dst);
        }
        int oldMegs = 0;
        for (int i = 0; i < progressListeners.size(); i++) {
            progressListeners.get(i).updateItem(0);
        }
        FileOutputStream fos = null;
        byte[] buffer = null;
        long remaining = length;
        if (length >= 60000) {
            buffer = new byte[60000];
        } else {
            buffer = new byte[(int) length];
        }
        long itemTotal = 0;
        int bytesRead;

        new File(dst).getParentFile().mkdirs();
        try {
            fos = new FileOutputStream(new File(dst));
        } catch (FileNotFoundException fnfe) {
            ExceptionHandler.handleIO(SN + ".getFile", "file not found", fnfe, true);
        }
        if (fos != null) {
            try {
                boolean done = false;
                ProgressDialog.INSTANCE.setVisible(true);
                while (!done) {
                    bytesRead = in.read(buffer, 0, buffer.length);
                    if (bytesRead == -1) {
                        done = true;
                    } else {
                        fos.write(buffer, 0, bytesRead);
                        fos.flush();
                        itemTotal += bytesRead;
                        jobRead += bytesRead;
                        verboseDebug(SN + ".getFile: Wrote(1): " + bytesRead + " Total: " + itemTotal);
                        int megs = (int) (itemTotal / TecData.MEGA);
                        if (megs > oldMegs) {
                            oldMegs = megs;
                            verboseDebug(SN + ".getFile: Wrote(2): " + bytesRead + " Total: " + itemTotal);
                        }
                        //seconds = (int) ((double) (now - jobStart) / (double) 1000);
                        int jobPercent = (int) ((double) jobRead / (double) jobTotal * (double) 100);
                        int itemPercent = (int) ((double) itemTotal / (double) length * (double) 100);
                        ProgressDialog.INSTANCE.setTitle("Get: " + new File(dst).getName());
                        ProgressDialog.INSTANCE.setPercent(itemPercent);
                        oldJobPercent = jobPercent;
                    }
                    if (itemTotal == length /* && dst.length() == length */) {
                        done = true;
                    }
                }
                ProgressDialog.INSTANCE.setVisible(false);
                successful = true;
            } catch (IOException ioe) {
                ExceptionHandler.handleIO(SN + ".getFile", "copying", ioe, false);
                failed = true;
            } finally {
                try {
                    fos.close();
                    allSuccessful = true;
                } catch (IOException ioe) {
                    ExceptionHandler.handleIO(SN + ".getFile", "closing", ioe, false);
                    failed = true;
                }
            }
        } else {
            System.err.println(SN + ".getFile: failure: in: " + in + " fos: " + fos);
            SharedCode.doLogAction(log, SN + ".getFile: Failure: in: " + in + " fos: " + fos);
        }
//        doneGetFile = true;
        textOpen("getFile");
        return successful && allSuccessful && !failed;
    }

    // @Hidden
    // @HelpHide
    // @NoMultitaskingData
    // @ProvidesJobData
    // @ProvidesItemData
    public boolean does___putFile(File src) {
        binaryOpenOut("putFile");
        boolean successful = false;
        //OutputStream out = getSocket().getOutputStream();
        long oneMeg = 1024 * 1024;
        int oldMegs = 0;
        int read_count = 0;
//        fireUpdate(oldJobPercent, 0);

        int length = (int) src.length();
        if (jobTotal == 0) jobTotal = length;
        byte[] buffer = null;
        if (length > 0 && length < TNData.SIXTY_GEES) {
            buffer = new byte[length];
        } else {
            buffer = new byte[TNData.SIXTY_GEES];
        }

        int bytesRead = 0;
        long itemTotal = 0;
        FileInputStream fis = null;
        try {
            String path = src.toPath().toString();
            fis = new FileInputStream(path);
        } catch (IOException ioe) {
            SharedCode.doLogAction(log, SN + ".putFile: opening input: " + ioe);
        }
        try {
            boolean done = false;
            ProgressDialog.INSTANCE.setVisible(true);
            while (!done) {
                bytesRead = fis.read(buffer);
                if (bytesRead == -1) {
                    done = true;
                    verboseDebug(SN + ".putFile: Wrote: " + bytesRead + " Total: " + itemTotal);
                } else {
                    out.write(buffer, 0, bytesRead);
                    out.flush();
                    read_count++;
                    itemTotal += bytesRead;
                    jobRead += bytesRead;
                    int jobPercent = (int) ((double) jobRead / (double) jobTotal * (double) 100);
                    int itemPercent = (int) ((double) itemTotal / (double) length * (double) 100);
                    int megs = (int) (itemTotal / oneMeg);
                    if (megs > oldMegs || bytesRead == -1) {
                        oldMegs = megs;
                        SharedCode.doLogAction(log, SN + ".putFile: Wrote: " + bytesRead + " Total: " + itemTotal);
                    } else {
                        verboseDebug(SN + ".putFile: Wrote: " + bytesRead + " Total: " + itemTotal);
                    }
                    System.out.println("Job: " + jobPercent + " Item: " + itemPercent);
                    ProgressDialog.INSTANCE.setTitle("Put: " + new File(src).getName() + " " + itemPercent + " %");
                    ProgressDialog.INSTANCE.setPercent(itemPercent);
                    Platform.sleep(125);
                    oldJobPercent = jobPercent;
                }
            }
            ProgressDialog.INSTANCE.setVisible(false);
            successful = true;
//            fireUpdate(oldJobPercent, 100);
            SharedCode.doLogAction(log, SN + ".putFile: Wrote: " + bytesRead + " Total: " + itemTotal);
        } catch (IOException ioe) {
            ExceptionHandler.handleIO(SN + ".putFile", "reading and writing", ioe, false);
        } finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            } catch (IOException ioe) {
            } // why do anything?
        }
        textOpen("putFile");
        return successful;
    }

    public static void doLogAction(String s) {
        System.out.println(s);
    }

    public static void doLogAction(int sysStreamType, String s) {
        if (sysStreamType == TecData.SYS_ERR) {
            System.err.println(s);
        } else {
            System.out.println(s);
        }
    }

    public synchronized void doPlatformQuery() {
        sendToServer(TNData.DO_PLATFORM_QUERY,"");
        List<String> result = readFromServer(TNData.DO_PLATFORM_QUERY);
        if (result.size() == 5) {
            serverOS = result.get(0);
            fileSeparator = result.get(1);
            fileSeparatorChar = fileSeparator.charAt(0);
            lineSeparator = StringTool.unescape(result.get(2));
            pathSeparator = result.get(3);
            pathSeparatorChar = pathSeparator.charAt(0);
            serverScreenshotPath = result.get(4);
        } else {
            System.err.println(SN + ".doPlatformQuery: UNEXPECTED: " + result);
        }
    }
    
    public void doTLSConnect() throws NoTLSConnectionException {
        if (verbose) {
            System.out.println(SN + ".doTLSConnect(1): Properties: " + properties.getFilename());
            System.out.println(SN + ".doTLSConnect(2): Password:   " + TypeToType.toString(this.keyStorePass));
        }
        String ksPath = null;
        try {
            ksPath = ProjectPath.getActual(properties.get(PKIData.REMOTE_KEYSTORE));
            if (ksPath == null) {
                createDefaultProperties(properties);
                System.err.println(SN + ".doTLSConnect: Invalid configuration: " + properties.getFilename());
                System.err.println(SN + ".doTLSConnect: Please validate. Exiting.");
                System.exit(0);
            }
            if (!new File(ksPath).exists()) {
                System.err.println(SN + ".doTLSConnect: Keystore file does not exist: " + ksPath + " Exiting.");
                System.err.println(SN + ".doTLSConnect: Properties: " + properties.getFilename());
                System.exit(0);
            }
            keyStore = SecurityTool.openKeyStore(SecurityTool.JKS, ksPath, this.keyStorePass);
        } catch (UnrecoverableKeyException uke) {
            ExceptionHandler.handle(SN + ".doTLSConnect(3): ", "bad pass", uke, true);
            System.exit(0);
        } catch (Exception e) {
            ExceptionHandler.handle(SN + ".doTLSConnect(4): ", "unknown", e, true);
        }
        String tsPath = ProjectPath.getActual(properties.get(PKIData.REMOTE_TRUSTSTORE));
        if (tsPath == null) {
            createDefaultProperties(properties);
            System.err.println(SN + ".doTLSConnect: Invalid configuration: " + properties.getFilename());
            System.err.println(SN + ".doTLSConnect: Please validate. Exiting.");
            System.exit(0);
        }
        if (!new File(tsPath).exists()) {
            System.err.println(SN + ".doTLSConnect: Truststore file does not exist: " + tsPath);
            System.err.println(SN + ".doTLSConnect: Properties: " + properties.getFilename());
            System.exit(0);
        }
        trustStore = SecurityTool.openTrustStore(SecurityTool.JKS, tsPath);
        if (keyStore == null | trustStore == null) {
            System.out.println(SN + ".doTLSConnect(4): Unable to open keyStore or trustStore. Cannot continue.");
            System.out.println(SN + ".doTLSConnect(5): Keystore: " + keyStore + " Path: " + ksPath);
            System.out.println(SN + ".doTLSConnect(6): Truststore: " + trustStore + " Path: " + tsPath);
            System.out.println(SN + ".doTLSConnect(7): Verify setup and re-run: " + properties.getFilename());
            System.exit(0);
        }
        try {
            sslContext = SSLContext.getInstance(SecurityTool.TLS, SecurityTool.BCJSSE);;
            keyMgrFact = KeyManagerFactory.getInstance(SecurityTool.PKIX, SecurityTool.BCJSSE);;
            keyMgrFact.init(keyStore, this.keyStorePass);
            trustMgrFact = TrustManagerFactory.getInstance(SecurityTool.PKIX, SecurityTool.BCJSSE);
            trustMgrFact.init(trustStore);
            sslContext.init(keyMgrFact.getKeyManagers(), trustMgrFact.getTrustManagers(), null);
            fact = sslContext.getSocketFactory();
        } catch (UnrecoverableKeyException e) {
            System.out.println(SN + ".doTLSConnect(8) : Unrecoverable Key: pass: " + TypeToType.toString(this.keyStorePass));
            System.out.println(SN + ".doTLSConnect(9) : properties: " + properties.getFilename());
            System.out.println(SN + ".doTLSConnect(10): Keystore missing. Exiting.");
            System.exit(0);
        } catch (Exception e) {
            ExceptionHandler.handle(SN + "()", e);
        }
        if (properties.getBoolean("make.secure")) {
            for (int i = 0; i < this.keyStorePass.length; i++) {
                this.keyStorePass[i] = '\0';
            }
        }
        try {
            tlsSocket = (SSLSocket) fact.createSocket(host, port);
        } catch (Exception e) {
            System.err.println(SN + ".doTLSConnect: Unable to connect: properties: " + properties.getFilename());
            System.err.println(SN + ".doTLSConnect: host: " + properties.get(PKIData.REMOTE_HOST));
            throw new NoTLSConnectionException(SN + ".doTLSConnect: " + e.getMessage());
        }
    }
    
    public List<SystemToken> execForOutput(String command) {
        String op = TNData.EXEC_FOR_OUTPUT;
        sendToServer(op, command);
        return TypeToType.toListSystemToken(readFromServer(op));
    }

    public List<SystemToken> execForOutputJava(String classPath, String className, String appArgs) {
        String op = TNData.EXEC_FOR_OUTPUT_JAVA;
        sendToServer(op, classPath + TecData.TEC_SEP + className + TecData.TEC_SEP + appArgs);
        return TypeToType.toListSystemToken(readFromServer(op));
    }

    public void execSpawn(String command) {
        String op = TNData.EXEC_SPAWN;
        sendToServer(op,command);
        System.out.println(readFromServer(op));
    }
       
    public void execSpawnJava(String classPath, String className, String appArgs) {
        String op = TNData.EXEC_SPAWN_JAVA;
        sendToServer(op,classPath + TecData.TEC_SEP + className + TecData.TEC_SEP + appArgs);
        System.out.println(readFromServer(op));
    }

    public boolean exists(String path) {
        sendToServer(TNData.EXISTS,wrap(path));
        List<String> output = readFromServer(TNData.EXISTS);
        String line = output.get(0);
        String bool = line.substring(line.lastIndexOf(" ") + 1);
        return bool.equals("TRUE");
    }

    public List<String> getAll(String path) {
        sendToServer(TNData.GET_ALL, wrap(path));
        return readFromServer(TNData.GET_ALL);
    }
    
    public Properties getClientProperties() {
        return properties;
    }

    public String getClientScreenshotPath() { return clientScreenshotPath; }
    
    public String getCommsType() {
        return (encrypt ? "encrypted" : "plain-text");
    }
 
    public List<String> getDirs(String path) {
        sendToServer(TNData.GET_DIRS,StringTool.getDoubleQuoted(path));
        return readFromServer(TNData.GET_DIRS);
    }
    
    public String getDirSize(String path) {
        sendToServer(TNData.GET_DIR_SIZE, wrap(path));
        List<String> lines = readFromServer(TNData.GET_DIR_SIZE);
        String line = lines.get(0);
        return line.substring(line.lastIndexOf(" ") + 1);
    }

    public List<String> getDirSizes(String path) {
        sendToServer(TNData.GET_DIR_SIZES, wrap(path));
        List<String> lines = readFromServer(TNData.GET_DIR_SIZES);
        return lines;
    }

    public String getDOSFileAttributes(String path) {
        sendToServer(TNData.GET_DOS_FILE_ATTRIBUTES, wrap(path));
        return readFromServer(TNData.GET_DOS_FILE_ATTRIBUTES).get(0);
    }
    
    public boolean getFile(long length, File dst) {
        return does_________________getFile(length, dst.getAbsolutePath());
    }

    public List<String> getFileLines(String path) {
        sendToServer(TNData.GET_FILE_LINES,wrap(path));
        return readFromServer(TNData.GET_FILE_LINES);
    }

    public String getFileSeparator() { 
        if (serverOS == null) doPlatformQuery();
        return fileSeparator; 
    }


    public List<String> getFiles(String path) {
        sendToServer(TNData.GET_FILES,StringTool.getDoubleQuoted(path));
        return readFromServer(TNData.GET_FILES);
    }
    
    public String getHostName() { return properties.get(PKIData.REMOTE_HOST); }
    
    public String getLineSeparator() { return lineSeparator; }
    
    public String getPathSeparator() { 
        if (serverOS == null) doPlatformQuery();
        return pathSeparator; 
    }

    public String getPOSIXFilePermissions(String path) {
        String op = TNData.GET_POSIX_FILE_PERMISSIONS;
        sendToServer(op,wrap(path));
        List<String> result = readFromServer(op);
        String line = result.get(0);
        return line.substring(line.lastIndexOf(" ") + 1);
    }
    
    public String getPOSIXGroup(String path) {
        String op = TNData.GET_POSIX_GROUP;
        sendToServer(op,wrap(path));
        List<String> result = readFromServer(op);
        String line = result.get(0);
        return line.substring(line.lastIndexOf(" ") + 1);
    }
    
    public List<String> getPOSIXGroups() {
        String op = TNData.GET_POSIX_GROUPS;
        sendToServer(op,"");
        List<String> groups = readFromServer(op);
        return groups;
    } 
    
    public String getPOSIXUser(String path) {
        String op = TNData.GET_POSIX_USER;
        sendToServer(op,wrap(path));
        List<String> result = readFromServer(op);
        String line = result.get(0);
        return line.substring(line.lastIndexOf(" ") + 1);
    } 
     
    public List<String> getPOSIXUsers() {
        String op = TNData.GET_POSIX_USERS;
        sendToServer(op,"");
        List<String> users = readFromServer(op);
        return users;
    }
    
    public Properties getProperties() { return properties; }
    
    public BufferedImage getServerDesktop() {
        takeScreenshot();
        return ImageTool.getImage(new File(clientScreenshotPath));
    }
    
    public String getServerOS() { 
        if (serverOS == null) doPlatformQuery();
        return serverOS; }
    
    public List<String> getServerProperties() {
        String op = TNData.GET_SERVER_PROPERTIES;
        sendToServer(op,"");
        return readFromServer(op);
    }

    public String getServerScreenshotPath() { return serverScreenshotPath; }
    
    public Socket getSocket() {
        if (encrypt) {
            return tlsSocket;
        } else {
            return rawSocket;
        }
    }

    public Long getUsableSpace(String path) {
        sendToServer(TNData.GET_USABLE_SPACE,wrap(path));
        List<String> result = readFromServer(TNData.GET_USABLE_SPACE);
        return Long.parseLong(result.get(0));
    }
    
    public boolean hasJava(String path) {
        sendToServer(TNData.HAS_JAVA,wrap(path));
        List<String> result = readFromServer(TNData.HAS_JAVA);
        String line = result.get(0);
        return line.substring(line.lastIndexOf(" ") + 1).toUpperCase().equals("TRUE");
    }
    
    public boolean hasMatchingClass(String path) {
        String toExt = new File(path).getToExtension(true);
        return exists(toExt + "class"); // wrapped in exists()
    }

    public boolean hasMatchingJava(String path) {
        String toExt = new File(path).getToExtension(true);
        return exists(toExt + "java"); // wrapped in exists;
    }

    public boolean hasShutDownLetters(String t) {
        return t.length() == 8
                && (t.contains("S") || t.contains("s"))
                && (t.contains("H") || t.contains("h"))
                && (t.contains("U") || t.contains("u"))
                && (t.contains("T") || t.contains("t"))
                && (t.contains("D") || t.contains("d"))
                && (t.contains("O") || t.contains("o"))
                && (t.contains("W") || t.contains("w"))
                && (t.contains("N") || t.contains("n"));
    }

    public boolean isDir(String path) {
        String op = TNData.IS_DIR;
        sendToServer(op,wrap(path));
        List<String> strings = readFromServer(op);
        String line = strings.get(0);
        String boolValue = line.substring(line.lastIndexOf(" ")).trim().toLowerCase(); 
        return boolValue.equals("true");
    }

    public boolean isDirectory(String path) {
        return isDir(path); // wrapped in isDir(String path)
    }
    
    public boolean isEncrypted() {
        return encrypt;
    }

    public boolean isFile(String path) {
        String op = TNData.IS_FILE;
        sendToServer(op,wrap(path));
        List<String> strings = readFromServer(op);
        String line = strings.get(0);
        String boolValue = line.substring(line.lastIndexOf(" ")).trim().toLowerCase(); 
        return boolValue.equals("true");                        
    }

    public boolean isHeadless() {
        return serverScreenshotPath.toLowerCase().equals("null");
    }
    
    public boolean isRunning() {
        return running;
    }

    public boolean isWinServer() {
        if (serverOS == null) {
            doPlatformQuery();
        }
        return serverOS.toLowerCase().startsWith("win");
    }
    
    public String listItem(String path) {
        sendToServer(TNData.LIST_ITEM,wrap(path));
        List<String> result = readFromServer(TNData.LIST_ITEM);
        return result.get(0);
    }
    
    public List<String> listRoots() {
        sendToServer(TNData.LIST_ROOTS,"");
        return readFromServer(TNData.LIST_ROOTS);
    }
    
    public static void main(String[] args) {
        Properties properties = new ca.tecreations.Properties(ProjectPath.getTecPropsPath() + "Client.properties");
        Client client = null;
        try {
            client = new Client(properties, true, null);
        } catch (NoTLSConnectionException ntlsce) {
            System.out.println("No TLS Connection: " + ntlsce.getMessage());
        }

        if (client != null) {
            client.start();
            System.out.println("Started Client(" + properties.get(PKIData.REMOTE_HOST) + "): "
                    + properties.get(PKIData.REMOTE_PORT) + " : " + client.getCommsType());
//            List<SystemToken> tokens = client.execForOutput("/usr/lib/jvm/jdk-19/bin/java -cp /mnt/data/projects/BCTLSNetwork:/mnt/data/projects/BCTLSNetwork/jars/* ca.tecreations.BuildProject");
            //List<SystemToken> tokens = client.execForOutputJava("/mnt/data/projects/BCTLSNetwork","ca.tecreations.BuildProject","");
            //for(int i = 0; i < tokens.size();i++) tokens.get(i).println();
            
            //client.execSpawn("/usr/lib/jvm/jdk-19/bin/java -cp /mnt/data/projects/BCTLSNetwork:/mnt/data/projects/BCTLSNetwork/jars/* ca.tecreations.apps.capturetool.CaptureTool");
            //client.execSpawnJava("/mnt/data/projects/BCTLSNetwork","ca.tecreations.apps.capturetool.CaptureTool","");
//            System.out.println("isFile: " + client.isFile("/mnt/data/flag.png"));
//            System.out.println("isDir : " + client.isDir("/mnt/data"));
            String flag = "/mnt/data/flag.png";
            client.setDOSFileAttributes(flag,"rhs");
            System.out.println("Attributes: " + client.getDOSFileAttributes(flag));
            
            client.setPOSIXFilePermissions(flag,"rwxr-xr-x");
            System.out.println("Permissions: " + client.getPOSIXFilePermissions(flag));
            
        }
    } 

    public void mkdirs(String path) {
        sendToServer(TNData.MKDIRS,wrap(path));
        System.out.println(readFromServer(TNData.MKDIRS));
    }
    
    public final void openSocket() throws NoTLSConnectionException {
        Integer port = properties.getInt(PKIData.REMOTE_PORT);
        if (port == null) {
            properties.set(PKIData.REMOTE_PORT, 52820);
        } else {
            this.port = port;
        }
        try {
            if (encrypt) {
                if (keyStorePass == null) {
                    // check properties for password
                    String pass = this.properties.get(PKIData.REMOTE_KEYSTORE_PASSWORD);
                    if (pass == null || pass.toLowerCase().equals("prompt")) {
                        this.keyStorePass = Platform.requestPassword(null, "Enter the keystore pass for: host: " + host + "--[" + Internet.getWanIP() + "]:" + Internet.getLanIP() + " : " + port);
                    } else {
                        this.keyStorePass = pass.toCharArray();
                    }
                } else if (SharedCode.isPrompt(keyStorePass)) {
                    this.keyStorePass = Platform.requestPassword(null, "Enter the keystore pass for: host: " + host + "--[" + Internet.getWanIP() + "]:" + Internet.getLanIP() + " : " + port);
                }
                doTLSConnect();
            } else {
                rawSocket = new Socket(host, port);
            }
        } catch (UnknownHostException e) {
            System.err.println("Unknown host " + host);
            System.exit(1);
        } catch (IOException e) {
            System.err.println("Couldn't get I/O for the connection to " + host);
            System.exit(1);
        }
    }

    public static void print(List<String> list) {
        for (int i = 0; i < list.size(); i++) {
            System.out.println(i + ": " + list.get(i));
        }
    }

    private void process(String op, String args) {
        if (op.equals(TNData.EXEC_FOR_OUTPUT)) {
            List<SystemToken> tokens = execForOutput(args);
            for (int i = 0; i < tokens.size(); i++) {
                tokens.get(i).println();
            }
        } else if (op.equals(TNData.EXEC_FOR_OUTPUT_JAVA)) {
            List<String> parts = StringTool.explode(args," "); // order as:     classPath fqcn appArgs
            List<SystemToken> tokens = execForOutputJava(parts.get(0),parts.get(1),parts.get(2));
            for(int i = 0; i < tokens.size(); i++) {
                tokens.get(i).println();
            }
        } else if (op.equals(TNData.DO_PLATFORM_QUERY)) {
            doPlatformQuery();
        } else {
            sendToServer(op, args);
            readFromServer(op);
        }
    }
    

    public void processGET(String src, String dst) {
        String op = TNData.GET;

        // we need the file size for the ProgressListener
        String op2 = TNData.GET_FILE_SIZE;
        sendToServer(op2, StringTool.getDoubleQuoted(src));
        List<String> result = readFromServer(op2);
        String line = "";
        if (result.size() > 0) {
            line = result.get(0);
            String size = line.substring(line.lastIndexOf(" ") + 1);
            System.out.println(SN + ".processGET(" + op + "): size: " + size);

            // do the transfer
            sendToServer(op, wrap(src)); // send GET ...
            List<String> expectOK = readFromServer(op);
            if (expectOK.get(0).equals(TNData.OK)) {
                // server response should be OK
                getFile(Long.parseLong(size), new File(dst));
                expectOK = readFromServer(TNData.OK);
                if (!expectOK.get(0).equals(TNData.OK)) {
                    System.err.println(SN + ".processGET(" + op + "): !ok: " + expectOK);
                }
            } else {
                System.err.println(SN + ".processGET(" + op + "): !ok: " + expectOK);
            }
        } else System.err.println(SN + ".processGET: erroneous expectation: result: " + result);
    }

    public void processPUT(String src, String dst, Long length) {
        String op = TNData.PUT;

        // do the transfer
        sendToServer(op, wrap(dst) + " " + new File(src).length()); // send PUT ...
        List<String> expectOK = readFromServer(op);
        if (expectOK.get(0).equals(TNData.OK)) {
            // server response should be OK
            putFile(src);
            expectOK = readFromServer(op);
            if (!expectOK.get(0).equals(TNData.OK)) {
                System.err.println(SN + ".run(" + op + "): !ok(1): " + expectOK.get(0));
            }
        } else {
            System.err.println(SN + ".run(" + op + "): !ok(2): " + expectOK.get(0));
        }
    }

    public boolean putFile(String src) {
        return does___putFile(new File(src));
    }

    public List<String> readFromServer(String op) {
        List<String> lines = new ArrayList<>();
        try {
            boolean done = false;
            String output = "";
            while (output != null && !done) {
                output = inBR.readLine();
                if (output != null) {
                    if (output.length() == 1 && output.charAt(0) == '\0') {
                        done = true;
                    } else {
                        System.out.println(SN + ".readFromServer(" + op + "): " + output);
                        lines.add(output);
                    }
                }
            }
        } catch (IOException ioe) {
            ExceptionHandler.handleIO(SN + ".readFromServer(" + op + ")", "reading from server", ioe, false);
        }
        return lines;
    }

    public void rename(String oldName, String newName) {
        sendToServer(TNData.RENAME,wrap(oldName) + " " + wrap(newName));
        System.out.println(readFromServer(TNData.RENAME));
    }
    
    public void run() {
        while (running) {
            String userInput;
            try {
                System.err.println("Enter a command:");
                while ((userInput = stdIn.readLine()) != null) {
                    String trimmed = userInput.trim();
                    System.err.println(SN + ".run:console: got: " + trimmed);
                    if (!trimmed.equals("")) {
                        String op;
                        String args = null;
                        int spaceIndex = trimmed.indexOf(" ");
                        if (spaceIndex > 0) {
                            op = trimmed.substring(0, spaceIndex);
                            args = trimmed.substring(spaceIndex + 1);
                        } else {
                            op = trimmed;
                        }
                        op = op.toUpperCase();

                        String src = null;
                        String dst = null;
                        String remainder = null;
                        if (args != null) {
                            if (StringTool.hasFile(args)) {
                                String[] srcArray = StringTool.getFileAndTrimmedRemainder(args);
                                src = srcArray[0];
                                remainder = srcArray[1];
                                if (StringTool.hasFile(remainder)) {
                                    String[] dstArray = StringTool.getFileAndTrimmedRemainder(remainder);
                                    dst = dstArray[0];
                                    remainder = dstArray[1];
                                }
                            } else {
                                remainder = args;
                            }
                        }

                        if (op.equals("QUIT") | op.equals("EXIT")) {
                            System.exit(0);
                        } else if (hasShutDownLetters(op)) {
                            shutdown();
                        } else if (op.equals(TNData.GET)) {
                            ProgressDialog progress = new ProgressDialog(null);
                            progress.setTitle("PUT: " + src);
                            progress.setLocationRelativeTo(null);
                            progress.setVisible(true);
                            processPUT(src, dst, new File(src).length());
                            progress.setVisible(false);
                            progress.dispose();
                            System.gc();
                        } else {
                            process(op, args);
                        }
                    }
                }
                System.err.println("Enter a command:");
            } catch (IOException ioe) {
                ExceptionHandler.handleIO(SN + ".run", "reading user input", ioe, false);
            }
        }
    }

    public void sendMouseClick(Mouse m) {
        sendToServer(TNData.SEND_MOUSE_CLICK,m.toString());
        readFromServer(TNData.SEND_MOUSE_CLICK);
    }
    
    public void sendMouseDown(Mouse m) {
        sendToServer(TNData.SEND_MOUSE_DOWN,m.toString());
        readFromServer(TNData.SEND_MOUSE_DOWN);
    }
    
    public void sendMouseDrag(Drag d) {
        sendToServer(TNData.SEND_MOUSE_DRAG,d.toString());
        readFromServer(TNData.SEND_MOUSE_DRAG);
    }
    
    public void sendMouseMove(Point p) {
        sendToServer(TNData.SEND_MOUSE_MOVE,p.x + "," + p.y);
        readFromServer(TNData.SEND_MOUSE_MOVE);
    }
    
    public void sendMouseUp(Mouse m) {
        sendToServer(TNData.SEND_MOUSE_UP,m.toString());
        readFromServer(TNData.SEND_MOUSE_UP);
    }
    
    public void sendToServer(String op, String args) {
        outPW.println(op + " " + args);
    }
    
    public String setDOSFileAttributes(String path, String attr) {
        String op = TNData.SET_DOS_FILE_ATTRIBUTES;
        sendToServer(op, wrap(path) + " " + attr);
        List<String>  output = readFromServer(op);
        String line = output.get(0);
        return line.substring(line.lastIndexOf(" ") + 1);
    }

    public String setExcecutable(String path, boolean canExec) {
        String op = TNData.SET_EXECUTABLE;
        sendToServer(op,wrap(path) + " " + canExec);
        List<String>  output = readFromServer(op);
        String line = output.get(0);
        return line.substring(line.lastIndexOf(" ") + 1);
    }
    public String setPOSIXFilePermissions(String path, String permissions) {
        String op = TNData.SET_POSIX_FILE_PERMISSIONS;
        sendToServer(op, wrap(path) + " " + permissions);
        List<String>  output = readFromServer(op);
        String line = output.get(0);
        return line.substring(line.lastIndexOf(" ") + 1);
    }
    

    public String setPOSIXGroup(String path, String group) {
        String op = TNData.SET_POSIX_GROUP;
        sendToServer(TNData.SET_POSIX_GROUP,wrap(path) + " " + group);
        List<String>  output = readFromServer(op);
        String line = output.get(0);
        return line.substring(line.lastIndexOf(" ") + 1);
    }

    public String setPOSIXUser(String path, String user) {
        String op = TNData.SET_POSIX_USER;
        sendToServer(op,wrap(path) + " " + user);
        List<String>  output = readFromServer(op);
        String line = output.get(0);
        return line.substring(line.lastIndexOf(" ") + 1);
    }

    public String setReadable(String path, boolean canRead) {
        String op = TNData.SET_READABLE;
        sendToServer(op,wrap(path) + " " + canRead);
        List<String>  output = readFromServer(op);
        String line = output.get(0);
        return line.substring(line.lastIndexOf(" ") + 1);
    }
    
    public String setWritable(String path, boolean canWrite) {
        String op = TNData.SET_WRITABLE;
        sendToServer(op,wrap(path) + " " + canWrite);
        List<String>  output = readFromServer(op);
        String line = output.get(0);
        return line.substring(line.lastIndexOf(" ") + 1);
    }

    public void shutdown() {
        String op = TNData.SHUTDOWN;
        process(op, "");
        readFromServer(op);
        System.exit(0);
    }

    @Override
    public void start() {
        running = true;
        super.start();
    }

    public synchronized void takeScreenshot() {
        sendToServer(TNData.TAKE_SCREENSHOT,"");
        List<String> reply = readFromServer(TNData.TAKE_SCREENSHOT);
        processGET(serverScreenshotPath,clientScreenshotPath);
    }
    
    public void textClose() {
        outPW.close();
        try {
            inISR.close();
        } catch (IOException ioe) {
            ExceptionHandler.handle(SN + "closeText", "closing inISR", ioe, false);
        }
        try {
            inBR.close();
        } catch (IOException ioe) {
            ExceptionHandler.handle(SN + "closeText", "closing inBR", ioe, false);
        }
    }

    public void textOpen(String caller) {
        try {
            outPW = new PrintWriter(getSocket().getOutputStream(), true);
        } catch (IOException ioe) {
            ExceptionHandler.handleIO(SN + ".textOpen(" + caller + ")", "opening outPW", ioe, false);
        }
        try {
            inISR = new InputStreamReader(getSocket().getInputStream());
        } catch (IOException ioe) {
            ExceptionHandler.handleIO(SN + ".textOpen(" + caller + ")", "opening inISR", ioe, false);
        }
        inBR = new BufferedReader(inISR);
    }

    public void waitFor(String op, String args) {

    }

    public void verboseDebug(String s) {
        if (debug && verbose) {
            doLogAction(s);
        }
    }

    public String wrap(String s) {
        return StringTool.getDoubleQuoted(s);
    }
    
}
