package ca.tecreations.graphics;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
/**
 *
 * @author Tim
 */
public class WebExtractorMenuBar extends JMenuBar implements ActionListener {
    WebExtractor app;
    
    JMenu operations = new JMenu("Operations");
    JMenuItem startRunning = new JMenuItem("Start Running");
    JMenuItem stopRunning = new JMenuItem("Stop Running");
    JMenuItem recapture = new JMenuItem("Recapture");
    JMenuItem extract = new JMenuItem("Extract");
    JMenuItem magnifySample = new JMenuItem("Magnify Sample");
    JMenuItem magnifyTarget = new JMenuItem("Magnify Target");
    JMenuItem process = new JMenuItem("Process");
    
    public WebExtractorMenuBar(WebExtractor app) {
        this.app = app;
        
        add(operations);
        operations.add(startRunning);
        operations.add(stopRunning);
        operations.addSeparator();
        operations.add(recapture);
        operations.add(extract);
        operations.add(magnifySample);
        operations.add(magnifyTarget);
        operations.add(process);
        startRunning.addActionListener(this);
        stopRunning.addActionListener(this);
        recapture.addActionListener(this);
        extract.addActionListener(this);
        magnifySample.addActionListener(this);
        magnifyTarget.addActionListener(this);
        process.addActionListener(this);
    }
    
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == startRunning) {
            app.start();
        } else if (e.getSource() == stopRunning) {
            app.stopRunning();
        } else if (e.getSource() == recapture) {
            app.recapture();
        } else if (e.getSource() == extract) {
            app.extract();
        } else if (e.getSource() == magnifySample) {
            app.magnify(app.getSampleImage());
        } else if (e.getSource() == magnifyTarget) {
            app.magnify(app.getTargetImage());
        } else if (e.getSource() == process) {
            app.process(app.getImageToProcess());
        } 
    }
    
    
}
